# 🍎 Instructions Build Mac - Correction Zones

## ✅ Problème Identifié

- **Fonctionne** : Unity Editor sur Mac
- **Ne fonctionne pas** : App compilée en plein écran Mac
- **Cause** : Ratio d'écran différent (MacBook = 16:10, jeu = 16:9)

---

## 🔧 SOLUTION 1 : Forcer 1920x1080 dans Player Settings (RECOMMANDÉ)

### **Étapes dans Unity :**

1. **Edit** → **Project Settings** → **Player**

2. **Section "Resolution and Presentation"** :
   
   **Pour Mac :**
   - Cliquer sur l'onglet **Mac** (icône pomme 🍎)
   
   **Configurer :**
   - ✅ `Fullscreen Mode` : **Fullscreen Window** (pas Exclusive)
   - `Default Screen Width` : **1920**
   - `Default Screen Height` : **1080**
   - ✅ Cocher `Resizable Window` (permettre changement de taille)
   - ✅ Décocher `Use Player Log` OU le laisser coché pour avoir des logs

3. **Build & Run** → Tester

### **Pourquoi ça marche :**
- Force la résolution au démarrage
- Le jeu s'affichera en 1920x1080 même si l'écran Mac est plus grand
- Les zones correspondront exactement

---

## 🔧 SOLUTION 2 : Logs dans le Build

Pour voir les logs dans l'app compilée :

### **Option A : Player Log (Mac)**

Les logs Unity Mac sont dans :
```
~/Library/Logs/[CompanyName]/[ProductName]/Player.log
```

**Pour y accéder :**
1. Finder → Menu **Go** (Aller)
2. Maintenir **Option** (⌥) → Cliquer **Library**
3. Naviguer vers `Logs/[VotreCompany]/[VotreJeu]/Player.log`
4. Ouvrir avec Console.app ou TextEdit

### **Option B : Fichier Log Personnalisé**

Activer le système de log dans un fichier accessible.

---

## 🔧 SOLUTION 3 : Debug Visuel (Sans Logs)

Pour voir les coordonnées directement dans le jeu.

---

## 🎯 TEST RAPIDE (Recommandé)

### **Build de Test avec Fenêtre Resizable**

1. **Player Settings** :
   - `Fullscreen Mode` : **Windowed**
   - `Default Screen Width` : **1920**
   - `Default Screen Height` : **1080**
   - ✅ `Resizable Window` : **true**

2. **Build & Run**

3. **L'app démarre en 1920x1080 fenêtré**

4. **Tester les zones** → Ça devrait marcher

5. **Si ça marche** :
   - Option A : Garder en fenêtré
   - Option B : Passer en fullscreen avec `Fullscreen Window` (qui respecte le ratio)

---

## 🔍 Diagnostic Alternatif

Si même en forçant 1920x1080 ça ne marche pas :

### **Vérifier la résolution effective :**

1. Ajouter le script `ForceResolution.cs` à la scène
2. Activer `Show Debug Logs` = true
3. Build & Run
4. Le texte jaune en haut à gauche affichera la résolution réelle
5. Vérifier dans Player.log si la résolution est bien 1920x1080

---

## 📋 Checklist Build Mac

**Avant de Build :**
- [ ] Player Settings → Mac → Default Resolution = 1920x1080
- [ ] Fullscreen Mode = Fullscreen Window (ou Windowed pour test)
- [ ] `ForceResolution` script ajouté (optionnel, backup)
- [ ] Scènes dans Build Settings (menu, Map, Player, shooting, calculator)

**Après Build :**
- [ ] Lancer l'app
- [ ] Vérifier résolution (texte jaune si `ForceResolution` actif)
- [ ] Tester zones
- [ ] Si problème → Consulter Player.log

---

## 🎮 Touches de Debug à Ajouter

Pour faciliter le test sans recompiler :

- **Cmd+F** : Toggle fullscreen/windowed
- **Cmd+R** : Afficher résolution actuelle
- **Cmd+D** : Afficher zones de debug

---

## 🆘 Si Ça Ne Marche Toujours Pas

### **Test Ultime :**

1. Dans Unity, passer l'éditeur en mode **Standalone** (pas Play Mode)
2. Changer la résolution de l'éditeur à 1920x1080
3. Tester → Ça marche ?
   - Oui → Confirme que c'est un problème de résolution
   - Non → Autre problème

### **Partager :**
1. Contenu du `Player.log`
2. Résolution affichée (si `ForceResolution` actif)
3. Modèle de MacBook et résolution native

---

## 💡 Solution Permanente

### **Option A : Forcer Ratio (Restrictif)**
- Build avec résolution fixe 1920x1080
- Simple, fonctionne toujours
- Moins flexible

### **Option B : Améliorer Algorithme (Flexible)**
- Corriger `TargetZone.cs` pour gérer tous les ratios
- Plus complexe
- Meilleure UX

**Recommandation** : Commencer par Option A pour confirmer, puis Option B si besoin.

---

**Date** : 21 Octobre 2025
**Statut** : Test build Mac requis avec résolution forcée

