# 🖥️ Guide : Forcer la Résolution 1920x1080

## 🎯 Pourquoi Forcer la Résolution ?

### **Avantages** ✅
1. **Élimine les problèmes de scaling** → Pas de letterboxing/pillarboxing
2. **Coordonnées directes** → Les zones JSON correspondent exactement à l'écran
3. **Simplifie le debug** → On identifie si le problème vient du ratio ou d'autre chose
4. **Cohérence cross-platform** → Même comportement Mac/Windows

### **Inconvénients** ⚠️
1. **Peut être flou** sur certains écrans (MacBook Retina)
2. **Moins flexible** pour différentes résolutions d'écran
3. **UX non optimale** pour petits écrans ou écrans ultra-larges

---

## 🔧 SOLUTION 1 : Script ForceResolution (Recommandé pour Tester)

### **Étape 1 : Ajouter le Script aux Scènes**

Le script `ForceResolution.cs` a été créé. Ajoutez-le à vos scènes de jeu :

1. **Ouvrir la scène `shooting`** (ou `Player`)
2. **Créer un GameObject vide** :
   - Clic droit dans la Hierarchy → Create Empty
   - Nommer : `ResolutionManager`
3. **Ajouter le script** :
   - Sélectionner `ResolutionManager`
   - Dans l'Inspector, cliquer **Add Component**
   - Rechercher et ajouter `ForceResolution`
4. **Configurer** :
   - ✅ `Force Resolution` = **true**
   - `Target Width` = **1920**
   - `Target Height` = **1080**
   - `Fullscreen` = **true** (ou false pour fenêtré)
   - ✅ `Show Debug Logs` = **true**

### **Étape 2 : Répéter pour Autres Scènes**

- Ajouter aussi dans `calculator` si problème similaire
- **Pas nécessaire** dans `menu` et `Map` (pas de zones précises)

### **Étape 3 : Tester**

1. Lancer un jeu sur Mac
2. Vérifier les logs dans la Console :
   ```
   [ForceResolution] Résolution forcée à 1920x1080
   [ForceResolution] Ratio final: 1.778 (16:9)
   ```
3. **Tester les zones** : Survoler/cliquer
4. Regarder l'affichage en haut à gauche (infos résolution)

---

## 🔧 SOLUTION 2 : Player Settings (Pour Build Final)

### **Dans Unity Editor**

1. **Edit** → **Project Settings** → **Player**
2. Section **Resolution and Presentation**
3. **Standalone Player Options** :
   - `Fullscreen Mode` : **Fullscreen Window** ou **Exclusive Fullscreen**
   - `Default Screen Width` : **1920**
   - `Default Screen Height` : **1080**
   - ✅ Cocher `Run In Background`
4. **Mac Specifique** :
   - Onglet **Mac** (icône pomme)
   - Configurer pareil

### **Avantage**
- S'applique automatiquement à tous les builds
- Pas besoin de script

### **Inconvénient**
- L'utilisateur ne peut pas changer la résolution facilement

---

## 🔧 SOLUTION 3 : Canvas Scaler (Pour UI Responsive)

Si vous voulez garder la flexibilité mais améliorer le scaling des zones :

### **Configurer le Canvas Principal**

1. **Sélectionner le Canvas** dans la scène `shooting`
2. Dans l'Inspector, composant **Canvas Scaler** :
   - `UI Scale Mode` : **Scale With Screen Size**
   - `Reference Resolution` : **1920 x 1080**
   - `Screen Match Mode` : **Match Width Or Height**
   - `Match` : **0.5** (balance entre largeur et hauteur)
   
### **Pourquoi ça aide ?**
- L'UI s'adapte proportionnellement
- Les coordonnées restent cohérentes
- Fonctionne sur différents ratios

---

## 🧪 TESTS À EFFECTUER

### **Test 1 : Avec ForceResolution (Diagnostic)**

**Sur Mac :**
1. Ajouter script `ForceResolution` à la scène `shooting`
2. Lancer le jeu
3. **Vérifier Console** :
   - Résolution forcée à 1920x1080 ?
   - Ratio = 1.778 ?
4. **Tester les zones** :
   - Survoler les zones de réponse
   - Cliquer les zones
   - **Regarder logs** `[TargetZone/MAC]`
5. **Résultat** :
   - ✅ Si ça marche → Le problème vient du scaling multi-résolution
   - ❌ Si ça ne marche pas → Le problème est ailleurs (coordonnées, événements)

### **Test 2 : Sans ForceResolution (Baseline)**

**Sur Mac :**
1. Désactiver `Force Resolution` dans l'Inspector
2. Relancer le jeu en **résolution native Mac**
3. Tester les zones
4. **Comparer avec Test 1**

### **Test 3 : Plein Écran vs Fenêtré**

**Sur Mac :**
1. Avec `ForceResolution` activé
2. Tester en **mode fenêtré** (`Fullscreen = false`)
3. Tester en **mode plein écran** (`Fullscreen = true`)
4. Comparer les comportements

---

## 📊 Diagnostic Selon Résultats

### **Cas 1 : ✅ Zones OK avec ForceResolution, ❌ KO sans**
→ **Le problème vient du scaling multi-résolution**
→ **Solution** : Améliorer l'algorithme de `TargetZone.cs`
→ Ou garder `ForceResolution` pour la version Mac

### **Cas 2 : ❌ Zones KO même avec ForceResolution**
→ **Le problème est ailleurs**
→ **Solutions possibles** :
   - Coordonnées Y inversées sur Mac
   - EventSystem qui ne détecte pas les clics
   - Zones JSON incorrectes
   - Canvas bloquant les raycast

### **Cas 3 : ✅ Zones OK en fenêtré, ❌ KO en plein écran**
→ **Problème spécifique au mode plein écran Mac**
→ Peut être lié aux Retina displays ou Metal API

---

## 🔍 Debug Supplémentaire

### **Afficher Visuellement les Zones**

Si même avec 1920x1080 les zones ne fonctionnent pas, ajoutez ceci dans `TargetZone.cs` :

```csharp
void OnDrawGizmos()
{
    if (zoneData == null) return;
    
    // Dessiner un rectangle aux limites de la zone
    Vector3[] corners = new Vector3[4];
    // ... calcul des coins en fonction de zoneData
    Gizmos.color = Color.green;
    // ... dessiner
}
```

Ou utiliser le paramètre `showDebugZones` déjà présent dans `GameManager`.

---

## 💡 Recommandation Finale

### **Pour Diagnostic Immédiat** 🔴
1. ✅ **Ajouter `ForceResolution`** à la scène `shooting`
2. ✅ **Activer `Show Debug Logs`**
3. ✅ **Tester sur Mac**
4. 📋 **Partager les résultats** (zones OK ou KO ?)

### **Pour Solution Permanente** 🟢

**Si ça marche avec ForceResolution :**
- Option A : Garder le script pour Mac
- Option B : Améliorer l'algorithme `TargetZone.cs` pour mieux gérer les ratios
- Option C : Forcer 16:9 dans Player Settings

**Si ça ne marche pas :**
- Analyser les logs `[TargetZone/MAC]` en détail
- Vérifier EventSystem et raycast
- Tester coordonnées manuellement

---

## 📝 Checklist Rapide

- [ ] Script `ForceResolution.cs` créé
- [ ] Ajouté à la scène `shooting`
- [ ] Configuré (1920x1080, fullscreen, debug ON)
- [ ] Testé sur Mac
- [ ] Logs vérifiés
- [ ] Zones testées (survol + clic)
- [ ] Résultats documentés

---

## 🆘 Besoin d'Aide ?

Si les zones ne fonctionnent toujours pas après avoir forcé 1920x1080 :

1. **Partager** :
   - Logs `[ForceResolution]`
   - Logs `[TargetZone/MAC]`
   - Résolution finale affichée
2. **Préciser** :
   - Zones OK ou KO ?
   - Plein écran ou fenêtré ?
   - MacBook (modèle ?)

---

**Date** : 21 Octobre 2025
**Objectif** : Diagnostiquer problème zones Mac avec résolution fixe

