# 🖥️ Guide : Plein Écran avec Letterboxes (Ratio 16:9 Forcé)

## 🎯 Solution Professionnelle

Votre jeu sera **toujours en 16:9**, peu importe l'écran :
- **MacBook 16:10** → Bandes horizontales (haut/bas)
- **Écran ultra-large 21:9** → Bandes verticales (gauche/droite)
- **Écran 16:9** → Aucune bande, plein écran parfait

✅ **Résultat** : Les zones fonctionnent toujours car le ratio est constant !

---

## 🔧 INSTALLATION (5 minutes)

### **Étape 1 : Ajouter le Script à la Caméra Principale**

1. **Ouvrir la scène `shooting`** (ou `Player`)

2. **Sélectionner la caméra principale** :
   - Dans la Hierarchy → Trouver `Main Camera` (ou `mainCamera`)

3. **Ajouter le composant** :
   - Dans l'Inspector → **Add Component**
   - Rechercher `CameraAspectRatioEnforcer`
   - Cliquer pour ajouter

4. **Configurer** (devrait être bon par défaut) :
   - `Target Aspect Width` : **16**
   - `Target Aspect Height` : **9**
   - `Letterbox Color` : **Noir** (0, 0, 0, 255)
   - ✅ `Show Debug Logs` : **true** (pour tester)

### **Étape 2 : Répéter pour Autres Scènes**

Ajouter aussi à :
- Scène `calculator` (caméra principale)
- Scène `menu` (si caméra)
- Scène `Map` (si caméra)

### **Étape 3 : Configurer Player Settings**

1. **Edit** → **Project Settings** → **Player**

2. **Onglet Mac** 🍎 :
   - `Fullscreen Mode` : **Fullscreen Window** (recommandé)
     - OU **Exclusive Fullscreen** (selon préférence)
   - `Default Screen Width` : **1920** (optionnel)
   - `Default Screen Height` : **1080** (optionnel)
   - ✅ `Use Player Log` : **true** (pour debug)

3. **Onglet Windows** (si vous buildez aussi pour PC) :
   - Pareil

### **Étape 4 : Build & Test**

1. **File** → **Build Settings**
2. Sélectionner **Mac**
3. **Build and Run**
4. **Observer** :
   - Le jeu démarre en plein écran
   - Des bandes noires apparaissent (si MacBook 16:10)
   - La zone de jeu est au centre en 16:9

---

## 🧪 TEST RAPIDE dans l'Éditeur

**Avant de build** :

1. Dans Unity, ouvrir la scène `shooting`
2. Mode **Play** ▶️
3. Regarder la **Console** :
   ```
   [AspectRatio] Écran: 2560x1600, Ratio: 1.600
   [AspectRatio] Cible: 1.778
   [AspectRatio] Letterboxes (barres horizontales)
   ```
4. **Voir les bandes noires** en haut/bas dans la vue Game
5. **Tester les zones** → Elles devraient marcher !

**Pour simuler différents ratios** :
- Dans l'onglet **Game** (Unity Editor)
- Dropdown en haut : **Free Aspect** → Choisir **16:10** ou **21:9**
- Observer les bandes s'adapter automatiquement

---

## 📊 Comment Ça Marche

### **Principe**

Le script `CameraAspectRatioEnforcer` modifie le **viewport** de la caméra :

```
Écran complet :     Camera.rect = (0, 0, 1, 1)
Avec letterboxes :  Camera.rect = (0, 0.1, 1, 0.8)
                    ↑            ↑   ↑   ↑   ↑
                    X            Y   W   H (normalisés 0-1)
```

### **Calcul Automatique**

```
Ratio écran     = Screen.width / Screen.height
Ratio cible     = 16 / 9 = 1.778

Si ratio écran > ratio cible :
  → Écran trop large → Pillarboxes (gauche/droite)
  
Si ratio écran < ratio cible :
  → Écran trop haut → Letterboxes (haut/bas)
  
Si ratio écran = ratio cible :
  → Parfait ! Aucune bande
```

### **Bandes Noires UI**

Le script crée automatiquement un Canvas avec des rectangles noirs pour :
- Couvrir les zones hors caméra
- Bloquer les clics sur ces zones
- Donner un rendu professionnel

---

## ✅ Avantages de Cette Solution

| Aspect | Avantage |
|--------|----------|
| **Zones** | ✅ Fonctionnent toujours (ratio constant) |
| **UX** | ✅ Professionnel (comme Netflix, jeux AAA) |
| **Flexibilité** | ✅ S'adapte à tous les écrans |
| **Performance** | ✅ Aucun impact (calcul simple) |
| **Debug** | ✅ Logs clairs |
| **Build Mac** | ✅ Fonctionne out-of-the-box |

---

## 🔍 Troubleshooting

### **Problème : Pas de bandes visibles**

**Cause** : L'écran est déjà en 16:9
**Solution** : C'est normal ! Vérifier les logs :
```
[AspectRatio] ✅ Ratio parfait, pas de bandes
```

### **Problème : Bandes mais zones ne marchent pas**

**Diagnostic** :
1. Vérifier que `TargetZone.SetReferenceResolution(1920, 1080)` est appelé
2. Consulter logs `[TargetZone/MAC]`
3. Le ratio de la caméra est bien 16:9 ?

### **Problème : Bandes trop grandes/petites**

**Ajustement** :
- Changer `Target Aspect Width/Height` si besoin
- Ex : 16:10 → width=16, height=10

### **Problème : UI coupée par les bandes**

**Solution** :
- Vérifier que vos Canvas UI utilisent **Screen Space - Overlay**
- OU ajustent leurs éléments dans la zone safe (16:9)
- Le script crée les bandes avec `sortingOrder = -1000` (derrière tout)

---

## 🎨 Personnalisation

### **Changer la Couleur des Bandes**

Dans l'Inspector du script :
- `Letterbox Color` → Choisir une couleur
- Exemples :
  - Noir : (0, 0, 0, 255) - Standard
  - Gris foncé : (20, 20, 20, 255)
  - Bleu marine : (10, 10, 30, 255)

### **Ratio Différent de 16:9**

Si votre jeu utilise un autre ratio :
- `Target Aspect Width` : 4
- `Target Aspect Height` : 3
- → Ratio 4:3 (vieux écrans)

Ou :
- Width : 21
- Height : 9
- → Ratio 21:9 (ultra-wide)

### **Désactiver Temporairement**

Décocher le script dans l'Inspector → Ratio libre

---

## 📋 Checklist Complète

**Configuration** :
- [ ] Script ajouté sur caméra principale (shooting)
- [ ] Script ajouté sur caméra (calculator)
- [ ] Ratio configuré : 16:9
- [ ] Player Settings : Fullscreen Window
- [ ] Debug logs activés (pour test)

**Test Éditeur** :
- [ ] Mode Play → Bandes visibles ?
- [ ] Console → Logs aspect ratio OK ?
- [ ] Changer Free Aspect → Bandes s'adaptent ?

**Test Build Mac** :
- [ ] Build & Run
- [ ] Plein écran activé ?
- [ ] Bandes visibles sur MacBook ?
- [ ] Zones fonctionnent ? ✅
- [ ] Player.log consulté si problème

---

## 🚀 Prochaines Étapes

Après avoir configuré :

1. **Build Mac avec le script**
2. **Tester sur MacBook**
3. **Les zones devraient fonctionner** car :
   - Ratio fixe 16:9
   - Coordonnées toujours cohérentes
   - Pas de calculs complexes de letterboxing dans `TargetZone.cs`

4. **Si ça marche** ✅ :
   - Désactiver `Show Debug Logs`
   - Garder en production
   - Profiter !

5. **Si ça ne marche toujours pas** ❌ :
   - Consulter `Player.log`
   - Partager logs `[AspectRatio]` et `[TargetZone/MAC]`
   - On investigera plus en profondeur

---

## 💡 Bonus : Cmd+F pour Toggle Fullscreen

Le script `DebugOverlay.cs` permet déjà de faire **Cmd+F** pour basculer fullscreen/fenêtré en jeu. Pratique pour tester !

---

## 📝 Notes Techniques

### **Pourquoi Camera.rect ?**

Unity permet de restreindre le rendu de la caméra à une portion de l'écran :
- `rect.x, rect.y` : Position normalisée (0-1)
- `rect.width, rect.height` : Taille normalisée (0-1)

Le reste de l'écran reste noir (ou `Camera.backgroundColor`).

### **Ordre de Rendu**

1. Caméra rend dans son `rect` (zone 16:9)
2. Bandes UI noires couvrent le reste (`sortingOrder = -1000`)
3. UI de jeu au-dessus (ordre normal)

### **Compatibilité**

- ✅ Mac (Metal)
- ✅ Windows (DirectX)
- ✅ Linux
- ✅ WebGL (avec limitations)

---

**Date** : 21 Octobre 2025
**Objectif** : Plein écran avec ratio 16:9 forcé via letterboxes
**Résultat attendu** : Zones fonctionnent sur tous les écrans Mac

