# 📖 GUIDE PRINCIPAL - JEU DE TIR QCM UNITY

**Date** : 21 octobre 2025  
**Version** : 2.0 - Synthèse complète

---

## 🎯 VUE D'ENSEMBLE DU PROJET

**Type** : Jeu de tir QCM 2D en Unity  
**Plateformes** : Windows, macOS, WebGL  
**Résolution de référence** : 1920x1080 (16:9)  
**Input System** : Nouveau Input System Unity

### Architecture
```
Menu → Map (carte interactive) → Player (dialogues) → Game (shooting QCM)
```

---

## ⚙️ CONFIGURATION RAPIDE

### 1. Fichiers de configuration principaux

| Fichier | Emplacement | Rôle |
|---------|-------------|------|
| `general-config.json` | `StreamingAssets/` | Configuration globale du projet |
| `maps-registry.json` | `StreamingAssets/json/` | Liste des maps disponibles |
| `map-*.json` | `StreamingAssets/json/` | Configuration de chaque map |
| `Q*.json` | `StreamingAssets/json/` | Configuration des niveaux de jeu |

### 2. Scripts essentiels

| Script | Rôle |
|--------|------|
| `GeneralConfigManager.cs` | Charge la config globale |
| `GameManager.cs` | Gère le jeu de tir |
| `MapManager.cs` | Gère la carte interactive |
| `CrosshairManager.cs` | Gère le viseur personnalisé |
| `GunSpriteManager.cs` | Gère le pistolet |
| `EscapeKeyHandler.cs` | Navigation ESC |

---

## 🔧 CORRECTIONS RÉCENTES (21 OCT 2025)

### ✅ Problème #1 : Mac - Configuration non chargée

**Symptôme** : Crosshair et gun invisibles sur Mac, erreur 404

**Cause** : `UnityWebRequest` échoue avec `file:///` sur Mac

**Solution** : `GeneralConfigManager.cs` détecte Mac au runtime et utilise `File.ReadAllText()`

**Vérification** :
```
[GeneralConfigManager] 🍎 Détection Mac/iOS - Utilisation de File.ReadAllText
[GeneralConfigManager] ✅ Configuration chargée avec succès (Mac/iOS)!
```

---

### ✅ Problème #2 : Zones décalées en plein écran

**Symptôme** : Sur portable ou ratio différent, le crosshair ne correspond pas aux zones cliquables

**Cause** : Pas de gestion des letterbars/pillarboxes en plein écran

**Solution** : `TargetZone.cs` calcule maintenant les offsets des barres noires

**Vérification** :
```
[GameManager] ✅ Résolution de référence configurée: 1920x1080
[GameManager] Résolution écran actuelle: 2560x1440
[GameManager] Ratio de référence: 1.778
[GameManager] Ratio écran: 1.778
```

---

### ✅ Problème #3 : Navigation avec touche ESC

**Solution** : Nouveau script `EscapeKeyHandler.cs`

**Installation** :

**Scène Player/shooting** :
```
GameObject → Create Empty → "EscapeKeyHandler"
Add Component → EscapeKeyHandler
Configuration :
  - Action: BackToMenu
  - Menu Scene Name: menu
Sauvegarder (Ctrl+S)
```

**Scène menu** :
```
GameObject → Create Empty → "EscapeKeyHandler"
Add Component → EscapeKeyHandler
Configuration :
  - Action: QuitGame
Sauvegarder (Ctrl+S)
```

**Résultat** :
- ESC dans le jeu → Retour au menu
- ESC dans le menu → Quitte le jeu

---

## 🎮 UTILISATION

### Lancer le projet

1. **Ouvrir Unity** (2021.3 ou supérieur)
2. **Ouvrir la scène Menu** (`Scenes/menu.unity`)
3. **Play** (`Ctrl+P`)

### Navigation

| Scène | Fonction |
|-------|----------|
| **Menu** | Sélection de la carte |
| **Map** | Navigation entre les niveaux |
| **Player** | Dialogues avant/après le jeu |
| **Game** | Jeu de tir QCM |

### Touches

| Touche | Action |
|--------|--------|
| **Clic souris** | Tirer / Sélectionner |
| **ESC** | Retour menu (jeu) / Quitter (menu) |
| **F11** (debug) | Diagnostic Mac |
| **F12** (debug) | Diagnostic map |

---

## 🛠️ CONFIGURATION DU JEU

### Structure JSON d'un niveau

```json
{
  "gameConfig": {
    "resolution": {
      "width": 1920,
      "height": 1080
    },
    "background": {
      "videoUrl": "background.mp4"
    },
    "assets": {
      "crosshair": "curseur_neon.png",
      "gun": "vide.png",
      "impact": "impact_splash.png",
      "ledOff": "led_black.png",
      "ledGreen": "led_green.png",
      "ledRed": "led_red.png"
    },
    "sounds": {
      "impact": "impact.mp3",
      "success": "success.mp3",
      "fail": "fail.mp3"
    },
    "crosshairConfig": {
      "alwaysShowCrosshair": true,
      "defaultSize": 75,
      "onTargetSizeMultiplier": 1.0,
      "offTargetSizeMultiplier": 0.75,
      "onTargetAlpha": 1.0,
      "offTargetAlpha": 0.3
    },
    "gunConfig": {
      "offsetFromCursor": { "x": 200, "y": -300 },
      "gunSize": { "x": 900, "y": 466 },
      "alwaysVisible": true,
      "boundary": {
        "enableBoundaryConstraints": true,
        "marginLeft": -200,
        "marginRight": -800,
        "marginTop": 400,
        "marginBottom": -600
      }
    }
  },
  "questions": [
    {
      "id": 1,
      "question": "Votre question ?",
      "answers": [
        {
          "text": "Réponse 1",
          "isCorrect": true,
          "zone": { "x": 100, "y": 200, "width": 300, "height": 400 }
        }
      ]
    }
  ]
}
```

### Configuration globale (general-config.json)

```json
{
  "projectName": "Un Jour Sans Assurance / Seroni",
  "version": "1.0.0",
  "defaultMapId": "map-Q2",
  
  "assetsPaths": {
    "crosshairPath": "https://.../images/crosshair/",
    "gameAssetsPath": "https://.../images/",
    "videoPath": "https://.../videos/",
    "dialoguePath": "STREAMING_ASSETS/json/",
    "questionsPath": "STREAMING_ASSETS/questions/"
  },
  
  "defaultResolution": {
    "width": 1920,
    "height": 1080
  }
}
```

---

## 🐛 DÉPANNAGE

### Problème : Crosshair/Gun invisibles

**Sur Mac** :
1. Vérifier les logs : chercher `🍎 Détection Mac/iOS`
2. Si absent → `GeneralConfigManager.cs` pas à jour

**Sur Windows** :
1. Vérifier `general-config.json` existe dans `StreamingAssets/`
2. Vérifier `crosshairPath` défini dans le JSON

**Logs attendus** :
```
[GeneralConfigManager] ✅ Configuration chargée avec succès!
[GeneralConfigManager] ✅ crosshairPath: https://.../images/crosshair/
[MacImageLoader] ✅ Texture chargée: 512x512
[CrosshairManager] ✅ Sprite appliqué et rendu visible
```

---

### Problème : Zones décalées en plein écran

**Solution** : Vérifier la résolution de référence dans le JSON

1. Ouvrir le fichier niveau (`Q0J1.json`, etc.)
2. Vérifier la section `resolution` :
```json
"resolution": {
  "width": 1920,
  "height": 1080
}
```
3. Les valeurs doivent correspondre à la résolution utilisée pour définir les zones

**Logs attendus** :
```
[GameManager] ✅ Résolution de référence configurée: 1920x1080
[GameManager] Résolution écran actuelle: 2560x1440
```

---

### Problème : Écran noir sur la map

**Solutions** :

1. **Vérifier GeneralConfigManager dans la scène Map** :
   - Doit exister un GameObject avec le script `GeneralConfigManager`

2. **Vérifier UnifiedLoadingManager dans la scène Map** :
   - Doit exister un GameObject avec le script `UnifiedLoadingManager`

3. **Si persiste, ajouter** `FixMacBlackScreenMap` :
   ```
   GameObject → Create Empty → "FixMacBlackScreen"
   Add Component → FixMacBlackScreenMap
   Configuration :
     - Force Hide Loading After: 5
     - Verbose Logs: ✓
   ```

---

### Problème : Voile blanc sur les dialogues (Mac)

**Solution** : Ajouter `MacCompatibilityFix` dans la scène Player

```
GameObject → Create Empty → "MacCompatibilityFix"
Add Component → MacCompatibilityFix
Configuration :
  - Enable Diagnostic: ✓
  - Fix White Veil: ✓
  - Fix Missing Assets: ✓
Sauvegarder
```

---

## 🔍 VÉRIFICATIONS AVANT BUILD

### Checklist Build Settings

- [ ] Toutes les scènes sont dans Build Settings :
  - [ ] menu.unity (index 0)
  - [ ] Map.unity (index 1)
  - [ ] Player.unity (index 2)
  - [ ] shooting.unity (si utilisée)

### Checklist Assets

- [ ] `StreamingAssets/general-config.json` existe
- [ ] `StreamingAssets/json/maps-registry.json` existe
- [ ] Tous les JSON de maps et niveaux sont présents
- [ ] Les URLs dans les JSON sont accessibles

### Checklist Scripts

- [ ] Pas d'erreurs de compilation
- [ ] `GeneralConfigManager` dans chaque scène
- [ ] `EscapeKeyHandler` dans scènes Player et menu
- [ ] Input System configuré (Project Settings → Player → Active Input Handling)

---

## 📊 ARCHITECTURE TECHNIQUE

### Flux de chargement

```
1. Menu
   ↓ (Clic sur carte)
2. Map
   ↓ (Clic sur niveau)
3. Player (dialogue BEFORE optionnel)
   ↓
4. Game (shooting QCM)
   ↓
5. Player (dialogue AFTER optionnel)
   ↓
6. Map (retour)
```

### Système de configuration

```
GeneralConfigManager (Singleton)
  ↓
Charge general-config.json
  ↓
Fournit les chemins d'assets aux autres managers
  ↓
GameManager, MapManager, etc. utilisent ces chemins
```

### Système de détection des zones

```
1. GameManager lit la résolution depuis le JSON
2. Configure TargetZone.SetReferenceResolution()
3. TargetZone calcule les offsets des letterbars
4. IsPointInScreenZone() convertit coordonnées écran → JSON
5. Détection précise quelque soit la résolution
```

---

## 📚 DOCUMENTATION TECHNIQUE DÉTAILLÉE

Pour plus d'informations sur des sujets spécifiques :

| Sujet | Document |
|-------|----------|
| Système de chargement | `Documentation_Système_Chargement.md` |
| Architecture launcher | `Scripts/ARCHITECTURE_LAUNCHER.md` |
| Configuration logs | `Scripts/LogConfiguration.md` |

---

## 🔄 HISTORIQUE DES VERSIONS

### Version 2.0 (21 octobre 2025)
- ✅ Fix Mac : Détection runtime + File.ReadAllText
- ✅ Fix zones décalées : Calcul letterbars/pillarboxes
- ✅ Ajout navigation ESC
- ✅ Configuration résolution depuis JSON
- 📝 Documentation synthétisée

### Version 1.0 (avant octobre 2025)
- Système de jeu de tir QCM fonctionnel
- Carte interactive
- Système de dialogues
- Chargement depuis JSON

---

## 🆘 SUPPORT

### Logs importants à vérifier

**Démarrage** :
```
[GeneralConfigManager] Platform: OSXEditor / WindowsEditor
[GeneralConfigManager] ✅ Configuration chargée avec succès!
```

**Chargement niveau** :
```
[GameManager] ✅ Résolution de référence configurée: 1920x1080
[MacImageLoader] ✅ Texture chargée: 512x512
[CrosshairManager] ✅ Sprite appliqué et rendu visible
```

**Problèmes courants** :
```
❌ [GeneralConfigManager] Erreur lors du chargement
   → Fichier general-config.json manquant ou invalide

❌ [MacImageLoader] Code HTTP: 404
   → URL incorrecte dans le JSON

❌ [GameManager] ⚠️ Résolution de référence non définie
   → Ajouter section "resolution" dans le JSON du niveau
```

---

## 💡 BONNES PRATIQUES

### Création d'un nouveau niveau

1. Dupliquer un JSON existant (ex: `Q0J1.json`)
2. Modifier les questions et zones
3. Vérifier la résolution de référence (1920x1080 généralement)
4. Tester en mode fenêtré puis plein écran
5. Vérifier les logs pour les erreurs

### Définition des zones

1. Utiliser toujours la même résolution de référence
2. Coordonnées en pixels depuis le coin haut-gauche
3. Format : `{ "x": 100, "y": 200, "width": 300, "height": 400 }`
4. Tester avec différents ratios d'écran

### Déploiement

1. **Windows** : Build normal, fonctionne directement
2. **Mac** : Build avec support Metal, tester le chargement de config
3. **WebGL** : Utiliser serveur web, vérifier CORS

---

**FIN DU GUIDE PRINCIPAL**

Pour des questions spécifiques, consulter les documents techniques dans `Scripts/` ou ouvrir un ticket avec les logs complets.

