mergeInto(LibraryManager.library, {
  // ─────────────────────────────────────────────────────────────
  //  VIDÉO HTML5 AU-DESSUS DU CANVAS UNITY
  // ─────────────────────────────────────────────────────────────
  WVO_Create: function (urlPtr, fitPtr, loop, muted) {
    var url = UTF8ToString(urlPtr);
    var fit = UTF8ToString(fitPtr);

    // Calque vidéo (au-dessus du canvas)
    var layer = document.getElementById('video-overlay') || (function () {
      var c = document.getElementById('unity-container');
      var o = document.createElement('div');
      o.id = 'video-overlay';
      o.style.position = 'absolute';
      o.style.inset = '0';
      o.style.zIndex = '5';
      (c || document.body).appendChild(o);
      return o;
    })();

    // Détruire l’ancienne vidéo si présente
    if (Module.WVO_video) {
      try { Module.WVO_video.remove(); } catch (e) {}
      Module.WVO_video = null;
    }

    // Créer l’élément <video>
    var vid = document.createElement('video');
    Object.assign(vid, {
      src: url,
      playsInline: true,
      autoplay: false,
      controls: false,
      loop: !!loop,
      muted: !!muted,
      preload: 'auto',
      crossOrigin: 'anonymous'
    });
    Object.assign(vid.style, {
      position: 'absolute',
      inset: '0',
      width: '100%',
      height: '100%',
      objectFit: fit,
      zIndex: '5',
      pointerEvents: 'none',
      background: '#000'
    });

    layer.appendChild(vid);
    vid.addEventListener('loadedmetadata', function () {
      console.log('[WVO] loadedmetadata', vid.videoWidth + 'x' + vid.videoHeight);
    });
    vid.addEventListener('error', function (e) {
      console.warn('[WVO] video error', e, vid.error);
    });

    Module.WVO_video = vid;
  },

  WVO_Play: function () {
    var v = Module.WVO_video;
    if (!v) return;
    var p = v.play();
    if (p && p.catch) p.catch(function (e) { console.warn('[WVO] play blocked', e); });
  },

  WVO_Dispose: function () {
    var v = Module.WVO_video;
    if (v) { try { v.remove(); } catch (e) {} Module.WVO_video = null; }
  },

  WVO_SetObjectFit: function (fitPtr) {
    var v = Module.WVO_video;
    if (v) v.style.objectFit = UTF8ToString(fitPtr);
  },

  // ─────────────────────────────────────────────────────────────
  //  OVERLAY TEXTE (DOM) — versions "brut" et "HTML"
  // ─────────────────────────────────────────────────────────────
  UI_SetSpeaker: function (ptr) {
    var s = UTF8ToString(ptr || 0) || "";
    var el = document.getElementById('dom-speaker');
    if (el) el.textContent = s;
  },
  UI_SetSubtitle: function (ptr) {
    var s = UTF8ToString(ptr || 0) || "";
    var el = document.getElementById('dom-subtitle');
    if (el) el.textContent = s;
  },
  UI_SetSpeakerHtml: function (ptr) {
    var s = UTF8ToString(ptr || 0) || "";
    var el = document.getElementById('dom-speaker');
    if (el) el.innerHTML = s;
  },
  UI_SetSubtitleHtml: function (ptr) {
    var s = UTF8ToString(ptr || 0) || "";
    var el = document.getElementById('dom-subtitle');
    if (el) el.innerHTML = s;
  },
  UI_SetVisible: function (visible) {
    var ov = document.getElementById('dom-overlay');
    if (ov) ov.style.display = visible ? '' : 'none';
  },

  // ─────────────────────────────────────────────────────────────
  //  OVERLAY IMAGE (DOM) — robust fallback + cache handling
  // ─────────────────────────────────────────────────────────────
  UI_ShowOverlayImage: function (urlPtr, fadeMs, skipFadeIfSame) {
    var input = UTF8ToString(urlPtr || 0) || "";
    var wrap  = document.getElementById('img-overlay');
    var img   = document.getElementById('dom-img');
    if (!wrap || !img) return;

    // garantir visibilité/z-index
    wrap.style.display = '';
    wrap.style.zIndex  = '12';
    img.crossOrigin    = 'anonymous';

    // base absolue (chemin de l’index)
    function baseOf(href){ return (href||location.href).replace(/[?#].*$/,'').replace(/\/[^/]*$/,'/'); }
    var ROOT = baseOf(document.baseURI);
    function abs(u){ return /^https?:\/\//i.test(u) ? u : (ROOT + u); }

    // Construire la liste des candidats
    var list = [];
    if (!input) {
      wrap.classList.remove('show'); img.dataset.src=''; img.removeAttribute('src'); return;
    }
    if (/^https?:\/\//i.test(input)) {
      list = [ input ];                            // URL absolue
    } else if (input.startsWith('StreamingAssets/')) {
      list = [ abs(input) ];                       // chemin direct depuis StreamingAssets
    } else {
      // nom simple : essaye d’abord dans Images/, puis à la racine de StreamingAssets/
      var base = input.replace(/\.[a-z0-9]+$/i, '');
      var hasExt = /\.[a-z0-9]+$/i.test(input);
      var paths = [
        'StreamingAssets/Images/' + (hasExt ? input : base),
        'StreamingAssets/'        + (hasExt ? input : base)
      ];
      var exts  = hasExt ? [''] : ['.png','.jpg','.jpeg','.webp','.gif'];
      for (var p of paths) for (var e of exts) list.push(abs(p + e));
    }

    console.log('[DOM IMG] request:', input, 'candidates:', list);

    var i = 0, ms = (fadeMs || 220) | 0;

    function apply(url){
  img.dataset.src = url;
  // reset + reflow pour (re)déclencher la transition proprement
  img.style.transition = 'none';
  img.style.opacity = '0';
  void img.offsetWidth;

  // montre l’overlay
  wrap.classList.add('show');

  // et force aussi l’inline à 1 (certains navigateurs gardent l’inline à 0)
  img.style.transition = 'opacity '+ms+'ms ease-out, transform '+ms+'ms ease-out';
  requestAnimationFrame(function(){ img.style.opacity = '1'; });
}


    function tryNext(){
      if (i >= list.length) {
        console.warn('[DOM IMG] not found for', input);
        wrap.classList.remove('show');
        return;
      }
      var url = list[i++];

      // même image que la phrase précédente → pas de fondu si demandé
      if (img.dataset.src === url && !!skipFadeIfSame) {
        wrap.classList.add('show');
        return;
      }

      wrap.classList.remove('show');
      img.style.opacity = '0';

      img.onload = function(){
        console.log('[DOM IMG] loaded:', url, img.naturalWidth+'x'+img.naturalHeight);
        apply(url);
      };
      img.onerror = function(){
        console.warn('[DOM IMG] failed:', url);
        tryNext();
      };

      img.src = url;

      // si l’image est déjà en cache, certains navigateurs ne déclenchent pas onload
      if (img.complete && img.naturalWidth > 0) {
        console.log('[DOM IMG] cache hit:', url);
        apply(url);
      }
    }

    tryNext();
  },

  UI_HideOverlayImage: function (fadeMs) {
    var wrap = document.getElementById('img-overlay');
    var img  = document.getElementById('dom-img');
    if (!wrap || !img) return;
    wrap.classList.remove('show');
    var ms = (fadeMs || 180) | 0;
    setTimeout(function(){ img.dataset.src=''; img.removeAttribute('src'); }, ms + 30);
  }
});
