# 🎮 JEU DE TIR QCM - UNITY

**Version 2.0** | 21 octobre 2025

Jeu éducatif de tir avec questions à choix multiples développé sous Unity.

---

## 🚀 DÉMARRAGE RAPIDE

1. **Ouvrir Unity** (2021.3+)
2. **Ouvrir la scène** `Scenes/menu.unity`
3. **Play** → Tester !

---

## 📖 DOCUMENTATION

| Document | Description |
|----------|-------------|
| **[GUIDE_PRINCIPAL.md](GUIDE_PRINCIPAL.md)** | 📘 **LIRE EN PREMIER** - Guide complet |
| [Documentation_Système_Chargement.md](Documentation_Système_Chargement.md) | Système de chargement unifié |
| [Scripts/GUIDE_BUILD_SETTINGS.md](Scripts/GUIDE_BUILD_SETTINGS.md) | Configuration des builds |
| [Scripts/ARCHITECTURE_LAUNCHER.md](Scripts/ARCHITECTURE_LAUNCHER.md) | Architecture technique |
| [Scripts/LogConfiguration.md](Scripts/LogConfiguration.md) | Configuration des logs |

---

## ✅ CORRECTIONS RÉCENTES

### 21 octobre 2025

- ✅ **Mac** : Fix chargement configuration (détection runtime)
- ✅ **Zones** : Fix décalage en plein écran (letterbars)
- ✅ **Navigation** : Ajout touche ESC (menu/quitter)
- 📝 **Documentation** : Synthétisée et organisée

**Tous les détails** → [GUIDE_PRINCIPAL.md](GUIDE_PRINCIPAL.md)

---

## 🎯 CONFIGURATION MINIMALE

**Pour ajouter la navigation ESC** (5 min) :

**Scène Player** :
```
GameObject → Create Empty → "EscapeKeyHandler"
Add Component → EscapeKeyHandler
Config : Action = BackToMenu, Menu Scene Name = menu
```

**Scène Menu** :
```
GameObject → Create Empty → "EscapeKeyHandler"
Add Component → EscapeKeyHandler
Config : Action = QuitGame
```

---

## 🐛 DÉPANNAGE RAPIDE

| Problème | Solution |
|----------|----------|
| Crosshair/Gun invisibles sur Mac | Vérifier logs : chercher `🍎 Détection Mac/iOS` |
| Zones décalées plein écran | Vérifier `resolution` dans JSON niveau |
| Écran noir sur map | Vérifier `GeneralConfigManager` dans scène |
| ESC ne fonctionne pas | Ajouter `EscapeKeyHandler` dans scènes |

**Plus de détails** → [GUIDE_PRINCIPAL.md](GUIDE_PRINCIPAL.md) section Dépannage

---

## 📁 STRUCTURE DU PROJET

```
Assets/
├── Scenes/               # Scènes Unity
│   ├── menu.unity       # Menu principal
│   ├── Map.unity        # Carte interactive
│   └── Player.unity     # Dialogues + Jeu
├── Scripts/             # Scripts C#
│   ├── Managers/        # Gestionnaires principaux
│   ├── Game/            # Logique de jeu
│   └── UI/              # Interface utilisateur
├── StreamingAssets/     # Configuration JSON
│   ├── general-config.json
│   └── json/            # Maps et niveaux
└── GUIDE_PRINCIPAL.md   # 📘 Documentation complète
```

---

## 🔧 TECHNOLOGIES

- **Unity** 2021.3+
- **Input System** Nouveau système Unity
- **URP** (Universal Render Pipeline)
- **TextMeshPro** pour les textes
- **JSON** pour la configuration

---

## 📊 COMPATIBILITÉ

| Plateforme | Statut | Notes |
|------------|--------|-------|
| **Windows** | ✅ Testé | Fonctionne parfaitement |
| **macOS** | ✅ Testé | Fix appliqué (oct 2025) |
| **WebGL** | ⚠️ À tester | Vérifier CORS |
| **Mobile** | ❌ Non testé | Input tactile à adapter |

---

## 💡 LIENS UTILES

- **Guide principal** : [GUIDE_PRINCIPAL.md](GUIDE_PRINCIPAL.md)
- **Problèmes Mac** : [GUIDE_PRINCIPAL.md](GUIDE_PRINCIPAL.md#-dépannage) section Mac
- **Build Settings** : [Scripts/GUIDE_BUILD_SETTINGS.md](Scripts/GUIDE_BUILD_SETTINGS.md)

---

## 📝 NOTES IMPORTANTES

### ⚠️ Avant de build

1. Vérifier que toutes les scènes sont dans Build Settings
2. Vérifier `StreamingAssets/general-config.json` existe
3. Tester en mode fenêtré ET plein écran
4. Vérifier les logs (pas d'erreurs)

### 🔍 Logs importants

Au démarrage, vous devez voir :
```
[GeneralConfigManager] ✅ Configuration chargée avec succès!
[GameManager] ✅ Résolution de référence configurée: 1920x1080
```

Si absent → Consulter [GUIDE_PRINCIPAL.md](GUIDE_PRINCIPAL.md)

---

**Développé avec ❤️ en Unity**

**Version** : 2.0 (21 octobre 2025)  
**Dernière mise à jour** : Corrections Mac + Zones + Navigation

