using System;
using UnityEngine;

[System.Serializable]
public class GeneralConfig
{
    [Header("Informations générales")]
    public string projectName;
    public string version;
    public string defaultMapId;
    public string mapsRegistryUrl;
    
    [Header("Chemins des Assets")]
    public AssetsPathsConfig assetsPaths;
    
    [Header("Valeurs par Défaut")]
    public DefaultAssets defaultAssets;
    public ColorPalette colorPalette;
    public DefaultPopupConfig defaultPopupConfig;
    public DefaultHeaderConfig defaultHeaderConfig;
    public DefaultFeedbackMessages defaultFeedbackMessages;
    public DefaultUIConfig defaultUIConfig;
    public DefaultResolution defaultResolution;
    public DefaultCrosshairConfig defaultCrosshairConfig;
    public DefaultGunConfig defaultGunConfig;
    public DefaultZoneDecorator defaultZoneDecorator;
    public AnimationTimings animations;
    
    [Header("Configuration Debug")]
    public GeneralDebugConfig debug;
    
    [Header("Configuration UI")]
    public GeneralUIConfig ui;
    
    [Header("Configuration Gameplay")]
    public GeneralGameplayConfig gameplay;
    
    [Header("Paramètres futurs")]
    public GeneralFutureSettingsConfig futureSettings;
}

[System.Serializable]
public class AssetsPathsConfig
{
    public string popupVideoPath;
    public string decoratorImagePath;
    public string videoPath;
    public string backgroundImagePath;
    public string backgroundVideoPath;
    public string uiPath;
    public string crosshairPath;
    public string gameAssetsPath;
    public string dialoguePath;
    public string questionsPath;
    public string mapsPath;
}

[System.Serializable]
public class GeneralDebugConfig
{
    public bool showDebugZones;
    public bool enableDebugLogs;
}

[System.Serializable]
public class GeneralUIConfig
{
    public float loadingDelay;
    public int crosshairSortingOrder;
    public int gunSortingOrder;
}

[System.Serializable]
public class GeneralGameplayConfig
{
    public bool enableDirectClick;
    public bool enableCrosshair;
}

[System.Serializable]
public class GeneralFutureSettingsConfig
{
    public string comment;
}

// ==========================================
// CLASSES POUR LES VALEURS PAR DÉFAUT
// ==========================================

[System.Serializable]
public class DefaultAssets
{
    public string ledOff;
    public string ledGreen;
    public string ledRed;
    public string impactEffect;
    public string defaultCrosshair;
    public string zoneDecorator;
    public string focusIndicator;
}

[System.Serializable]
public class ColorPalette
{
    public string primary;
    public string secondary;
    public string success;
    public string error;
    public string background;
    public string backgroundDark;
    public string text;
    public string textDark;
    public string transparent;
    public string semiTransparent;
    public string overlay;
}

[System.Serializable]
public class DefaultPopupConfig
{
    public int width;
    public int height;
    public string backgroundColor;
    public string borderColor;
    public int borderWidth;
    public string textPosition;
    public float textPaddingTop;
    public float textPaddingBottom;
    public float textPaddingLeft;
    public float textPaddingRight;
    public float textHeight;
    public float textFontSize;
    public string textColor;
    public string textBackgroundColor;
    public float textPaddingHorizontal;
    public float showDelay;
    public float fadeSpeed;
    public string buttonText;
    public float buttonHeight;
    public float buttonWidth;
    public float buttonFontSize;
    public string buttonTextColor;
    public string buttonBackgroundColor;
    public float buttonBottomMargin;
}

[System.Serializable]
public class DefaultHeaderElement
{
    public string imageUrl;
    public Vector2 position;
    public Vector2 size;
    public bool clickable;
    public string targetAction;
}

[System.Serializable]
public class DefaultHeaderConfig
{
    public bool show;
    public float height;
    public string backgroundColor;
    public DefaultHeaderElement leftElement;
    public DefaultHeaderElement rightElement;
}

[System.Serializable]
public class DefaultFeedbackMessages
{
    public string correctAnswerMessage;
    public string incorrectAnswerMessage;
    public bool showResultMessage;
    public bool resultMessageInBold;
    public string resultMessageColor;
    public string incorrectMessageColor;
    public float resultMessageSize;
    public string separator;
    public bool showSeparatorLine;
    public bool changeBackgroundColor;
    public bool useBackgroundImage;
    public string successBackgroundImageUrl;
    public string failureBackgroundImageUrl;
    public float backgroundImageAlpha;
    public bool stretchToFitPanel;
    public bool useCustomPanelSize;
    public Vector2 panelSize;
    public string explanationTextColor;
    public float explanationTextSize;
    public bool explanationTextBold;
    public bool centerTextInPanel;
}

[System.Serializable]
public class DefaultUIBands
{
    public bool showBands;
    public float bandHeight;
    public string bandColor;
    public float bandAlpha;
    public int sortingOrder;
}

[System.Serializable]
public class DefaultLEDConfig
{
    public float ledSize;
    public float ledSpacing;
    public float marginLeft;
    public float verticalOffset;
    public bool useCustomSprites;
    public bool enableLEDAnimation;
}

[System.Serializable]
public class DefaultQuestionDisplay
{
    public float fontSize;
    public string fontColor;
    public bool fontBold;
    public string alignment;
    public float marginTop;
    public float marginLeft;
    public float marginRight;
    public int sortingOrder;
    public bool useCustomPosition;
    public bool adaptToScreenSize;
    public float minFontSize;
    public float maxFontSize;
}

[System.Serializable]
public class DefaultUIConfig
{
    public float hoverTextSize;
    public string hoverTextColor;
    public bool hoverTextBold;
    public DefaultHoverPanelSize hoverPanelSize;
    public string hoverBackgroundColor;
    public float hoverBackgroundAlpha;
    public bool useCustomPosition;
    public Vector2 customPosition;
    public DefaultUIBands bands;
    public DefaultLEDConfig ledConfig;
    public DefaultQuestionDisplay questionDisplay;
}

[System.Serializable]
public class DefaultHoverPanelSize
{
    public float width;
    public float height;
}

[System.Serializable]
public class DefaultResolution
{
    public int width;
    public int height;
}

[System.Serializable]
public class DefaultCrosshairConfig
{
    public float defaultSize;
    public float minSize;
    public float maxSize;
    public bool allowPlayerResize;
    public bool alwaysShowCrosshair;
    public float onTargetSizeMultiplier;
    public float offTargetSizeMultiplier;
    public float onTargetAlpha;
    public float offTargetAlpha;
    public float sizeTransitionSpeed;
    public float alphaTransitionSpeed;
    public bool smoothTransitions;
}

[System.Serializable]
public class DefaultGunBoundary
{
    public bool enableBoundaryConstraints;
    public bool useAutomaticMargins;
    public float marginLeft;
    public float marginRight;
    public float marginTop;
    public float marginBottom;
}

[System.Serializable]
public class DefaultGunConfig
{
    public Vector2 offsetFromCursor;
    public float size;
    public Vector2 gunSize;
    public bool flipHorizontally;
    public bool enableRotation;
    public float rotationOffset;
    public bool alwaysVisible;
    public float fadeSpeed;
    public bool hideDuringFeedback;
    public DefaultGunBoundary boundary;
}

[System.Serializable]
public class DefaultZoneDecorator
{
    public string imageUrl;
    public Vector2 size;
    public int sortingOrder;
}

[System.Serializable]
public class AnimationTimings
{
    public float fadeInDuration;
    public float fadeOutDuration;
    public float transitionDuration;
    public float quickTransition;
    public float loadingDelay;
}
