using UnityEngine;
using UnityEngine.SceneManagement;

/// <summary>
/// Script de diagnostic pour débugger les écrans noirs
/// À attacher temporairement dans la scène Player
/// </summary>
public class DiagnosticSceneInfo : MonoBehaviour
{
    void Start()
    {
        Debug.Log("=== DIAGNOSTIC SCÈNE ===");
        Debug.Log($"Scène active: {SceneManager.GetActiveScene().name}");
        Debug.Log($"Temps écoulé: {Time.time}s");
        
        // PlayerPrefs
        Debug.Log("\n--- PLAYERPREFS ---");
        Debug.Log($"GameConfigUrl: '{PlayerPrefs.GetString("GameConfigUrl", "VIDE")}'");
        Debug.Log($"GamePhase: '{PlayerPrefs.GetString("GamePhase", "VIDE")}'");
        Debug.Log($"CurrentLevelId: '{PlayerPrefs.GetString("CurrentLevelId", "VIDE")}'");
        Debug.Log($"CurrentLevelType: '{PlayerPrefs.GetString("CurrentLevelType", "VIDE")}'");
        Debug.Log($"DialogueBeforeUrl: '{PlayerPrefs.GetString("DialogueBeforeUrl", "VIDE")}'");
        
        // Composants dans la scène
        Debug.Log("\n--- COMPOSANTS PRÉSENTS ---");
        
        var gameConfigLoader = FindFirstObjectByType<GameConfigLoader>();
        Debug.Log($"GameConfigLoader: {(gameConfigLoader != null ? "✅ PRÉSENT" : "❌ ABSENT")}");
        
        var gameLauncher = FindFirstObjectByType<GameLauncher>();
        Debug.Log($"GameLauncher: {(gameLauncher != null ? "✅ PRÉSENT" : "❌ ABSENT")}");
        
        var subtitleManager = FindFirstObjectByType<SubtitleManager>();
        Debug.Log($"SubtitleManager: {(subtitleManager != null ? "✅ PRÉSENT" : "❌ ABSENT")}");
        
        var dialoguePlayer = FindFirstObjectByType<DialoguePlayer>();
        Debug.Log($"DialoguePlayer: {(dialoguePlayer != null ? "✅ PRÉSENT" : "❌ ABSENT")}");
        
        var canvas = FindFirstObjectByType<Canvas>();
        Debug.Log($"Canvas: {(canvas != null ? "✅ PRÉSENT" : "❌ ABSENT")}");
        
        var videoPlayer = FindFirstObjectByType<UnityEngine.Video.VideoPlayer>();
        Debug.Log($"VideoPlayer: {(videoPlayer != null ? "✅ PRÉSENT" : "❌ ABSENT")}");
        
        var camera = Camera.main;
        Debug.Log($"Camera.main: {(camera != null ? "✅ PRÉSENT" : "❌ ABSENT")}");
        if (camera != null)
        {
            Debug.Log($"  - Position: {camera.transform.position}");
            Debug.Log($"  - Background: {camera.backgroundColor}");
            Debug.Log($"  - Clear Flags: {camera.clearFlags}");
        }
        
        Debug.Log("\n=== FIN DIAGNOSTIC ===");
    }
    
    void Update()
    {
        // Touche F12 pour refaire un diagnostic
        if (Input.GetKeyDown(KeyCode.F12))
        {
            Start();
        }
    }
}

