using System;
using System.Collections.Generic;
using UnityEngine;

[Serializable]
public class MapConfigWrapper
{
    public MapConfigData mapConfig;
}

[Serializable]
public class MapDecorativeVideo
{
    public string id;
    public string videoUrl;
    public Vector2Data position;
    public Vector2Data size;
    public bool loop = true;
    public bool autoPlay = true;
}

[Serializable]
public class MapDecorativeImage
{
    public string id;
    public string imageUrl;
    public Vector2Data position;
    public Vector2Data size;
    public int sortingOrder = 5;
}

[Serializable]
public class MapConfigData
{
    public MapBackgroundConfig background;
    public ZoneDecorator zoneDecorator;
    public MapHeaderConfig header;
    public MapPopupConfig popupConfig;
    public List<MapDecorativeVideo> decorativeVideos;
    public List<MapStep> steps;  // NOUVEAU: Liste des steps
}

// NOUVEAU: Définition d'un step
[Serializable]
public class MapStep
{
    public string id;
    public string type;  // "zones" ou "fullscreen_video"
    public string nextStepId;  // ID du step suivant (null si c'est le dernier)

    // Pour type = "zones"
    public List<MapZone> zones;
    public List<MapDecorativeImage> decorativeImages;  // Images décoratives spécifiques à ce step

    // Pour type = "fullscreen_video"
    public string videoUrl;
    public bool skipable = true;
    public bool autoAdvance = true;  // Passer au step suivant automatiquement à la fin
}

[Serializable]
public class MapBackgroundConfig
{
    public string type;
    public string url;
}

[Serializable]
public class MapHeaderConfig
{
    public bool show = true;
    public float height = 120f;
    public string backgroundColor = "#00000000";
    public MapHeaderElement leftElement;
    public MapHeaderElement rightElement;
}

[Serializable]
public class MapHeaderElement
{
    public string imageUrl;
    public Vector2Data position;
    public Vector2Data size;
    public bool clickable;
    public string targetAction;
}

[Serializable]
public class MapPopupConfig
{
    public int width = 500;
    public int height = 500;
    public string backgroundColor = "#000000EE";
    public string borderColor = "#FFFFFF";
    public int borderWidth = 3;
    public string textPosition = "top";
    public int textHeight = 100;
    public float textPaddingTop = 5f;
    public float textPaddingBottom = 5f;
    public float textPaddingLeft = 10f;
    public float textPaddingRight = 10f;
    public int textFontSize = 22;
    public string textColor = "#FFFFFF";
    public string textBackgroundColor = "#2A2A2ACC";
    public int textPaddingHorizontal = 0;
    public float showDelay = 0.3f;
    public float fadeSpeed = 0.2f;
    public string buttonText = "JOUER";
    public int buttonHeight = 60;
    public int buttonWidth = 200;
    public int buttonFontSize = 24;
    public string buttonTextColor = "#FFFFFF";
    public string buttonBackgroundColor = "#4CAF50FF";
    public int buttonBottomMargin = 20;
}

[Serializable]
public class MapZone
{
    public string id;
    public Vector2Data position;
    public Vector2Data size;
    public string targetLevelId;
    public string debugColor;
    public bool hasPopup;
    public string popupVideo;
    public string popupText;
    public bool popupClickable;
    public string buttonText;
    public string decoratorImageUrl;
    public Vector2Data decoratorSize;
}

[Serializable]
public class Vector2Data
{
    public float x;
    public float y;

    public Vector2 ToVector2()
    {
        return new Vector2(x, y);
    }
}

[Serializable]
public class ZoneDecorator
{
    public string imageUrl;
    public Vector2Data size;
    public int sortingOrder = 10;
}