using UnityEngine;
using UnityEngine.UI;

public class MapHeaderElementUI : MonoBehaviour
{
    private MapHeaderElement elementData;
    private MapManager mapManager;
    private RectTransform rectTransform;
    private Image image;
    private Button button;

    public void Initialize(MapHeaderElement data, MapManager manager)
    {
        elementData = data;
        mapManager = manager;
        rectTransform = GetComponent<RectTransform>();
        image = GetComponent<Image>();

        if (data.clickable)
        {
            button = gameObject.AddComponent<Button>();
            button.transition = Selectable.Transition.ColorTint;
            button.targetGraphic = image;

            ColorBlock colors = button.colors;
            colors.normalColor = Color.white;
            colors.highlightedColor = new Color(0.9f, 0.9f, 0.9f, 1f);
            colors.pressedColor = new Color(0.7f, 0.7f, 0.7f, 1f);
            button.colors = colors;

            button.onClick.AddListener(OnClick);
        }
    }

    void OnClick()
    {
        if (mapManager != null && elementData != null)
        {
            mapManager.OnHeaderElementClick(elementData.targetAction);
        }
    }

    public void SetSprite(Sprite sprite)
    {
        if (image != null)
        {
            image.sprite = sprite;
        }
    }
}