using UnityEngine;
using UnityEngine.UI;

public class MapZoneClickable : MonoBehaviour
{
    private MapZone zoneData;
    private MapManager mapManager;
    private RectTransform rectTransform;
    private Image debugImage;

    public void Initialize(MapZone data, MapManager manager)
    {
        zoneData = data;
        mapManager = manager;
        rectTransform = GetComponent<RectTransform>();
        debugImage = GetComponent<Image>();

        if (debugImage != null && !string.IsNullOrEmpty(data.debugColor))
        {
            if (ColorUtility.TryParseHtmlString(data.debugColor, out Color debugColor))
            {
                debugImage.color = debugColor;
            }
        }
    }

    public bool IsPointInside(Vector2 screenPoint)
    {
        return RectTransformUtility.RectangleContainsScreenPoint(rectTransform, screenPoint, null);
    }

    public void OnClick()
    {
        if (mapManager != null && zoneData != null && !zoneData.hasPopup)
        {
            mapManager.LaunchLevel(zoneData.targetLevelId);
        }
    }

    public MapZone GetZoneData()
    {
        return zoneData;
    }
}