using UnityEngine;

/// <summary>
/// Script de test pour vérifier que la configuration générale améliorée fonctionne correctement
/// Attachez ce script à un GameObject dans votre scène pour tester
/// </summary>
public class TestGeneralConfig : MonoBehaviour
{
    [Header("Appuyez sur les touches pour tester")]
    [Tooltip("T = Test complet | C = Test couleurs | P = Test popup | A = Test assets")]
    public bool showInstructions = true;

    void Update()
    {
        // Test complet
        if (Input.GetKeyDown(KeyCode.T))
        {
            TestComplete();
        }

        // Test couleurs
        if (Input.GetKeyDown(KeyCode.C))
        {
            TestColorPalette();
        }

        // Test popup config
        if (Input.GetKeyDown(KeyCode.P))
        {
            TestPopupConfig();
        }

        // Test assets
        if (Input.GetKeyDown(KeyCode.A))
        {
            TestDefaultAssets();
        }

        // Test tous les defaults
        if (Input.GetKeyDown(KeyCode.D))
        {
            TestAllDefaults();
        }
    }

    void TestComplete()
    {
        Debug.Log("═══════════════════════════════════════════════════════");
        Debug.Log("          TEST COMPLET - GENERAL CONFIG ENHANCED");
        Debug.Log("═══════════════════════════════════════════════════════");

        // Test 1: Chargement de base
        Debug.Log("\n[TEST 1] Chargement de la configuration");
        if (GeneralConfigManager.Instance == null)
        {
            Debug.LogError("❌ GeneralConfigManager.Instance est NULL !");
            return;
        }
        Debug.Log("✅ GeneralConfigManager.Instance existe");

        if (!GeneralConfigManager.Instance.IsConfigLoaded())
        {
            Debug.LogWarning("⚠️ Configuration pas encore chargée, attendre...");
            return;
        }
        Debug.Log("✅ Configuration chargée");

        var config = GeneralConfigManager.Instance.GetConfig();
        if (config == null)
        {
            Debug.LogError("❌ GetConfig() retourne NULL !");
            return;
        }
        Debug.Log($"✅ Config obtenue - Projet: {config.projectName}");

        // Test 2: Vérifier les defaults
        Debug.Log("\n[TEST 2] Vérification des defaults");
        
        bool allDefaultsPresent = true;
        
        if (config.colorPalette == null) { Debug.LogError("❌ colorPalette est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ colorPalette présente"); }
        
        if (config.defaultAssets == null) { Debug.LogError("❌ defaultAssets est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultAssets présent"); }
        
        if (config.defaultPopupConfig == null) { Debug.LogError("❌ defaultPopupConfig est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultPopupConfig présent"); }
        
        if (config.defaultHeaderConfig == null) { Debug.LogError("❌ defaultHeaderConfig est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultHeaderConfig présent"); }
        
        if (config.defaultFeedbackMessages == null) { Debug.LogError("❌ defaultFeedbackMessages est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultFeedbackMessages présent"); }
        
        if (config.defaultUIConfig == null) { Debug.LogError("❌ defaultUIConfig est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultUIConfig présent"); }
        
        if (config.defaultResolution == null) { Debug.LogError("❌ defaultResolution est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultResolution présent"); }
        
        if (config.defaultCrosshairConfig == null) { Debug.LogError("❌ defaultCrosshairConfig est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultCrosshairConfig présent"); }
        
        if (config.defaultGunConfig == null) { Debug.LogError("❌ defaultGunConfig est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultGunConfig présent"); }
        
        if (config.defaultZoneDecorator == null) { Debug.LogError("❌ defaultZoneDecorator est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ defaultZoneDecorator présent"); }
        
        if (config.animations == null) { Debug.LogError("❌ animations est NULL"); allDefaultsPresent = false; }
        else { Debug.Log("✅ animations présent"); }

        if (allDefaultsPresent)
        {
            Debug.Log("\n✅✅✅ TOUS LES DEFAULTS SONT PRÉSENTS ! ✅✅✅");
        }
        else
        {
            Debug.LogError("\n❌ CERTAINS DEFAULTS SONT MANQUANTS !");
        }

        Debug.Log("\n═══════════════════════════════════════════════════════");
        Debug.Log("                 FIN DU TEST COMPLET");
        Debug.Log("═══════════════════════════════════════════════════════");
    }

    void TestColorPalette()
    {
        Debug.Log("\n🎨 TEST: Palette de Couleurs");
        Debug.Log("═══════════════════════════════════════════════════════");

        var colors = GeneralConfigManager.Instance.GetColorPalette();
        
        if (colors == null)
        {
            Debug.LogError("❌ GetColorPalette() retourne NULL !");
            return;
        }

        Debug.Log($"✅ Primary: {colors.primary}");
        Debug.Log($"✅ Secondary: {colors.secondary}");
        Debug.Log($"✅ Success: {colors.success}");
        Debug.Log($"✅ Error: {colors.error}");
        Debug.Log($"✅ Background: {colors.background}");
        Debug.Log($"✅ BackgroundDark: {colors.backgroundDark}");
        Debug.Log($"✅ Text: {colors.text}");
        Debug.Log($"✅ TextDark: {colors.textDark}");
        Debug.Log($"✅ Transparent: {colors.transparent}");
        Debug.Log($"✅ SemiTransparent: {colors.semiTransparent}");
        Debug.Log($"✅ Overlay: {colors.overlay}");

        Debug.Log("\n🎨 Palette de couleurs chargée avec succès !");
    }

    void TestPopupConfig()
    {
        Debug.Log("\n⚙️ TEST: Configuration Popup");
        Debug.Log("═══════════════════════════════════════════════════════");

        var popup = GeneralConfigManager.Instance.GetDefaultPopupConfig();
        
        if (popup == null)
        {
            Debug.LogError("❌ GetDefaultPopupConfig() retourne NULL !");
            return;
        }

        Debug.Log($"✅ Taille: {popup.width}x{popup.height}");
        Debug.Log($"✅ Background Color: {popup.backgroundColor}");
        Debug.Log($"✅ Border Color: {popup.borderColor}");
        Debug.Log($"✅ Border Width: {popup.borderWidth}");
        Debug.Log($"✅ Text Font Size: {popup.textFontSize}");
        Debug.Log($"✅ Button Text: {popup.buttonText}");
        Debug.Log($"✅ Button Size: {popup.buttonWidth}x{popup.buttonHeight}");

        Debug.Log("\n⚙️ Configuration popup chargée avec succès !");
    }

    void TestDefaultAssets()
    {
        Debug.Log("\n📦 TEST: Assets par Défaut");
        Debug.Log("═══════════════════════════════════════════════════════");

        var assets = GeneralConfigManager.Instance.GetDefaultAssets();
        
        if (assets == null)
        {
            Debug.LogError("❌ GetDefaultAssets() retourne NULL !");
            return;
        }

        Debug.Log($"✅ LED Off: {assets.ledOff}");
        Debug.Log($"✅ LED Green: {assets.ledGreen}");
        Debug.Log($"✅ LED Red: {assets.ledRed}");
        Debug.Log($"✅ Impact Effect: {assets.impactEffect}");
        Debug.Log($"✅ Default Crosshair: {assets.defaultCrosshair}");
        Debug.Log($"✅ Zone Decorator: {assets.zoneDecorator}");
        Debug.Log($"✅ Focus Indicator: {assets.focusIndicator}");

        Debug.Log("\n📦 Assets par défaut chargés avec succès !");
    }

    void TestAllDefaults()
    {
        Debug.Log("\n🔍 TEST: Tous les Defaults");
        Debug.Log("═══════════════════════════════════════════════════════");

        // Header
        var header = GeneralConfigManager.Instance.GetDefaultHeaderConfig();
        if (header != null)
        {
            Debug.Log($"✅ Header: show={header.show}, height={header.height}");
        }

        // Feedback
        var feedback = GeneralConfigManager.Instance.GetDefaultFeedbackMessages();
        if (feedback != null)
        {
            Debug.Log($"✅ Feedback: correct='{feedback.correctAnswerMessage}'");
        }

        // UI Config
        var ui = GeneralConfigManager.Instance.GetDefaultUIConfig();
        if (ui != null)
        {
            Debug.Log($"✅ UI: hoverTextSize={ui.hoverTextSize}");
        }

        // Resolution
        var resolution = GeneralConfigManager.Instance.GetDefaultResolution();
        if (resolution != null)
        {
            Debug.Log($"✅ Resolution: {resolution.width}x{resolution.height}");
        }

        // Crosshair
        var crosshair = GeneralConfigManager.Instance.GetDefaultCrosshairConfig();
        if (crosshair != null)
        {
            Debug.Log($"✅ Crosshair: size={crosshair.defaultSize}");
        }

        // Gun
        var gun = GeneralConfigManager.Instance.GetDefaultGunConfig();
        if (gun != null)
        {
            Debug.Log($"✅ Gun: size={gun.size}, visible={gun.alwaysVisible}");
        }

        // Zone Decorator
        var zoneDecorator = GeneralConfigManager.Instance.GetDefaultZoneDecorator();
        if (zoneDecorator != null)
        {
            Debug.Log($"✅ Zone Decorator: {zoneDecorator.imageUrl}");
        }

        // Animations
        var animations = GeneralConfigManager.Instance.GetAnimationTimings();
        if (animations != null)
        {
            Debug.Log($"✅ Animations: fadeIn={animations.fadeInDuration}s");
        }

        Debug.Log("\n🔍 Tous les defaults testés avec succès !");
    }

    void OnGUI()
    {
        if (showInstructions)
        {
            GUIStyle style = new GUIStyle(GUI.skin.box);
            style.fontSize = 14;
            style.alignment = TextAnchor.MiddleLeft;
            style.padding = new RectOffset(10, 10, 10, 10);

            GUI.Box(new Rect(10, 10, 400, 140), 
                "🧪 TEST GENERAL CONFIG ENHANCED\n\n" +
                "T = Test Complet\n" +
                "C = Test Couleurs\n" +
                "P = Test Popup Config\n" +
                "A = Test Assets\n" +
                "D = Test Tous les Defaults", 
                style);
        }
    }
}

