using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;
using TMPro;

public class ParametresTab : SettingsTab
{
    public Toggle soundToggle;
    public TextMeshProUGUI soundLabel;
    public Button quitButton;
    public string menuSceneName = "menu";
    
    protected override void Awake()
    {
        base.Awake();
        tabName = "PARAMÈTRES";
        tabOrder = 3;
        
        if (soundToggle != null)
        {
            bool soundEnabled = PlayerPrefs.GetInt("SoundEnabled", 1) == 1;
            soundToggle.isOn = soundEnabled;
            soundToggle.onValueChanged.AddListener(OnSoundToggleChanged);
            UpdateSoundLabel(soundEnabled);
        }
        
        if (quitButton != null)
        {
            quitButton.onClick.AddListener(OnQuitClicked);
        }
    }
    
    void OnSoundToggleChanged(bool isOn)
    {
        PlayerPrefs.SetInt("SoundEnabled", isOn ? 1 : 0);
        PlayerPrefs.Save();
        AudioListener.volume = isOn ? 1f : 0f;
        UpdateSoundLabel(isOn);
    }
    
    void UpdateSoundLabel(bool isOn)
    {
        if (soundLabel != null)
        {
            soundLabel.text = isOn ? "Son activé" : "Son coupé";
        }
    }
    
    void OnQuitClicked()
    {
        if (SettingsManager.Instance != null)
        {
            SettingsManager.Instance.CloseSettings();
        }
        
        SceneManager.LoadScene(menuSceneName);
    }
}