using UnityEngine;

public abstract class SettingsTab : MonoBehaviour
{
    [Header("Tab Info")]
    public string tabName = "Tab";
    public int tabOrder = 0;

    protected virtual void Awake()
    {
        SettingsManager manager = GetComponentInParent<SettingsManager>();
        if (manager != null)
        {
            manager.RegisterTab(this);
        }
    }

    protected virtual void OnEnable()
    {
        OnTabOpen();
    }

    protected virtual void OnDisable()
    {
        OnTabClose();
    }

    protected virtual void OnTabOpen()
    {
    }

    protected virtual void OnTabClose()
    {
    }
}