# 🔍 Debug : Onglet Quêtes - Logs détaillés

## 🎯 Objectif

J'ai ajouté des **logs très détaillés** pour comprendre exactement où le problème se situe.

---

## 📋 Nouveaux logs à surveiller

### 1. **Au clic sur l'onglet "QUÊTES"**

Vous devriez voir :
```
========================================
[QuetesTab] ★ OnEnable appelé ★
[QuetesTab] contentContainer null ? False/True
[QuetesTab] Nombre de maps : X
[QuetesTab] Nombre d'items : X
========================================
[QuetesTab] → Création du layout (première fois)
OU
[QuetesTab] → Liste vide, chargement des maps...
```

**➡️ Copier tous ces logs et m'envoyer**

---

### 2. **Lors du chargement**

Vous devriez voir :
```
[QuetesTab] ========== DÉBUT LoadMapsRegistry ==========
[QuetesTab] 📂 URL du registry: file:///...
[QuetesTab] ⏳ Envoi de la requête...
[QuetesTab] 📡 Requête terminée. Résultat: Success
[QuetesTab] ✅ Requête réussie
[QuetesTab] 📄 Taille du JSON: 1234 caractères
[QuetesTab] 📝 Contenu JSON (100 premiers car): {...
[QuetesTab] ✅ 10 maps chargées avec succès
[QuetesTab]   → Map 0: map quete 0
[QuetesTab]   → Map 1: Les dents de l'amer
[QuetesTab]   → Map 2: La marche des zombies
[QuetesTab] 🏗️ Appel de PopulateQuestsList()...
[QuetesTab] PopulateQuestsList() - 10 maps à afficher
[QuetesTab] CreateQuestItem() - Création de map quete 0
[QuetesTab]   → Item créé: QuestItem_map-Q0, parent: Content
[QuetesTab]   ✅ Item map quete 0 créé avec succès
... (répété pour chaque map)
[QuetesTab] PopulateQuestsList() terminé - 10 items créés
[QuetesTab] ========== FIN LoadMapsRegistry ==========
```

**➡️ Copier TOUS ces logs**

---

## ❌ Erreurs possibles et diagnostics

### Erreur 1 : `GeneralConfigManager.Instance est NULL`
```
[QuetesTab] ❌ GeneralConfigManager.Instance est NULL !
```
**Cause** : `GeneralConfigManager` n'est pas initialisé  
**Solution** : Vérifier qu'il y a un GameObject avec `GeneralConfigManager` dans la scène

---

### Erreur 2 : Erreur de chargement
```
[QuetesTab] ❌ Erreur chargement: Cannot connect to destination host
[QuetesTab] ❌ Code HTTP: 0
[QuetesTab] ❌ URL: file:///...
```
**Cause** : Le fichier `maps-registry.json` n'existe pas ou l'URL est incorrecte  
**Solution** : Vérifier que `StreamingAssets/json/maps-registry.json` existe

---

### Erreur 3 : Registry null après parsing
```
[QuetesTab] ❌ Registry est null après parsing !
```
**Cause** : Le JSON est mal formé  
**Solution** : Vérifier la syntaxe de `maps-registry.json`

---

### Erreur 4 : contentContainer NULL
```
[QuetesTab] ❌ contentContainer est NULL dans CreateQuestItem !
```
**Cause** : Le layout n'a pas été créé correctement  
**Solution** : Vérifier les logs de `CreateLayout()`

---

## 🧪 Procédure de test

### Étape 1 : Compiler
- Compiler le projet dans Unity
- Vérifier qu'il n'y a aucune erreur

### Étape 2 : Lancer le jeu
- Lancer la scène avec la map
- Ouvrir le panneau de paramètres

### Étape 3 : Ouvrir l'onglet Quêtes
- Cliquer sur "QUÊTES"
- **Ouvrir la Console Unity** (Ctrl+Shift+C ou Cmd+Shift+C)
- **Filtrer par "[QuetesTab]"** pour voir seulement les logs pertinents

### Étape 4 : Copier TOUS les logs
- Sélectionner tous les logs depuis `========================================`
- Jusqu'à `========== FIN LoadMapsRegistry ==========`
- Les copier et me les envoyer

---

## 📊 Checklist de vérification

Si les logs sont bons mais que la liste n'apparaît toujours pas :

### Dans Unity Hierarchy
1. Développer `SettingsPanel`
2. Développer `PanelContainer`
3. Développer `ContentArea`
4. Développer `QuetesTab`
5. Développer `LeftPanel`
6. Développer `ScrollView`
7. Développer `Viewport`
8. Développer `Content`
9. **Vérifier si les `QuestItem_map-Q*` sont présents**

### Dans Unity Inspector
Pour chaque `QuestItem` :
1. Sélectionner `QuestItem_map-Q0`
2. Vérifier le `RectTransform` :
   - Position : (0, quelque chose, 0)
   - Width : doit être > 0
   - Height : 100
   - Scale : (1, 1, 1)
3. Vérifier que l'Image a une couleur visible
4. Vérifier que les TextMeshProUGUI sont présents

### Problème de Canvas
1. Sélectionner `LeftPanel`
2. Vérifier le `RectTransform` :
   - Anchors : Min (0, 0), Max (0.48, 1)
   - Offsets doivent être corrects
3. Vérifier que l'Image de fond existe

---

## 🎯 Ce que je cherche à savoir

Avec ces logs, je pourrai déterminer :
1. ✅ Est-ce que `OnEnable()` est appelé ?
2. ✅ Est-ce que le layout est créé ?
3. ✅ Est-ce que `LoadMapsRegistry()` démarre ?
4. ✅ Est-ce que la requête HTTP réussit ?
5. ✅ Est-ce que le JSON est parsé correctement ?
6. ✅ Est-ce que `PopulateQuestsList()` est appelé ?
7. ✅ Est-ce que `CreateQuestItem()` crée les items ?
8. ✅ Combien d'items sont créés ?
9. ✅ Où sont-ils créés dans la hiérarchie ?

---

## 📝 Exemple de ce que j'attends

Envoyez-moi quelque chose comme ça :
```
========================================
[QuetesTab] ★ OnEnable appelé ★
[QuetesTab] contentContainer null ? False
[QuetesTab] Nombre de maps : 0
[QuetesTab] Nombre d'items : 0
========================================
[QuetesTab] → Liste vide, chargement des maps...
[QuetesTab] ========== DÉBUT LoadMapsRegistry ==========
[QuetesTab] 📂 URL du registry: file:///D:/UJSA_IA/septembre/Assets/StreamingAssets/json/maps-registry.json
[QuetesTab] ⏳ Envoi de la requête...
[QuetesTab] 📡 Requête terminée. Résultat: Success
[QuetesTab] ✅ Requête réussie
[QuetesTab] 📄 Taille du JSON: 1456 caractères
[QuetesTab] 📝 Contenu JSON (100 premiers car): {
    "maps": [
        {
            "id": "map-Q0",
            "name": "map quete 0",...
[QuetesTab] ✅ 10 maps chargées avec succès
[QuetesTab]   → Map 0: map quete 0
[QuetesTab]   → Map 1: Les dents de l'amer
[QuetesTab]   → Map 2: La marche des zombies
[QuetesTab] 🏗️ Appel de PopulateQuestsList()...
[QuetesTab] PopulateQuestsList() - 10 maps à afficher
[QuetesTab] CreateQuestItem() - Création de map quete 0
[QuetesTab]   → Item créé: QuestItem_map-Q0, parent: Content
[QuetesTab]   ✅ Item map quete 0 créé avec succès
... (etc)
[QuetesTab] PopulateQuestsList() terminé - 10 items créés
[QuetesTab] ========== FIN LoadMapsRegistry ==========
```

---

## 🔧 Si aucun log n'apparaît

Si vous ne voyez **AUCUN** log `[QuetesTab]` :
1. Le script n'est pas attaché au bon GameObject
2. Le GameObject est désactivé
3. Il y a une erreur de compilation qui empêche le script de fonctionner

**Vérifier** :
- Dans la Console Unity, y a-t-il des **erreurs rouges** ?
- Le GameObject `QuetesTab` existe-t-il dans la hiérarchie ?
- Le script `QuetesTab.cs` est-il attaché à ce GameObject ?

---

**Testez maintenant et envoyez-moi TOUS les logs !** 🚀  
Avec ces informations détaillées, je pourrai identifier exactement le problème.

