# 🔧 Correction : Chargement des Dialogues et Questions

## 📋 Problèmes résolus

### 1. ❌ Problème : Les dialogues ne s'affichaient pas
**Cause** : Les scripts `GameLauncher.cs` et `GameConfigLoader.cs` utilisaient directement les noms de fichiers depuis les JSON sans construire les URLs complètes.

### 2. ❌ Problème : Le jeu de tir ne se chargeait pas
**Cause** : `GameManager.cs` et `CalculatorGameManager.cs` ne transformaient pas les URLs de questions via `GetQuestionsUrl()`.

---

## ✅ Solutions appliquées

### 🔹 GameLauncher.cs
**Modifications** :
- Les URLs de dialogue sont maintenant construites via `GeneralConfigManager.Instance.GetDialogueUrl()`
- Les URLs de questions sont construites via `GeneralConfigManager.Instance.GetQuestionsUrl()`
- Logs ajoutés pour afficher les URLs complètes

**Lignes modifiées** : 86-104

```csharp
// Construire les URLs complètes via GeneralConfigManager
string beforeUrl = string.IsNullOrEmpty(config.dialogueBeforeUrl) ? "" : 
    GeneralConfigManager.Instance.GetDialogueUrl(config.dialogueBeforeUrl);
string questionsUrl = string.IsNullOrEmpty(config.questionsUrl) ? "" : 
    GeneralConfigManager.Instance.GetQuestionsUrl(config.questionsUrl);
```

---

### 🔹 GameConfigLoader.cs
**Modifications** :
- Même transformation que `GameLauncher.cs`
- Toutes les URLs (dialogues et questions) passent par les méthodes centralisées

**Lignes modifiées** : 66-82

---

### 🔹 GameManager.cs
**Modifications** :
- Détection si `questionsUrl` est déjà une URL complète (http://, https://, file:///)
- Si ce n'est pas une URL complète, transformation via `GetQuestionsUrl()`
- Logs améliorés pour le debug

**Lignes modifiées** : 704-712

```csharp
// Construire l'URL complète via GeneralConfigManager si ce n'est pas déjà une URL complète
if (!questionsUrl.StartsWith("http://") && !questionsUrl.StartsWith("https://") && !questionsUrl.StartsWith("file:///"))
{
    questionsUrl = GeneralConfigManager.Instance.GetQuestionsUrl(questionsUrl);
    Debug.Log($"🔄 URL questions transformée via GetQuestionsUrl: '{questionsUrl}'");
}
```

---

### 🔹 CalculatorGameManager.cs
**Modifications** :
- L'URL de questions est transformée via `GetQuestionsUrl()` avant le chargement
- Logs ajoutés pour tracer l'URL brute et l'URL complète

**Lignes modifiées** : 223-227

---

## 🎯 Résultat attendu

Maintenant, lorsque vous cliquez sur un jeu depuis la map :

1. ✅ **Le dialogue BEFORE s'affiche** (si `dialogueBeforeUrl` est défini dans le JSON)
   - Le fichier est chargé depuis `StreamingAssets/dialogues/`
   - Exemple : `dialogue_intro.json` → `file:///D:/UJSA_IA/septembre/Assets/StreamingAssets/dialogues/dialogue_intro.json`

2. ✅ **Le jeu se charge correctement** après le dialogue
   - Les questions sont chargées depuis `StreamingAssets/questions/`
   - Exemple : `Q0J1.json` → `file:///D:/UJSA_IA/septembre/Assets/StreamingAssets/questions/Q0J1.json`

3. ✅ **Logs détaillés** pour faciliter le debug
   - `[GameLauncher] Before URL: ...`
   - `[GameLauncher] Questions URL: ...`
   - `🔄 URL questions transformée via GetQuestionsUrl: ...`

---

## 🧪 Test

1. **Copiez vos fichiers de dialogue** dans `StreamingAssets/dialogues/`
2. **Copiez vos fichiers de questions** dans `StreamingAssets/questions/`
3. **Lancez Unity** et testez en cliquant sur un jeu depuis la map
4. **Vérifiez la Console** pour voir les logs de chargement

---

## 📝 Remarques

### Structure des fichiers JSON
Vos JSONs de jeu doivent maintenant contenir **seulement les noms de fichiers**, pas les URLs complètes :

```json
{
  "gameConfig": {
    "dialogueBeforeUrl": "dialogue_intro.json",
    "questionsUrl": "Q0J1.json",
    "dialogueSuccessUrl": "dialogue_success.json",
    "dialogueFailUrl": "dialogue_fail.json"
  }
}
```

Le système construira automatiquement :
- `dialogue_intro.json` → `STREAMING_ASSETS/dialogues/dialogue_intro.json`
- `Q0J1.json` → `STREAMING_ASSETS/questions/Q0J1.json`

---

## 🔗 Fichiers modifiés

1. ✅ `Scripts/GameLauncher.cs` - Ligne 81-119
2. ✅ `Scripts/GameConfigLoader.cs` - Ligne 61-94
3. ✅ `Scripts/Managers/GameManager.cs` - Ligne 678-714
4. ✅ `Scripts/Managers/CalculatorGameManager.cs` - Ligne 220-228

---

**Date** : 19 octobre 2025
**Statut** : ✅ Corrections appliquées - Prêt à tester

