# 📖 Guide : Onglet Quêtes

## 🎯 Résumé

L'onglet **Quêtes** du panneau de paramètres affiche maintenant la liste complète des maps disponibles. Vous pouvez cliquer sur n'importe quelle quête pour la lancer directement !

---

## ✨ Ce qui a été implémenté

### Interface utilisateur
```
┌────────────────────────────────────────────────────┐
│              PANNEAU DE PARAMÈTRES                 │
│  [SCORES] [CLASSEMENT] [QUÊTES] [PARAMÈTRES]  [X] │
├────────────────────────────────────────────────────┤
│                                                    │
│  ┌──────────────────┐  ┌──────────────────────┐  │
│  │  LISTE QUÊTES    │  │     DÉTAILS          │  │
│  │  ──────────────  │  │                      │  │
│  │                  │  │  PERSONNAGES         │  │
│  │ ┏━━━━━━━━━━━━━┓ │  │                      │  │
│  │ ┃ QUÊTE 1     ┃ │  │  LES FORMATIONS      │  │
│  │ ┃ Description ┃ │  │                      │  │
│  │ ┗━━━━━━━━━━━━━┛ │  │  BADGE OBTENU        │  │
│  │                  │  │                      │  │
│  │ ┌─────────────┐  │  │                      │  │
│  │ │ QUÊTE 2     │  │  │                      │  │
│  │ │ Description │  │  │                      │  │
│  │ └─────────────┘  │  │                      │  │
│  │                  │  │                      │  │
│  │ ┌─────────────┐  │  │                      │  │
│  │ │ QUÊTE 3     │  │  │                      │  │
│  │ │ Description │  │  │                      │  │
│  │ └─────────────┘  │  │                      │  │
│  │       ...        │  │                      │  │
│  └──────────────────┘  └──────────────────────┘  │
└────────────────────────────────────────────────────┘
```

### Fonctionnalités
- ✅ **Liste complète** des maps depuis `maps-registry.json`
- ✅ **Titre** de chaque quête affiché en gras
- ✅ **Description** de chaque quête
- ✅ **Scroll** pour naviguer dans la liste
- ✅ **Hover** : Changement de couleur au survol
- ✅ **Clic** : Lancement direct de la quête

---

## 🎮 Comment utiliser

### 1. Ouvrir le panneau de paramètres
Cliquez sur le bouton **paramètres** (engrenage) dans votre interface

### 2. Aller à l'onglet Quêtes
Cliquez sur le bouton **"QUÊTES"** dans le header du panneau

### 3. Choisir une quête
- **Survolez** une quête → Elle devient **violet clair**
- **Cliquez** sur une quête → Elle devient **violet foncé** et se lance

### 4. La quête se lance automatiquement
- Le panneau de paramètres se ferme
- L'écran de chargement s'affiche
- La map de la quête se charge

---

## 🎨 Apparence

### Couleurs
- **Normal** : Beige clair
- **Survol** : Violet clair (hover)
- **Sélectionné** : Violet foncé

### Structure d'une quête
```
┌──────────────────────────────────┐
│ LES DENTS DE L'AMER              │ ← Titre (gras, violet foncé)
│                                  │
│ Les rideaux de fer tombent sur   │ ← Description (petit texte)
│ la ville... Découvre pourquoi    │
│ les habitants du quartier sont   │
│ sur les dents                    │
└──────────────────────────────────┘
```

---

## 📋 Liste des quêtes disponibles

D'après votre `maps-registry.json`, voici les quêtes :

1. **map quete 0** (map-Q0)
2. **Les dents de l'amer** (map-Q1)
3. **La marche des zombies** (map-Q2)
4. **Jurassic Ville** (map-Q3)
5. **Le clan des cigares** (map-Q4)
6. **Bulles sur la ville** (map-Q5)
7. **La ville des maison tordues** (map-Q6)
8. **map quete 2** (map-Q7)
9. **map quete 2** (map-Q8)
10. **map quete 2** (map-Q9)

---

## 🔧 Comment ajouter une nouvelle quête

### 1. Créer le fichier de configuration de la map
Créez `map-Q10.json` dans `StreamingAssets/json/`

### 2. Ajouter l'entrée dans maps-registry.json
```json
{
    "id": "map-Q10",
    "name": "Nom de votre nouvelle quête",
    "configUrl": "map-Q10.json",
    "description": "Description de votre quête..."
}
```

### 3. Relancer Unity
La nouvelle quête apparaîtra automatiquement dans la liste !

---

## 🐛 Débogage

### Les quêtes ne s'affichent pas ?

1. **Vérifier la console Unity** pour les messages :
   ```
   [QuetesTab] Chargement maps registry depuis: [URL]
   [QuetesTab] 10 maps chargées
   ```

2. **Vérifier `maps-registry.json`** :
   - Le fichier existe-t-il dans `StreamingAssets/json/` ?
   - Le JSON est-il valide ?
   - Les champs `id`, `name`, `configUrl` sont-ils présents ?

3. **Vérifier `GeneralConfigManager`** :
   - `GetMapsRegistryUrl()` retourne-t-elle la bonne URL ?

### La quête ne se lance pas au clic ?

1. **Vérifier les logs** :
   ```
   [QuetesTab] Quête cliquée: [Nom] ([Config])
   [QuetesTab] Chargement de la scène Map avec config: [Config]
   ```

2. **Vérifier que la scène "Map" existe** dans Build Settings

3. **Vérifier que `MapManager`** lit correctement les `PlayerPrefs` :
   ```csharp
   string selectedMapConfig = PlayerPrefs.GetString("SelectedMapConfig", "");
   ```

---

## 📊 Données stockées

Quand vous cliquez sur une quête, ces données sont sauvegardées :

```csharp
PlayerPrefs.SetString("SelectedMapId", "map-Q1");
PlayerPrefs.SetString("SelectedMapConfig", "map-Q1.json");
```

`MapManager` peut lire ces valeurs pour charger la bonne configuration.

---

## 🚀 Évolutions futures

### Panneau droit
Le panneau droit affiche actuellement un placeholder. On pourrait y ajouter :
- **Personnages** : Liste des personnages de la quête
- **Objectifs** : Liste des objectifs à accomplir
- **Badges** : Badges qu'on peut obtenir
- **Progression** : Score actuel, étoiles obtenues
- **Difficulté** : Niveau de difficulté de la quête

### Filtres et recherche
- Filtrer par catégorie (automobile, santé, etc.)
- Rechercher par nom
- Trier par difficulté, par progression, etc.

### Icônes et visuels
- Ajouter une icône pour chaque quête
- Afficher une image d'aperçu
- Ajouter des badges de statut (nouveau, terminé, en cours)

---

## 📝 Notes techniques

### Fichier principal
`Assets/Scripts/UI/QuetesTab.cs` (344 lignes)

### Dépendances
- `GeneralConfigManager` : Pour charger `maps-registry.json`
- `SettingsManager` : Pour fermer le panneau
- `UnifiedLoadingManager` : Pour l'écran de chargement
- `SceneManager` : Pour changer de scène

### Méthodes importantes
```csharp
LoadMapsRegistry()      // Charge les données
PopulateQuestsList()    // Génère la liste
CreateQuestItem()       // Crée un item
OnQuestClicked()        // Gère le clic
```

---

## ✅ Checklist de test

Avant de valider l'implémentation, vérifiez :

- [ ] Le panneau de paramètres s'ouvre correctement
- [ ] L'onglet "QUÊTES" est visible et cliquable
- [ ] La liste des quêtes s'affiche à gauche
- [ ] Les titres sont en **MAJUSCULES** et en **gras**
- [ ] Les descriptions sont affichées sous les titres
- [ ] Le **scroll** fonctionne si la liste est longue
- [ ] Au **survol**, la quête devient violet clair
- [ ] Au **clic**, la quête devient violet foncé
- [ ] Le panneau se **ferme automatiquement**
- [ ] L'**écran de chargement** s'affiche
- [ ] La **scène Map** se charge avec la bonne configuration

---

## 🎉 C'est terminé !

Votre onglet Quêtes est maintenant fonctionnel !  
Testez-le dans Unity et profitez de la navigation améliorée dans vos quêtes ! 🚀

---

**Date de création** : 19 octobre 2025  
**Statut** : ✅ Prêt à tester  
**Documentation** : `ONGLET_QUETES_IMPLEMENTATION.md`  

