# 🧪 Guide de Test - Phase 2

**Date** : 19 octobre 2025  
**Pour** : Valider l'intégration des defaults dans CalculatorGameManager

---

## ⚡ Test Rapide (5 minutes)

### 1. Lancer Unity

Ouvrez le projet Unity.

### 2. Ouvrir la Scène Calculator

`File > Open Scene > Calculator.unity` (ou la scène du jeu de calculatrice)

### 3. Lancer le Jeu

Appuyez sur **Play** ▶️

### 4. Observer les Logs

Ouvrez la **Console** (`Window > General > Console`) et cherchez :

```
✅ Utilisation des defaults depuis general-config defaults
✅ Utilisation des bandes UI depuis general-config defaults
✅ Utilisation des paramètres LED depuis general-config defaults
✅ Utilisation des paramètres Question depuis general-config defaults
✅ Utilisation des messages feedback depuis general-config defaults
```

**Si vous voyez ces logs** : ✅ L'intégration fonctionne !

---

## 🔬 Tests Détaillés

### Test 1 : JSON Complet (Rétrocompatibilité)

**Objectif** : Vérifier que rien n'a cassé

**Étapes** :
1. Utiliser un JSON existant avec toutes les configs
2. Lancer le jeu
3. Vérifier que tout fonctionne comme avant

**Résultat Attendu** :
- ✅ Aucun message "Utilisation des defaults"
- ✅ Le jeu utilise les valeurs du JSON
- ✅ Comportement identique à avant la Phase 2

---

### Test 2 : JSON Minimal (Fallback Complet)

**Objectif** : Vérifier que les defaults sont utilisés

**Étapes** :
1. Créer un nouveau JSON minimal :

```json
{
  "gameConfig": {
    "questionsUrl": "https://.../questions.json",
    "assets": {
      "calculatorImage": "https://.../calculator.png"
    },
    "calculatorConfig": {
      "position": {"x": 0, "y": -100},
      "size": {"x": 500, "y": 700}
    },
    "calculatorButtons": [
      // ... vos boutons
    ]
  },
  "questions": []
}
```

2. Charger ce JSON dans le jeu
3. Lancer le jeu

**Résultat Attendu** :
- ✅ Les LEDs apparaissent (assets depuis general-config)
- ✅ Les bandes UI apparaissent (config depuis general-config)
- ✅ Les questions ont le bon style (fontSize, couleur depuis general-config)
- ✅ Le feedback a les bons messages (depuis general-config)
- ✅ Logs : "Utilisation des defaults depuis general-config"

---

### Test 3 : Modification des Defaults

**Objectif** : Vérifier que changer general-config affecte tous les jeux

**Étapes** :
1. Ouvrir `Assets/StreamingAssets/general-config.json`
2. Modifier la couleur primaire :

```json
{
  "colorPalette": {
    "primary": "#ff0000"  // Rouge au lieu de violet
  }
}
```

3. Sauvegarder
4. Relancer Unity
5. Lancer un jeu qui utilise les defaults

**Résultat Attendu** :
- ✅ Les éléments UI utilisent la nouvelle couleur rouge
- ✅ Changement appliqué sans modifier le JSON du jeu

---

### Test 4 : Vérifier les Assets LEDs

**Objectif** : Vérifier que les LEDs sont chargées depuis general-config

**Étapes** :
1. Créer un JSON **sans** `assets.ledOff`, `assets.ledGreen`, `assets.ledRed`
2. Lancer le jeu
3. Répondre à quelques questions

**Résultat Attendu** :
- ✅ Les LEDs s'affichent correctement
- ✅ Les sprites correspondent à ceux définis dans general-config
- ✅ Log : "Utilisation des defaults depuis general-config defaults"

---

### Test 5 : Feedback Messages

**Objectif** : Vérifier que les messages sont cohérents

**Étapes** :
1. Modifier dans `general-config.json` :

```json
{
  "defaultFeedbackMessages": {
    "correctAnswerMessage": "🎉 SUPER !",
    "incorrectAnswerMessage": "❌ OUPS !"
  }
}
```

2. Relancer Unity
3. Lancer un jeu avec JSON minimal (sans feedbackMessages)
4. Répondre à une question

**Résultat Attendu** :
- ✅ Le feedback affiche "🎉 SUPER !" pour une bonne réponse
- ✅ Le feedback affiche "❌ OUPS !" pour une mauvaise réponse

---

## 🐛 Troubleshooting

### Problème : Les defaults ne sont pas utilisés

**Symptôme** : Pas de logs "Utilisation des defaults"

**Solutions** :
1. Vérifier que `GeneralConfigManager.Instance` n'est pas null
2. Vérifier que `general-config.json` est bien chargé
3. Vérifier que le JSON du jeu ne contient PAS les configs (sinon il les utilise en priorité)

### Problème : Erreur NullReferenceException

**Symptôme** : Exception dans la Console

**Solutions** :
1. Vérifier que `general-config.json` contient toutes les sections de defaults
2. Vérifier que `GeneralConfigManager` est présent dans la scène
3. Vérifier les logs pour voir où exactement l'erreur se produit

### Problème : Les LEDs ne s'affichent pas

**Symptôme** : Pas de LEDs visibles

**Solutions** :
1. Vérifier que `general-config.json` contient `defaultAssets.ledOff/ledGreen/ledRed`
2. Vérifier que les URLs des assets sont valides
3. Vérifier les logs de chargement des sprites

---

## ✅ Checklist de Validation

Avant de valider la Phase 2, vérifier :

- [ ] ✅ Le jeu se lance sans erreur
- [ ] ✅ Les LEDs s'affichent correctement
- [ ] ✅ Les bandes UI s'affichent
- [ ] ✅ Les questions ont le bon style
- [ ] ✅ Le feedback affiche les bons messages
- [ ] ✅ Les logs indiquent l'utilisation des defaults
- [ ] ✅ La rétrocompatibilité est maintenue (JSON complets fonctionnent)
- [ ] ✅ Modifier general-config affecte tous les jeux
- [ ] ✅ Aucune erreur dans la Console
- [ ] ✅ Les performances sont identiques

---

## 📝 Rapport de Test

Après avoir effectué les tests, remplir ce rapport :

### Configuration Testée
- **Unity Version** : _______________
- **Date du Test** : _______________
- **Testeur** : _______________

### Résultats

| Test | Statut | Commentaires |
|------|--------|--------------|
| Test Rapide | ⬜ ✅ ❌ | |
| Test 1 (Rétrocompat) | ⬜ ✅ ❌ | |
| Test 2 (Fallback) | ⬜ ✅ ❌ | |
| Test 3 (Modification) | ⬜ ✅ ❌ | |
| Test 4 (Assets LEDs) | ⬜ ✅ ❌ | |
| Test 5 (Feedback) | ⬜ ✅ ❌ | |

### Bugs Trouvés

| ID | Description | Sévérité | Statut |
|----|-------------|----------|--------|
| | | | |

### Conclusion

✅ **Phase 2 validée** : La centralisation fonctionne correctement  
⚠️ **Problèmes mineurs** : (détailler)  
❌ **Problèmes bloquants** : (détailler)

---

## 🚀 Après Validation

Une fois tous les tests passés avec succès :

1. ✅ Marquer la Phase 2 comme **complétée**
2. ✅ Commiter les changements dans Git
3. ✅ Passer à la Phase 3 (GameManager.cs) si souhaité
4. ✅ Ou commencer à simplifier les JSON existants

---

**Bonne chance pour les tests ! 🎮**

