# 📁 Chemins d'Assets Centralisés

## 🎯 Vue d'ensemble

Tous les chemins d'assets du projet ont été centralisés dans `general-config.json` pour faciliter la maintenance et la gestion des environnements.

## 📍 Fichiers Modifiés

### Configuration Unity
- **`Assets/StreamingAssets/general-config.json`** - Configuration centrale avec tous les chemins de base
- **`Assets/Scripts/Data/GeneralConfig.cs`** - Classe de données mise à jour
- **`Assets/Scripts/Managers/GeneralConfigManager.cs`** - Gestionnaire avec méthodes utilitaires

### Fichiers JSON Convertis (79 fichiers)
- ✅ **8 fichiers de cartes** : `map-Q0.json` à `map-Q3.json`, `map-config.json`, etc.
- ✅ **70 fichiers de jeux** : `Q0J1.json`, `Q1J1.json`, etc.
- ✅ **1 fichier de registry** : `maps-registry.json`

## 🗂️ Chemins Définis dans `general-config.json`

```json
{
  "assetsPaths": {
    "popupVideoPath": "https://unjoursansassurance.studioplc.tech/demo_assets/videos/",
    "decoratorImagePath": "https://unjoursansassurance.studioplc.tech/demo_assets/images/",
    "videoPath": "https://unjoursansassurance.studioplc.tech/demo_assets/videos/",
    "backgroundImagePath": "https://unjoursansassurance.studioplc.tech/demo_assets/images/",
    "backgroundVideoPath": "https://unjoursansassurance.studioplc.tech/demo_assets/videos/",
    "uiPath": "https://unjoursansassurance.studioplc.tech/demo_assets/UI/",
    "dialoguePath": "https://unjoursansassurance.studioplc.tech/demo_assets/dialogues/",
    "questionsPath": "https://unjoursansassurance.studioplc.tech/demo_assets/questions/",
    "mapsPath": "https://unjoursansassurance.studioplc.tech/demo_assets/json/maps/"
  }
}
```

## 🔧 Utilisation dans le Code

### Méthodes Disponibles

```csharp
// Vidéos de popup
string videoUrl = GeneralConfigManager.Instance.GetPopupVideoUrl("focus/video.mp4");
// Résultat : https://.../demo_assets/videos/focus/video.mp4

// Images décoratives (personnages, etc.)
string imageUrl = GeneralConfigManager.Instance.GetDecoratorImageUrl("personnages/perso.png");
// Résultat : https://.../demo_assets/images/personnages/perso.png

// Vidéos générales
string videoUrl = GeneralConfigManager.Instance.GetVideoUrl("Q0J1_jeu.mp4");
// Résultat : https://.../demo_assets/videos/Q0J1_jeu.mp4

// Images de fond
string bgImageUrl = GeneralConfigManager.Instance.GetBackgroundImageUrl("map_Q3.jpg");
// Résultat : https://.../demo_assets/images/map_Q3.jpg

// Vidéos de fond
string bgVideoUrl = GeneralConfigManager.Instance.GetBackgroundVideoUrl("intro.mp4");
// Résultat : https://.../demo_assets/videos/intro.mp4

// Éléments UI
string uiUrl = GeneralConfigManager.Instance.GetUIUrl("led_green.png");
// Résultat : https://.../demo_assets/UI/led_green.png

// Fichiers de dialogue
string dialogueUrl = GeneralConfigManager.Instance.GetDialogueUrl("Q0J1_intro.json");
// Résultat : https://.../demo_assets/dialogues/Q0J1_intro.json

// Fichiers de questions
string questionsUrl = GeneralConfigManager.Instance.GetQuestionsUrl("questions.json");
// Résultat : https://.../demo_assets/questions/questions.json

// Configurations de maps
string mapUrl = GeneralConfigManager.Instance.GetMapConfigUrl("map-Q3.json");
// Résultat : https://.../demo_assets/json/maps/map-Q3.json

// Méthode générique
string url = GeneralConfigManager.Instance.GetAssetUrl("video", "intro.mp4");
```

## 📝 Format des Fichiers JSON

### Avant (URLs complètes)
```json
{
  "videoUrl": "https://unjoursansassurance.studioplc.tech/demo_assets/videos/Q0J1_jeu.mp4",
  "imageUrl": "https://unjoursansassurance.studioplc.tech/demo_assets/images/personnages/hero.png"
}
```

### Après (noms de fichiers uniquement)
```json
{
  "videoUrl": "Q0J1_jeu.mp4",
  "imageUrl": "personnages/hero.png"
}
```

**Note** : Les sous-dossiers sont préservés (ex: `personnages/`, `focus/`)

## ✨ Avantages

### 1. **Maintenance Simplifiée**
- Un seul fichier à modifier pour changer tous les chemins
- Pas besoin de modifier 79 fichiers JSON individuellement

### 2. **Gestion des Environnements**
- Facile de basculer entre dev/staging/prod
- Suffit de modifier `general-config.json`

### 3. **Lisibilité**
- Les JSON sont plus courts et lisibles
- Focus sur le contenu, pas sur les URLs

### 4. **Rétrocompatibilité**
- Les URLs complètes continuent de fonctionner
- Migration progressive possible

### 5. **Flexibilité**
- Support des chemins relatifs avec sous-dossiers
- Support des URLs externes (ex: placeholder.com)

## 🔄 Intégration Automatique

Le système fonctionne automatiquement :
- `MapManager` : Déjà intégré pour cartes et popups
- `GameManager` : À intégrer pour jeux de tir
- `CalculatorGameManager` : À intégrer pour calculatrice
- `DialoguePlayer` : À intégrer pour dialogues

## 🚀 Pour Ajouter un Nouveau Type de Chemin

### 1. Ajouter dans `general-config.json`
```json
"assetsPaths": {
  "monNouveauChemin": "https://example.com/path/"
}
```

### 2. Ajouter dans `GeneralConfig.cs`
```csharp
public class AssetsPathsConfig
{
    public string monNouveauChemin;
}
```

### 3. Ajouter dans `GeneralConfigManager.cs`
```csharp
public string GetMonNouveauUrl(string fileName)
{
    if (string.IsNullOrEmpty(fileName))
        return "";
        
    if (fileName.StartsWith("http://") || fileName.StartsWith("https://"))
        return fileName;
        
    var config = GetConfig();
    if (config.assetsPaths == null || string.IsNullOrEmpty(config.assetsPaths.monNouveauChemin))
    {
        Debug.LogWarning("[GeneralConfigManager] monNouveauChemin non défini");
        return fileName;
    }
    
    return config.assetsPaths.monNouveauChemin + fileName;
}
```

## 📊 Statistiques

- **79 fichiers JSON** convertis
- **9 types de chemins** centralisés
- **0 erreur** de compilation
- **100%** de compatibilité maintenue

## ✅ Tests

Pour tester le système :
1. Vérifier que `general-config.json` est chargé au démarrage
2. Tester une carte (Map.unity)
3. Vérifier que les assets se chargent correctement
4. Vérifier les logs Unity pour toute erreur

## 📞 Support

En cas de problème :
- Vérifier les logs Unity pour les warnings de `GeneralConfigManager`
- S'assurer que `general-config.json` est dans `StreamingAssets/`
- Vérifier que les chemins de base se terminent par `/`

---

**Date de mise à jour** : 19 octobre 2025  
**Version** : 1.0.0

