# 📚 Documentation Complète - Un Jour Sans Assurance

**Version** : 2.0  
**Date** : Décembre 2024  
**Projet Unity** : Jeu de tir QCM éducatif

---

## 📋 Table des Matières

1. [Vue d'Ensemble](#vue-densemble)
2. [Démarrage Rapide](#démarrage-rapide)
3. [Architecture du Projet](#architecture-du-projet)
4. [Configuration](#configuration)
5. [Guides d'Utilisation](#guides-dutilisation)
6. [Dépannage](#dépannage)
7. [Documentation Technique](#documentation-technique)
8. [Compatibilité Multi-Plateforme](#compatibilité-multi-plateforme)

---

## 🎯 Vue d'Ensemble

**Type** : Jeu éducatif de tir QCM développé sous Unity  
**Version** : 2.0 (Octobre 2025)  
**Résolution de référence** : 1920x1080 (16:9)  
**Input System** : Nouveau système Unity

### Flux de Navigation
```
Menu → Map (carte interactive) → Player (dialogues) → Game (shooting/calculator/trous) → Player → Map
```

### Scènes Principales
- `menu.unity` : Menu principal
- `Map.unity` : Carte interactive avec niveaux
- `Player.unity` : Dialogues avant/après le jeu
- `shooting.unity` : Jeu de tir QCM principal
- `calculator.unity` : Mini-jeu calculatrice
- `trous.unity` : Mini-jeu à trous

---

## 🚀 Démarrage Rapide

### 1. Ouvrir le Projet
1. Ouvrir Unity (2021.3+)
2. Ouvrir la scène `Scenes/menu.unity`
3. Appuyer sur **Play** (Ctrl+P)

### 2. Navigation
- **Clic souris** : Tirer / Sélectionner
- **ESC** : Retour menu (jeu) / Quitter (menu)

### 3. Configuration Minimale

**Scène Player** :
```
GameObject → Create Empty → "EscapeKeyHandler"
Add Component → EscapeKeyHandler
Config : Action = BackToMenu, Menu Scene Name = menu
```

**Scène Menu** :
```
GameObject → Create Empty → "EscapeKeyHandler"
Add Component → EscapeKeyHandler
Config : Action = QuitGame
```

---

## 🏗️ Architecture du Projet

### Structure des Dossiers

```
Assets/
├── Scenes/               # Scènes Unity (7 scènes)
├── Scripts/              # Scripts C# (87 fichiers)
│   ├── Managers/         # Gestionnaires principaux
│   ├── Game/             # Logique de jeu
│   ├── UI/               # Interface utilisateur
│   ├── Data/             # Modèles de données
│   └── Editor/           # Scripts éditeur Unity
├── StreamingAssets/      # Configuration JSON
│   ├── json/             # Maps et niveaux (99 fichiers)
│   ├── questions/        # Fichiers de questions
│   └── dialogues/        # Fichiers de dialogues
├── Prefabs/              # Préfabriqués Unity
└── Resources/            # Ressources Unity
```

### Managers Principaux

| Script | Rôle |
|--------|------|
| `GeneralConfigManager` | Charge la configuration globale (singleton) |
| `GameManager` | Gère le jeu de tir QCM |
| `MapManager` | Gère la carte interactive |
| `CrosshairManager` | Gère le viseur personnalisé |
| `DialoguePlayer` | Gère les dialogues |
| `LevelManager` | Gère les niveaux et progression |

### Systèmes de Jeu

1. **Shooting Game** : Jeu de tir QCM (principal)
2. **Calculator Game** : Jeu calculatrice
3. **Trous Game** : Jeu à trous (dropdown)

---

## ⚙️ Configuration

### Fichiers JSON Principaux

| Fichier | Emplacement | Rôle |
|---------|-------------|------|
| `general-config.json` | `StreamingAssets/` | Configuration globale du projet |
| `maps-registry.json` | `StreamingAssets/json/` | Liste des maps disponibles |
| `map-Q*.json` | `StreamingAssets/json/` | Configuration de chaque map |
| `Q*J*.json` | `StreamingAssets/json/` | Configuration des niveaux de jeu |

### Structure JSON d'un Niveau

```json
{
  "gameConfig": {
    "resolution": { "width": 1920, "height": 1080 },
    "background": { "videoUrl": "background.mp4" },
    "assets": {
      "crosshair": "curseur_neon.png",
      "gun": "vide.png",
      "impact": "impact_splash.png"
    },
    "crosshairConfig": {
      "alwaysShowCrosshair": true,
      "defaultSize": 75
    }
  },
  "questions": [
    {
      "id": 1,
      "question": "Votre question ?",
      "answers": [
        {
          "text": "Réponse 1",
          "isCorrect": true,
          "zone": { "x": 100, "y": 200, "width": 300, "height": 400 }
        }
      ]
    }
  ]
}
```

---

## 📖 Guides d'Utilisation

### Guide Mac

**Fichier** : `docs/guides/GUIDE_MAC.md`

**Problèmes couverts** :
- Configuration du Build Mac
- Crosshair/Gun invisibles
- Voile blanc sur dialogues
- Zones décalées en plein écran
- Gestion des résolutions

### Guide Build Settings

**Fichier** : `docs/guides/GUIDE_BUILD_SETTINGS.md`

**Contenu** :
- Configuration des scènes dans Build Settings
- Ordre des scènes
- Vérification des noms
- Dépannage

### Guide Écran de Chargement

**Fichiers** : 
- `docs/GUIDE_PERSONNALISATION_ECRAN_LOADING.md`
- `SETUP_LOADING_SCREEN.md`
- `GUIDE_ECRAN_TRANSITION.md`

**Contenu** :
- Création d'un écran de chargement personnalisé
- Configuration des messages
- Personnalisation visuelle

---

## 🐛 Dépannage

### Problèmes Courants

#### 1. Écran Noir après Dialogue Final

**Cause** : `CurrentMapId` manquant dans PlayerPrefs

**Solution** : Vérifier que `MapManager.LaunchLevel()` sauvegarde `CurrentMapId`

**Fichier** : `docs/FIX_CURRENTMAPID_MANQUANT.md`

#### 2. Retour au Menu au lieu de la Map

**Cause** : `ReturnToScene` non défini ou incorrect

**Solution** : Vérifier que `MapManager.LaunchLevel()` définit `ReturnToScene = "Map"`

**Fichier** : `docs/FIX_RETOUR_MAP_APRES_JEU.md`

#### 3. Popup Décalé sur la Map

**Cause** : Conversion incorrecte entre Canvas

**Solution** : Utilisation de `GetWorldCorners()` pour calculer la position

**Fichier** : `docs/FIX_POPUP_DECALE.md`

#### 4. Intro Vidéo ne se Joue Pas

**Cause** : Logique de saut d'intro trop agressive

**Solution** : Vérifier `NextStepId` avant de sauter l'intro

**Fichier** : `docs/FIX_INTRO_VIDEO_MAP.md`

#### 5. Crosshair/Gun Invisibles (Mac)

**Cause** : `UnityWebRequest` échoue avec `file:///` sur Mac

**Solution** : Détection automatique Mac + `File.ReadAllText()`

**Fichier** : `docs/guides/GUIDE_MAC.md`

#### 6. Zones Décalées en Plein Écran

**Cause** : Pas de gestion des letterbars/pillarboxes

**Solution** : Calcul des offsets dans `TargetZone.cs`

**Fichier** : `docs/guides/GUIDE_MAC.md`

### Dépannage Intro et Écran Noir

**Fichier** : `docs/DEPANNAGE_INTRO_ET_ECRAN_NOIR.md`

**Contenu** :
- Réinitialisation de la map
- Diagnostic des PlayerPrefs
- Procédure de test complète

### Solution Rapide Intro

**Fichier** : `SOLUTION_RAPIDE_INTRO.md`

**Méthode 1** : Script automatique `ForceResetMapOnStart`  
**Méthode 2** : Console Unity avec code de réinitialisation

---

## 🔧 Documentation Technique

### Architecture des Lanceurs

**Fichier** : `docs/technique/ARCHITECTURE_LAUNCHER.md`

**Contenu** :
- `GameLauncher` vs `GameConfigLoader`
- Flow complet du jeu
- Corrections appliquées

### Configuration des Logs

**Fichier** : `docs/technique/LogConfiguration.md`

**Contenu** :
- Niveaux de logs
- Configuration DebugLogger
- Utilisation

### Système de Chargement

**Fichier** : `docs/technique/Documentation_Système_Chargement.md`

**Contenu** :
- Composants du système
- Utilisation
- Intégration

### Communication PostMessage (Iframe)

**Fichiers** :
- `docs/IFRAME_POSTMESSAGE.md`
- `docs/POSTMESSAGE_INTEGRATION.md`
- `docs/SYNTHESE_IFRAME_AUTH.md`
- `docs/DEBUG_POSTMESSAGE.md`
- `docs/DEBUG_PAGE_PARENT.md`

**Contenu** :
- Authentification via iframe
- Communication JavaScript ↔ Unity
- Débogage
- Configuration

---

## 🌐 Compatibilité Multi-Plateforme

| Plateforme | Statut | Notes |
|------------|--------|-------|
| **Windows** | ✅ Testé | Fonctionne parfaitement |
| **macOS** | ✅ Testé | Fixes appliqués (oct 2025) |
| **WebGL** | ⚠️ À tester | Vérifier CORS |
| **Mobile** | ❌ Non testé | Input tactile à adapter |

### Corrections Récentes (Octobre 2025)

- ✅ **Mac** : Détection runtime + File.ReadAllText pour config
- ✅ **Zones** : Calcul letterbars/pillarboxes en plein écran
- ✅ **Navigation** : Ajout touche ESC (menu/quitter)
- ✅ **Map** : Fix CurrentMapId manquant
- ✅ **Map** : Fix retour à la Map après un jeu
- ✅ **Map** : Fix popup décalé
- ✅ **Map** : Fix vidéo d'intro

---

## 📝 Notes Importantes

### Avant de Build

1. Vérifier que toutes les scènes sont dans Build Settings
2. Vérifier `StreamingAssets/general-config.json` existe
3. Tester en mode fenêtré ET plein écran
4. Vérifier les logs (pas d'erreurs)

### Logs Importants

Au démarrage, vous devez voir :
```
[GeneralConfigManager] ✅ Configuration chargée avec succès!
[GameManager] ✅ Résolution de référence configurée: 1920x1080
```

### Fichiers Critiques

⚠️ **Ne pas supprimer** :
- `general-config.json`
- `maps-registry.json`
- `GeneralConfigManager.cs`
- `GameManager.cs`
- `MapManager.cs`

---

## 🔍 Recherche Rapide

### Par Problème

- **Écran noir** → `docs/FIX_CURRENTMAPID_MANQUANT.md`
- **Retour menu** → `docs/FIX_RETOUR_MAP_APRES_JEU.md`
- **Popup décalé** → `docs/FIX_POPUP_DECALE.md`
- **Intro vidéo** → `docs/FIX_INTRO_VIDEO_MAP.md`
- **Crosshair invisible** → `docs/guides/GUIDE_MAC.md`
- **Zones décalées** → `docs/guides/GUIDE_MAC.md`
- **Voile blanc** → `docs/guides/GUIDE_MAC.md`

### Par Fonctionnalité

- **Menu** → `MainMenuManager.cs`, `Scenes/menu.unity`
- **Carte** → `MapManager.cs`, `Scenes/Map.unity`
- **Jeu de tir** → `GameManager.cs`, `CrosshairManager.cs`
- **Dialogues** → `DialoguePlayer.cs`, `Scenes/Player.unity`
- **Chargement** → `UnifiedLoadingManager.cs`
- **Configuration** → `GeneralConfigManager.cs`

---

## 📊 Statistiques du Projet

- **Scènes Unity** : 7
- **Scripts C#** : 87
- **Fichiers JSON** : ~106 (99 configs + 6 questions + 1 général)
- **Miniatures** : 98
- **Documentation** : 15+ fichiers Markdown
- **Préfabriqués** : 6
- **Polices** : 2 (Anton, Oswald)

---

## 🆘 Support

### Logs Importants à Vérifier

**Démarrage** :
```
[GeneralConfigManager] Platform: OSXEditor / WindowsEditor
[GeneralConfigManager] ✅ Configuration chargée avec succès!
```

**Chargement niveau** :
```
[GameManager] ✅ Résolution de référence configurée: 1920x1080
[MacImageLoader] ✅ Texture chargée: 512x512
[CrosshairManager] ✅ Sprite appliqué et rendu visible
```

### Problèmes Courants

```
❌ [GeneralConfigManager] Erreur lors du chargement
   → Fichier general-config.json manquant ou invalide

❌ [MacImageLoader] Code HTTP: 404
   → URL incorrecte dans le JSON

❌ [GameManager] ⚠️ Résolution de référence non définie
   → Ajouter section "resolution" dans le JSON du niveau
```

---

## 📚 Fichiers de Documentation

### Documentation Principale

- `README.md` : Point d'entrée principal
- `GUIDE_PRINCIPAL.md` : Guide complet et détaillé
- `INDEX_PROJET.md` : Index détaillé du projet
- `DOCUMENTATION_COMPLETE.md` : Ce document (consolidation)

### Guides Utilisateur

- `docs/guides/GUIDE_MAC.md` : Guide Mac complet
- `docs/guides/GUIDE_BUILD_SETTINGS.md` : Configuration Build
- `docs/GUIDE_PERSONNALISATION_ECRAN_LOADING.md` : Personnalisation loading
- `GUIDE_ECRAN_TRANSITION.md` : Guide écran transition
- `SETUP_LOADING_SCREEN.md` : Setup écran chargement

### Guides de Dépannage

- `docs/FIX_CURRENTMAPID_MANQUANT.md` : Fix CurrentMapId
- `docs/FIX_RETOUR_MAP_APRES_JEU.md` : Fix retour Map
- `docs/FIX_POPUP_DECALE.md` : Fix popup décalé
- `docs/FIX_INTRO_VIDEO_MAP.md` : Fix vidéo intro Map
- `docs/DEPANNAGE_INTRO_ET_ECRAN_NOIR.md` : Dépannage complet
- `SOLUTION_RAPIDE_INTRO.md` : Solution rapide intro

### Documentation Technique

- `docs/technique/ARCHITECTURE_LAUNCHER.md` : Architecture lanceurs
- `docs/technique/LogConfiguration.md` : Configuration logs
- `docs/technique/Documentation_Système_Chargement.md` : Système chargement

### Documentation Iframe/PostMessage

- `docs/IFRAME_POSTMESSAGE.md` : Communication PostMessage
- `docs/POSTMESSAGE_INTEGRATION.md` : Intégration PostMessage
- `docs/SYNTHESE_IFRAME_AUTH.md` : Synthèse authentification
- `docs/DEBUG_POSTMESSAGE.md` : Débogage PostMessage
- `docs/DEBUG_PAGE_PARENT.md` : Débogage page parent

### Mémos et Notes

- `MEMO_PROBLEME_SPRITES_MAP.md` : Mémo problème sprites Map
- `docs/REORGANISATION_2025.md` : Rapport réorganisation
- `docs/RESUME_REORGANISATION.md` : Résumé réorganisation

---

**Dernière mise à jour** : Décembre 2024  
**Version du projet** : 2.0  
**Mainteneur** : Équipe de développement

