using System;

/// <summary>
/// Représente une entrée de jeu depuis le fichier CSV jeux.csv
/// Structure: id, title, type
/// </summary>
[Serializable]
public class GameEntry
{
    /// <summary>
    /// ID du jeu (utilisé pour appeler l'API)
    /// </summary>
    public int id;
    
    /// <summary>
    /// Titre du jeu à afficher
    /// </summary>
    public string title;
    
    /// <summary>
    /// Type de jeu (shooting, text_hole, calculator)
    /// </summary>
    public string type;
    
    /// <summary>
    /// Constructeur par défaut
    /// </summary>
    public GameEntry() { }
    
    /// <summary>
    /// Constructeur avec paramètres
    /// </summary>
    public GameEntry(int id, string title, string type)
    {
        this.id = id;
        this.title = title;
        this.type = type;
    }
    
    /// <summary>
    /// Retourne le type de jeu formaté pour l'affichage
    /// </summary>
    public string GetDisplayType()
    {
        switch (type?.ToLower())
        {
            case "shooting": return "TIR";
            case "text_hole": return "TEXTE";
            case "calculator": return "CALCUL";
            default: return type?.ToUpper() ?? "";
        }
    }
    
    /// <summary>
    /// Retourne le type de jeu normalisé pour le système
    /// </summary>
    public string GetNormalizedType()
    {
        switch (type?.ToLower())
        {
            case "shooting": return "shooting";
            case "text_hole": return "trous";
            case "calculator": return "calculator";
            default: return type?.ToLower() ?? "shooting";
        }
    }
}

