using System;
using UnityEngine;

[System.Serializable]
public class GeneralConfig
{
    [Header("Informations générales")]
    public string projectName;
    public string version;
    public string defaultMapId;
    public string mapsRegistryUrl;
    public string slug; // Slug du projet pour l'API
    public string defaultFontName = "Lato SDF"; // Police par défaut pour tous les textes
    
    [Header("Chemins des Assets")]
    public AssetsPathsConfig assetsPaths;
    
    [Header("Valeurs par Défaut")]
    public DefaultAssets defaultAssets;
    public ColorPalette colorPalette;
    public DefaultPopupConfig defaultPopupConfig;
    public DefaultHeaderConfig defaultHeaderConfig;
    public DefaultDialogueConfig defaultDialogueConfig; // Ajouté
    public DefaultFeedbackMessages defaultFeedbackMessages;
    public DefaultUIConfig defaultUIConfig;
    public DefaultResolution defaultResolution;
    public DefaultCrosshairConfig defaultCrosshairConfig;
    public DefaultGunConfig defaultGunConfig;
    public DefaultZoneDecorator defaultZoneDecorator;
    public AnimationTimings animations;
    
    [Header("Configuration Debug")]
    public GeneralDebugConfig debug;
    
    [Header("Configuration UI")]
    public GeneralUIConfig ui;
    
    [Header("Configuration Gameplay")]
    public GeneralGameplayConfig gameplay;
    
    [Header("Paramètres futurs")]
    public GeneralFutureSettingsConfig futureSettings;
    
    [Header("Configuration du panneau des paramètres")]
    public SettingsPanelConfig settingsPanelConfig;
    
    [Header("Configuration des jeux shooting")]
    public ShootingGameConfig shootingGame;
    
    [Header("Configuration des jeux trous")]
    public TrousGameApiConfig trousGame;
    
    [Header("Configuration UI des jeux trous")]
    public TrousGameUIConfig trousGameUI;
    
    [Header("URLs des APIs")]
    public ApiUrlsConfig apiUrls;
    
    [Header("URLs de configuration par défaut")]
    public DefaultConfigUrls defaultConfigUrls;
    
    [Header("Configuration des niveaux")]
    public LevelsConfigUrls levelsConfig;
    
    [Header("Configuration du panneau de connexion")]
    public ConnexionPanelConfig connexionPanel;
    
    [Header("Styles de boutons réutilisables")]
    public ButtonStylesDictionary buttonStyles;
    
    [Header("Styles de panneaux réutilisables")]
    public PanelStylesDictionary panelStyles;
    
    [Header("Configuration du panneau de prévisualisation de quête")]
    public QuestPreviewPanelConfig questPreviewPanel;
    
    [Header("Configuration de l'onglet Quêtes dans les paramètres")]
    public QuetesTabConfig quetesTabConfig;
    
    // Référence directe aux cartes pour le nouveau système de positionnement absolu
    public QuestPreviewCardStyleConfig durationDifficultyCard { get { return questPreviewPanel?.durationDifficultyCard; } }
    public QuestPreviewCardStyleConfig formationsCard { get { return questPreviewPanel?.formationsCard; } }
}

[System.Serializable]
public class ShootingGameConfig
{
    public int minCorrectPercentage;
    public bool usePercentage;
    public string description;
}

[System.Serializable]
public class TrousGameApiConfig
{
    public int count;
    public string description;
}

[System.Serializable]
public class AssetsPathsConfig
{
    public string popupVideoPath;
    public string decoratorImagePath;
    public string videoPath;
    public string backgroundImagePath;
    public string backgroundVideoPath;
    public string uiPath;
    public string crosshairPath;
    public string gameAssetsPath;
    public string dialoguePath;
    public string questionsPath;
    public string mapsPath;
}

[System.Serializable]
public class GeneralDebugConfig
{
    public bool showDebugZones;
    public bool enableDebugLogs;
}

[System.Serializable]
public class GeneralUIConfig
{
    public float loadingDelay;
    public int crosshairSortingOrder;
    public int gunSortingOrder;
}

[System.Serializable]
public class GeneralGameplayConfig
{
    public bool enableDirectClick;
    public bool enableCrosshair;
}

[System.Serializable]
public class GeneralFutureSettingsConfig
{
    public string comment;
}

// ==========================================
// CLASSES POUR LES VALEURS PAR DÉFAUT
// ==========================================

[System.Serializable]
public class DefaultAssets
{
    public string ledOff;
    public string ledGreen;
    public string ledRed;
    public string impactEffect;
    public string defaultCrosshair;
    public string zoneDecorator;
    public string focusIndicator;
}

[System.Serializable]
public class ColorPalette
{
    public string primary;
    public string secondary;
    public string success;
    public string error;
    public string background;
    public string backgroundDark;
    public string text;
    public string textDark;
    public string transparent;
    public string semiTransparent;
    public string overlay;
}

[System.Serializable]
public class DefaultPopupConfig
{
    public int width;
    public int height;
    public string backgroundColor;
    public string borderColor;
    public int borderWidth;
    public string textPosition;
    public float textPaddingTop;
    public float textPaddingBottom;
    public float textPaddingLeft;
    public float textPaddingRight;
    public float textHeight;
    public float textFontSize;
    public string textColor;
    public string textBackgroundColor;
    public float textPaddingHorizontal;
    public float showDelay;
    public float fadeSpeed;
    public string buttonText;
    public float buttonBottomMargin;
    public string buttonStyle; // Style de bouton depuis buttonStyles (ex: "validationPurple")
}

[System.Serializable]
public class DefaultHeaderElement
{
    public string imageUrl;
    public Vector2 position;
    public Vector2 size;
    public bool clickable;
    public string targetAction;
}

[System.Serializable]
public class JaugePhasesConfig
{
    public string phase1;
    public string phase2;
    public string phase3;
}

[System.Serializable]
public class DefaultHeaderConfig
{
    public bool show;
    public float height;
    public string backgroundColor;
    public JaugePhasesConfig jaugePhases;
    public DefaultHeaderElement leftElement;
    public DefaultHeaderElement rightElement;
}

[System.Serializable]
public class DefaultDialogueConfig
{
    // Paramètres de texte
    public float dialogueTextSize;
    public string dialogueTextColor;
    public float speakerTextSize;
    public string speakerTextColor;
    public bool speakerTextBold;
    public float speakerMarginBottom;
    public string dialogueTextAlignment;
    public float backgroundDimming;
    
    // Mode cadre centré (nouveau layout)
    public bool useFrameMode;
    public float frameWidth;
    public float frameHeight;
    public float frameRadius;
    public float frameBottomMargin;
    public string frameBackgroundColor;
    public float framePaddingLeft;
    public float framePaddingRight;
    public float framePaddingTop;
    public float framePaddingBottom;
    
    // Padding intérieur du conteneur titre+sous-titre
    public float textContentPaddingLeft;
    public float textContentPaddingRight;
    public float textContentPaddingTop;
    public float textContentPaddingBottom;
    
    // Indicateur de continuation
    public bool showContinueIndicator;
    public string continueIndicatorColor;
    public float continueIndicatorSize;
    public float continueIndicatorBottomMargin;
    
    // Mode bandeau legacy
    public float bottomBarHeightRatio;
    public string bottomBarColor;
    public float paddingLeft;
    public float paddingRight;
    
    // Instructions
    public string instructionsText;
    
    // Position de l'image d'illustration
    public IllustrationPositionConfig illustrationPosition;
}

[System.Serializable]
public class IllustrationPositionConfig
{
    public float x = 1465f;
    public float y = 670f;
}

[System.Serializable]
public class FeedbackPictoConfig
{
    public string goodAnswerUrl;
    public string badAnswerUrl;
    public Vector2 size;
    public Vector2 position;
    public bool show;
}

[System.Serializable]
public class FeedbackPanelShadowConfig
{
    public bool enabled;
    public string color;
    public float offsetX;
    public float offsetY;
    public float blur;
}

[System.Serializable]
public class FeedbackPanelStyleConfig
{
    public string backgroundColor;
    public float cornerRadius;
    public FeedbackPanelShadowConfig shadow;
}

[System.Serializable]
public class DefaultFeedbackMessages
{
    public float feedbackDisplayDelay = 0.5f; // Délai en secondes avant d'afficher le feedback
    public string correctAnswerMessage;
    public string incorrectAnswerMessage;
    public bool showResultMessage;
    public bool resultMessageInBold;
    public string resultMessageColor;
    public string incorrectMessageColor;
    public float resultMessageSize;
    public string resultMessageFont; // Police pour les messages (ex: "Anton SDF")
    public float resultMessagePositionY; // Position verticale du titre (depuis le haut du panel, en pixels)
    public float explanationTextPositionY; // Position verticale du texte d'explication (offset depuis le titre, en pixels)
    public string separator;
    public bool showSeparatorLine;
    public bool changeBackgroundColor;
    public bool useBackgroundImage;
    public string successBackgroundImageUrl;
    public string failureBackgroundImageUrl;
    public float backgroundImageAlpha;
    public bool stretchToFitPanel;
    public bool useCustomPanelSize;
    public Vector2 panelSize;
    public FeedbackPanelStyleConfig panelStyle; // Style visuel du panneau (fusionné depuis panelStyles)
    public FeedbackPictoConfig picto; // Configuration du picto de bonne/mauvaise réponse
    public string explanationTextColor;
    public float explanationTextSize;
    public bool explanationTextBold;
    public bool centerTextInPanel;
    public float explanationTextPaddingLeft;
    public float explanationTextPaddingRight;
    public string feedbackInstructionsText;
    public float feedbackInstructionsTextSize;
    public string feedbackInstructionsTextColor;

    // Libellés et style des boutons de feedback (shooting)
    public string feedbackNextButtonText;
    public string feedbackLastButtonText;
    public string feedbackButtonBackgroundColor;
    public string feedbackButtonStyle; // Nom du style de bouton à utiliser (ex: "validationPurple")
}

[System.Serializable]
public class DefaultUIBands
{
    public bool showBands;
    public float bandHeight;
    public string bandColor;
    public float bandAlpha;
    public int sortingOrder;
    public float cornerRadius = 20f;         // Coins arrondis du bandeau supérieur
    public float gameAreaCornerRadius = 20f; // Coins arrondis du cadre central (zone de jeu)
    public BandShadowConfig shadow;
}

[System.Serializable]
public class BandShadowConfig
{
    public bool enabled = false;
    public string color = "#00000040";
    public float offsetX = 0;
    public float offsetY = 8;
    public float blur = 16;
}

[System.Serializable]
public class ColorRGBA
{
    public float r;
    public float g;
    public float b;
    public float a = 1.0f;

    public Color ToColor()
    {
        return new Color(r, g, b, a);
    }
}

[System.Serializable]
public class DefaultLEDConfig
{
    public float ledSize;
    public float ledSpacing;
    public float marginLeft;
    public float verticalOffset;
    public bool useCustomSprites;
    public ColorRGBA defaultOffColor;
    public ColorRGBA defaultGreenColor;
    public ColorRGBA defaultRedColor;
    public bool enableLEDAnimation;
    public float animationSpeed;
    public string animationType;
}

[System.Serializable]
public class DefaultQuestionDisplay
{
    public float fontSize;
    public string fontColor;
    public bool fontBold;
    public string alignment;
    public float marginTop;
    public float marginLeft;
    public float marginRight;
    public int sortingOrder;
    public bool useCustomPosition;
    public bool adaptToScreenSize;
    public float minFontSize;
    public float maxFontSize;
}

[System.Serializable]
public class DefaultUIConfig
{
    public float hoverTextSize;
    public string hoverTextColor;
    public bool hoverTextBold;
    public DefaultHoverPanelSize hoverPanelSize;
    public string hoverBackgroundColor;
    public float hoverBackgroundAlpha;
    public bool useCustomPosition;
    public Vector2 customPosition;
    public bool useCenteredHoverPanel;
    // Paramètres spécifiques au panneau centré (shooting)
    public float centeredHoverPaddingX;
    public float centeredHoverPaddingY;
    public float centeredHoverAlpha;
    public DefaultUIBands bands;
    public DefaultLEDConfig ledConfig;
    public DefaultQuestionDisplay questionDisplay;
}

[System.Serializable]
public class DefaultHoverPanelSize
{
    public float width;
    public float height;
}

[System.Serializable]
public class DefaultResolution
{
    public int width;
    public int height;
}

[System.Serializable]
public class DefaultCrosshairConfig
{
    public float defaultSize;
    public float minSize;
    public float maxSize;
    public bool allowPlayerResize;
    public bool alwaysShowCrosshair;
    public float onTargetSizeMultiplier;
    public float offTargetSizeMultiplier;
    public float onTargetAlpha;
    public float offTargetAlpha;
    public float sizeTransitionSpeed;
    public float alphaTransitionSpeed;
    public bool smoothTransitions;
}

[System.Serializable]
public class DefaultGunBoundary
{
    public bool enableBoundaryConstraints;
    public bool useAutomaticMargins;
    public float marginLeft;
    public float marginRight;
    public float marginTop;
    public float marginBottom;
}

[System.Serializable]
public class DefaultGunConfig
{
    public Vector2 offsetFromCursor;
    public float size;
    public Vector2 gunSize;
    public bool flipHorizontally;
    public bool enableRotation;
    public float rotationOffset;
    public bool alwaysVisible;
    public float fadeSpeed;
    public bool hideDuringFeedback;
    public DefaultGunBoundary boundary;
}

[System.Serializable]
public class DefaultZoneDecorator
{
    public string imageUrl;
    public Vector2 size;
    public int sortingOrder;
}

[System.Serializable]
public class AnimationTimings
{
    public float fadeInDuration;
    public float fadeOutDuration;
    public float transitionDuration;
    public float quickTransition;
    public float loadingDelay;
}

[System.Serializable]
public class SettingsPanelConfig
{
    public Vector2 panelSize;
    public float cornerRadius;
    public string backgroundColor;
    public string darkBackgroundColor;
    
    public SettingsPanelHeaderConfig header;
    public SettingsPanelShadowConfig shadow;
    public SettingsPanelBorderConfig border;
    public SettingsPanelCloseButtonConfig closeButton;
    public SettingsPanelTabsConfig tabs;
    public SettingsPanelContentConfig content;
}

[System.Serializable]
public class SettingsPanelHeaderConfig
{
    public bool enabled = true;
    public float height;
    public string backgroundColor;
    public float cornerRadius;
}

[System.Serializable]
public class SettingsPanelShadowConfig
{
    public bool enabled;
    public string color;
    public float offsetX;
    public float offsetY;
    public float blur;
}

[System.Serializable]
public class SettingsPanelBorderConfig
{
    public bool enabled;
    public float width;
    public string color;
}

[System.Serializable]
public class SettingsPanelCloseButtonConfig
{
    public string imageUrl;
    public float size;
    public float marginRight;
}

[System.Serializable]
public class SettingsPanelTabsConfig
{
    public float spacing;
    public float marginLeft;
    public float marginRight;
    
    public SettingsPanelTabStateConfig normal;
    public SettingsPanelTabStateConfig selected;
    public SettingsPanelTabStateConfig hover;
}

[System.Serializable]
public class SettingsPanelTabStateConfig
{
    public string backgroundColor;
    public string textColor;
    public float fontSize;
    public string fontName;
    public string fontWeight;
    public float cornerRadius;
    public float paddingHorizontal;
    public float paddingVertical;
}

[System.Serializable]
public class SettingsPanelContentConfig
{
    public float padding;
    public string backgroundColor;
}

[System.Serializable]
public class ApiUrlsConfig
{
    public string baseUrl;
    public string questionsApi;
    public string gameAnswersApi; // Endpoint pour envoyer les réponses du joueur: /api/ujsa/games/{gameId}/answers
    public string gameAnswersResetApi; // Endpoint pour reset les réponses avant un jeu: /api/ujsa/games/{gameId}/answers/reset
    public string authPreconnect;
    public string authLogin;
    public string authVerifyToken;
    public string registrationUrl;
    public string forgotPasswordUrl;
}

[System.Serializable]
public class DefaultConfigUrls
{
    public string shootingGameConfig;
    public string calculatorGameConfig;
    public string levelsConfigUrl;
}

[System.Serializable]
public class LevelsConfigUrls
{
    public string urlRootJson;
    public string urlRootThumbnails;
}

[System.Serializable]
public class ConnexionPanelConfig
{
    public string panelStyle = "defaultPanel";
    public float width = 750;
    public float height = 450;
    public string title = "CONNEXION";
    public string titleColor = "#64477f";
    public float titleFontSize = 28;
    public string titleFontWeight = "bold";
    public string titleFontName = "Anton-Regular SDF";
    public float buttonsBottomMargin = 20;
    public float buttonsTopMargin = 320;
    public EmailInputConfig emailInput;
    public string seroniconnectText;
    public string connexionText;
    public string connexionTextColor = "#5a3d73";
    public float connexionTextFontSize = 30;
    public string connexionTextFontName = "Lato-Regular SDF";
    public float connexionTextTopMargin = 120;
    public ConnexionPanelButtons buttons;
    public PasswordStepConfig passwordStep;
}

[System.Serializable]
public class EmailInputConfig
{
    public float width = 600;
    public float height = 60;
    public string backgroundColor = "#FFFFFF";
    public float borderWidth = 1;
    public string borderColor = "#CCCCCC";
    public float borderRadius = 12;
    public string textColor = "#333333";
    public string placeholderColor = "#999999";
    public float fontSize = 24;
}

[System.Serializable]
public class PasswordStepConfig
{
    public string title = "MOT DE PASSE";
    public string message = "Nous avons retrouvé votre compte !";
    public string messageColor = "#49286a";
    public float messageFontSize = 26;
    public float messageTopMargin = 180;
    public float buttonsTopMargin = 320;
    public PasswordInputConfig passwordInput;
    public PasswordStepButtons buttons;
}

[System.Serializable]
public class PasswordInputConfig
{
    public float width = 500;
    public float height = 60;
    public string backgroundColor = "#FFFFFF";
    public float borderWidth = 1;
    public string borderColor = "#CCCCCC";
    public float borderRadius = 12;
    public string textColor = "#333333";
    public string placeholderColor = "#999999";
    public string placeholderText = "Entrez votre mot de passe";
    public float fontSize = 24;
    public bool showToggleButton = true;
    public string toggleButtonColor = "#64477f";
}

[System.Serializable]
public class PasswordStepButtons
{
    public ButtonReference submitButton;
    public ButtonReference forgotPasswordButton;
}

[System.Serializable]
public class ConnexionPanelButtons
{
    public ButtonReference continueButton;
    public ButtonReference seroniConnectButton;
}

[System.Serializable]
public class ButtonReference
{
    public string style;
    public string label;
    // Optionnel: permettre de surcharger certaines propriétés
    public float width = -1;
    public float height = -1;
}

// ==========================================
// CLASSES POUR LES STYLES DE BOUTONS
// ==========================================

[System.Serializable]
public class ButtonStylesDictionary
{
    public ButtonStyleConfig validationDefault;
    public ButtonStyleConfig validationPurple;
    public ButtonStyleConfig validationBeige;
    public ButtonStyleConfig validationGold;
    public ButtonStyleConfig validationWarm;
    public ButtonStyleConfig primaryAction;
    public ButtonStyleConfig secondaryAction;
    
    /// <summary>
    /// Récupère un style de bouton par son nom
    /// </summary>
    public ButtonStyleConfig GetStyle(string styleName)
    {
        switch (styleName)
        {
            case "validationDefault": return validationDefault;
            case "validationPurple": return validationPurple;
            case "validationBeige": return validationBeige;
            case "validationGold": return validationGold;
            case "validationWarm": return validationWarm;
            case "primaryAction": return primaryAction;
            case "secondaryAction": return secondaryAction;
            default: return null;
        }
    }
}

[System.Serializable]
public class ButtonStyleConfig
{
    public float width = 400;
    public float height = 80;
    public float borderRadius = 40;
    public float borderWidth = 4;
    public string borderColor = "#f5ece5";
    public ButtonGradientConfig gradient;
    public ButtonShadowConfig shadow;
    public ButtonTextConfig text;
    public ButtonStateConfig hover;
    public ButtonStateConfig pressed;
}

[System.Serializable]
public class ButtonGradientConfig
{
    public bool enabled = true;
    public string startColor = "#b87aff";
    public string endColor = "#7b4fbf";
    public float angle = 90;
}

[System.Serializable]
public class ButtonShadowConfig
{
    public bool enabled = true;
    public string color = "#00000040";
    public float offsetX = 0;
    public float offsetY = 6;
    public float blur = 12;
}

[System.Serializable]
public class ButtonTextConfig
{
    public string color = "#FFFFFF";
    public float fontSize = 28;
    public string fontWeight = "bold";
    public string fontFamily = "Anton-Regular SDF";
}

[System.Serializable]
public class ButtonStateConfig
{
    public float brightnessMultiplier = 1.0f;
    public float scaleMultiplier = 1.0f;
}

// ==========================================
// CLASSES POUR LES STYLES DE PANNEAUX
// ==========================================

[System.Serializable]
public class PanelStylesDictionary
{
    public PanelStyleConfig defaultPanel;
    public PanelStyleConfig modalDark;
    public PanelStyleConfig cardBeige;
    public PanelStyleConfig alertPanel;
    // feedbackPanel a été fusionné dans defaultFeedbackMessages.panelStyle
    
    /// <summary>
    /// Récupère un style de panneau par son nom
    /// </summary>
    public PanelStyleConfig GetStyle(string styleName)
    {
        switch (styleName)
        {
            case "defaultPanel": return defaultPanel;
            case "modalDark": return modalDark;
            case "cardBeige": return cardBeige;
            case "alertPanel": return alertPanel;
            // feedbackPanel n'est plus ici, il est dans defaultFeedbackMessages.panelStyle
            default: return null;
        }
    }
}

[System.Serializable]
public class PanelStyleConfig
{
    public string backgroundColor = "#f5ece5";
    public float cornerRadius = 30;
    public PanelHeaderConfig header;
    public PanelShadowConfig shadow;
    public PanelBorderConfig border;
}

[System.Serializable]
public class PanelHeaderConfig
{
    public bool enabled = true;
    public float height = 60;
    public string backgroundColor = "#dbc3b7";
    public float cornerRadius = 30;
}

[System.Serializable]
public class PanelShadowConfig
{
    public bool enabled = true;
    public string color = "#00000040";
    public float offsetX = 0;
    public float offsetY = 8;
    public float blur = 16;
}

[System.Serializable]
public class PanelBorderConfig
{
    public bool enabled = false;
    public float width = 0;
    public string color = "#00000000";
}

// ============================================
// Configuration du panneau de prévisualisation de quête
// ============================================

[System.Serializable]
public class QuestPreviewPanelConfig
{
    public Vector2 panelSize;
    public float cornerRadius = 25;
    public string backgroundColor = "#f5ece5";
    public string darkBackgroundColor = "#000000F2";
    
    public QuestPreviewHeaderConfig header;
    public QuestPreviewShadowConfig shadow;
    public QuestPreviewDescriptionConfig description;
    public QuestPreviewVideoConfig videoPlayer;
    public QuestPreviewCardStyleConfig durationDifficultyCard;
    public QuestPreviewCardStyleConfig formationsCard;
    public QuestPreviewInfoCardsConfig infoCards; // Garde les configs de texte, labels, etc.
    public QuestPreviewHelpLinkConfig helpLink;
    public QuestPreviewButtonsConfig buttons;
    public QuestPreviewSampleQuestsConfig sampleQuests;
}

[System.Serializable]
public class QuestPreviewHeaderConfig
{
    public float height = 80;
    public string backgroundColor = "#dbc3b7";
    public float cornerRadius = 25;
    public float iconSize = 60;
    public float iconMarginLeft = 20;
    public QuestPreviewTitleConfig title;
    public QuestPreviewCloseButtonConfig closeButton;
}

[System.Serializable]
public class QuestPreviewTitleConfig
{
    public float fontSize = 54;
    public string fontName = "Anton-Regular SDF";
    public string fontWeight = "normal";
    public string textColor = "#78675f";
    public float marginLeft = 15;
}

[System.Serializable]
public class QuestPreviewCloseButtonConfig
{
    public string imageUrl = "UI_fermer.png";
    public float size = 50;
    public float marginRight = 20;
}

[System.Serializable]
public class QuestPreviewShadowConfig
{
    public bool enabled = true;
    public string color = "#dbc3b780";
    public float offsetX = 0;
    public float offsetY = 8;
    public float blur = 16;
}

[System.Serializable]
public class QuestPreviewDescriptionConfig
{
    public float fontSize = 18;
    public string fontName = "Lato-Regular SDF";
    public string textColor = "#5a4a42";
    public float positionY = 150; // Position Y depuis le haut du panel
    public float marginHorizontal = 40;
    public float height = 60;
}

[System.Serializable]
public class QuestPreviewContentConfig
{
    public float marginTop = 20;
    public float marginHorizontal = 40;
    public float marginBottom = 20;
    public float spacing = 30;
}

[System.Serializable]
public class QuestPreviewVideoConfig
{
    public float cornerRadius = 15;
    public float x = 850; // Position X depuis le coin supérieur gauche du panel
    public float y = 280; // Position Y depuis le coin supérieur gauche du panel
    public float width = 765;
    public float height = 430;
}

[System.Serializable]
public class QuestPreviewInfoCardsConfig
{
    public float cornerRadius = 12;
    public string backgroundColor = "#ffffff";
    public string shadowColor = "#00000015";
    public float shadowOffsetY = 4;
    public float padding = 15;
    public float spacing = 15;
    
    // Configuration des cartes individuelles
    public QuestPreviewCardStyleConfig durationDifficultyCard;
    public QuestPreviewCardStyleConfig formationsCard;
    
    public QuestPreviewCardTextConfig cardTitle;
    public QuestPreviewCardTextConfig cardText;
    public QuestPreviewDurationConfig duration;
    public QuestPreviewDifficultyConfig difficulty;
    public QuestPreviewFormationsConfig formations;
}

[System.Serializable]
public class QuestPreviewCardStyleConfig
{
    public float x = 0; // Position X depuis le coin supérieur gauche du panel
    public float y = 0; // Position Y depuis le coin supérieur gauche du panel
    public float width = 400;
    public float height = 150;
    public string backgroundColor = "#ffffff";
    public float cornerRadius = 12;
    public string shadowColor = "#00000020";
    public float shadowOffsetY = 4;
    public float padding = 20;
}

[System.Serializable]
public class QuestPreviewCardTextConfig
{
    public float fontSize = 16;
    public string fontName = "Anton-Regular SDF";
    public string textColor = "#64477f";
}

[System.Serializable]
public class QuestPreviewDurationConfig
{
    public string label = "DURÉE";
    public string defaultValue = "2 H 00";
    public float x = 30;
    public float y = 20;
    public float labelMarginBottom = 5;
}

[System.Serializable]
public class QuestPreviewDifficultyConfig
{
    public string label = "NIVEAU DE DIFFICULTÉ";
    public string[] options = new string[] { "Débutant", "Intermédiaire", "Expert" };
    public float x = 150;
    public float y = 20;
    public float labelMarginBottom = 10;
    public float buttonFontSize = 18;
}

[System.Serializable]
public class QuestPreviewFormationsConfig
{
    public string label = "LES FORMATIONS ASSOCIÉES";
    public string bulletColor = "#a95bfb";
    public float fontSize = 22;
    public string textColor = "#5a4a42";
    public string linkColor = "#64477f";
    public bool underlineLinks = true;
    public float labelMarginBottom = 10;
    public float itemHeight = 30;
    public float itemSpacing = 5;
    public string[] items;
}

[System.Serializable]
public class QuestPreviewHelpLinkConfig
{
    public string text = "BESOIN D'AIDE ?";
    public string iconUrl = "UI_help_icon.png";
    public float iconSize = 20;
    public float fontSize = 14;
    public string fontName = "Lato-Bold SDF";
    public string textColor = "#64477f";
    public float x = 825; // Position X
    public float y = 730; // Position Y
    public float width = 200;
    public float height = 30;
}

[System.Serializable]
public class QuestPreviewButtonsConfig
{
    public float y = 795; // Position Y commune pour tous les boutons
    
    public QuestPreviewButtonConfig startQuest;
    public QuestPreviewButtonConfig skipQuest;
}

[System.Serializable]
public class QuestPreviewButtonConfig
{
    public string label;
    public string style = "validationPurple";
    public string disabledStyle = "secondaryAction";
    public float x = 0; // Position X du bouton
    public float width = 400;
    public float height = 80;
}

[System.Serializable]
public class QuestPreviewSampleQuestsConfig
{
    public QuestPreviewSampleQuest quest01;
}

[System.Serializable]
public class QuestPreviewSampleQuest
{
    public string iconUrl;
    public string title;
    public string description;
    public string duration;
    public string videoUrl;
    public string[] formations;
}

// ========== Configuration de l'onglet QUÊTES dans les paramètres ==========

[System.Serializable]
public class QuetesTabConfig
{
    public QuetesTabFontsConfig fonts;
    public QuetesTabQuestListBlockConfig questListBlock;
    public QuetesTabDetailsBlockConfig detailsBlock;
    public QuetesTabDetailsHeaderConfig detailsHeader;
    public QuetesTabDetailsContentConfig detailsContent;
    public QuetesTabCharacterMosaicConfig characterMosaic;
    public QuetesTabCharacterDetailConfig characterDetail;
}

[System.Serializable]
public class QuetesTabFontsConfig
{
    public string titleFontName = "Anton-Regular SDF";
    public string textFontName = "Lato-Regular SDF";
}

[System.Serializable]
public class QuetesTabQuestListBlockConfig
{
    public float x = 30; // Position X
    public float y = 30; // Position Y
    public float width = 620;
    public float height = 600;
    public float cornerRadius = 20;
    public string backgroundColor = "#ecdfd6";
    public bool shadowEnabled = true;
    public string shadowColor = "#dac1b3";
    public float shadowOffsetY = 8;
    public float padding = 20;
    public float itemSpacing = 15;
    public QuetesTabQuestItemStyleConfig itemStyle;
}

[System.Serializable]
public class QuetesTabQuestItemStyleConfig
{
    public float height = 120;
    public string normalBackgroundColor = "#f5ece5";
    public string hoverBackgroundColor = "#e8d4c0";
    public string selectedBackgroundColor = "#d9c0a8";
    public float cornerRadius = 12;
    public float paddingHorizontal = 15;
    public float paddingVertical = 12;
    public float titleFontSize = 22;
    public string titleColor = "#64477f";
    
    // Configuration pour les quêtes verrouillées (status == "locked")
    public QuetesTabLockedQuestConfig lockedStyle;
    public float descriptionFontSize = 18;
    public string descriptionColor = "#7c6b63";
}

[System.Serializable]
public class QuetesTabLockedQuestConfig
{
    public string backgroundColor = "#c0c0c0"; // Gris pour le fond
    public string titleColor = "#808080"; // Gris foncé pour le titre
    public string descriptionColor = "#a0a0a0"; // Gris moyen pour la description
    public string lockIconUrl = "cadenas.png"; // Nom du fichier PNG du cadenas
    public float lockIconSize = 24; // Taille du cadenas
    public float lockIconMarginLeft = 10; // Marge entre le titre et le cadenas
}

[System.Serializable]
public class QuetesTabDetailsBlockConfig
{
    public float x = 680; // Position X
    public float y = 30; // Position Y
    public float width = 650;
    public float height = 600;
    public float cornerRadius = 20;
    public string backgroundColor = "#ecdfd6";
    public bool shadowEnabled = true;
    public string shadowColor = "#dac1b3";
    public float shadowOffsetY = 8;
}

[System.Serializable]
public class QuetesTabDetailsHeaderConfig
{
    public float height = 70;
    public float paddingHorizontal = 20;
    public float paddingVertical = 10;
    public float tabSpacing = 15;
    public QuetesTabDetailTabStyleConfig tabStyle;
}

[System.Serializable]
public class QuetesTabDetailTabStyleConfig
{
    public float width = 180;
    public float height = 50;
    public float cornerRadius = 25;
    public float fontSize = 20;
    public string normalTextColor = "#78675f";
    public string selectedTextColor = "#ffffff";
    public string selectedBackgroundColor = "#a95bfb";
}

[System.Serializable]
public class QuetesTabDetailsContentConfig
{
    public float padding = 20;
}

[System.Serializable]
public class QuetesTabCharacterMosaicConfig
{
    public float avatarSize = 120;
    public float avatarSpacing = 20;
    public float avatarCornerRadius = 20;
    public float avatarBorderWidth = 2;
    public string avatarBorderColor = "#dcd0c4";
    public string selectedBorderColor = "#a95bfb";
    public float selectedBorderWidth = 4;
    public int columns = 3;
    public float padding = 15;
    public float arrowSize = 40;
    public string arrowColor = "#a95bfb";
}

[System.Serializable]
public class QuetesTabCharacterDetailConfig
{
    public float height = 120;
    public string backgroundColor = "#ecdfd6";
    public float cornerRadius = 25;
    public float padding = 15;
    public float marginTop = 20;
    public QuetesTabCharacterNameLabelConfig nameLabel;
    public QuetesTabCharacterDescriptionConfig description;
}

[System.Serializable]
public class QuetesTabCharacterNameLabelConfig
{
    public float fontSize = 22;
    public string fontName = "Anton-Regular SDF";
    public string textColor = "#64477f";
    public string backgroundColor = "#a95bfb";
    public float paddingHorizontal = 20;
    public float paddingVertical = 8;
    public float cornerRadius = 15;
}

[System.Serializable]
public class QuetesTabCharacterDescriptionConfig
{
    public float fontSize = 16;
    public string fontName = "Lato-Regular SDF";
    public string textColor = "#5a4a42";
    public float marginTop = 10;
}

// ==========================================
// CONFIGURATION UI DES JEUX TROUS
// ==========================================

[System.Serializable]
public class TrousGameUIConfig
{
    public string _comment;
    public TrouButtonStyleConfig trouButton;
    public TrousSelectionPopupConfig selectionPopup;
    public TrousValidationButtonConfig validationButton;
}

[System.Serializable]
public class TrouButtonStyleConfig
{
    public string _comment;
    public float cornerRadius = 22f;
    public float fontSizeMultiplier = 0.85f;
    public string emptyText = "CHOISIR";
    public string emptyTextInput = "SAISIR";
    public float paddingHorizontal = 24f;
    public float paddingVertical = 8f;
    public float minWidth = 100f;
    public bool adaptWidthToOptions = true;
    
    // État vide (non rempli)
    public TrouButtonStateConfig emptyState;
    
    // État rempli
    public TrouButtonStateConfig filledState;
    
    // État validé correct
    public TrouButtonStateConfig correctState;
    
    // État validé incorrect
    public TrouButtonStateConfig incorrectState;
}

[System.Serializable]
public class TrouButtonStateConfig
{
    public string backgroundColor = "#f5ece5";
    public string textColor = "#64477f";
}

[System.Serializable]
public class TrousSelectionPopupConfig
{
    public string _comment;
    
    // Overlay
    public string overlayColor = "#00000080";
    
    // Panel principal
    public TrousPopupPanelConfig panel;
    
    // Header
    public TrousPopupHeaderConfig header;
    
    // Options (boutons de choix)
    public TrousPopupOptionConfig options;
    
    // Champ de saisie texte
    public TrousPopupTextInputConfig textInput;
}

[System.Serializable]
public class TrousPopupPanelConfig
{
    public float width = 480f;
    public float height = 420f;
    public float cornerRadius = 40f;
    public string backgroundColor = "#f5ece5";
    public TrousPopupShadowConfig shadow;
}

[System.Serializable]
public class TrousPopupShadowConfig
{
    public bool enabled = true;
    public string color = "#00000040";
    public float offsetX = 0f;
    public float offsetY = 8f;
}

[System.Serializable]
public class TrousPopupHeaderConfig
{
    public float height = 80f;
    public float cornerRadius = 40f;
    public string backgroundColor = "#dbc3b7";
    public string title = "Choisissez une réponse";
    public string titleTextInput = "Entrez votre réponse";
    public float titleFontSize = 28f;
    public string titleColor = "#49286a";
    public TrousPopupCloseButtonConfig closeButton;
}

[System.Serializable]
public class TrousPopupCloseButtonConfig
{
    public float size = 30f;
    public float marginRight = 15f;
    public string imageUrl = "UI_fermer.png";
    public bool useImage = true;
    // Fallback si pas d'image
    public string backgroundColor = "#FFFFFF4D";
    public string iconColor = "#49286a";
    public float iconFontSize = 24f;
}

[System.Serializable]
public class TrousPopupOptionConfig
{
    public float height = 50f;
    public float cornerRadius = 25f;
    public float spacing = 12f;
    public float fontSize = 22f;
    public float paddingHorizontal = 30f;
    public float paddingVertical = 30f;
    
    // État normal
    public string normalBackgroundColor = "#f5ece5";
    public string normalTextColor = "#64477f";
    
    // État survol
    public string hoverBackgroundColor = "#e8dcd4";
    
    // État pressé
    public string pressedBackgroundColor = "#a95bfb";
}

[System.Serializable]
public class TrousPopupTextInputConfig
{
    public float height = 60f;
    public float cornerRadius = 15f;
    public string backgroundColor = "#FFFFFF";
    public string borderColor = "#cc9442";
    public float borderWidth = 2f;
    public float fontSize = 22f;
    public string textColor = "#64477f";
    public string placeholderText = "Tapez votre réponse...";
    public string placeholderColor = "#99999999";
}

[System.Serializable]
public class TrousValidationButtonConfig
{
    public string _comment;
    public string buttonStyle = "validationDefault";
    public string text = "VALIDER";
    public float marginRight = 30f;
    public float marginBottom = 30f;
    
    // Couleurs quand inactif
    public string inactiveBackgroundColor = "#99999980";
    public string inactiveTextColor = "#CCCCCCB3";
}
