using System;
using System.Collections.Generic;

/// <summary>
/// Modèles de données pour l'API des quêtes
/// </summary>

[Serializable]
public class QuestApiResponse
{
    public string status;
    public string message;
    public QuestApiData data;
}

[Serializable]
public class QuestApiData
{
    public QuestBackground background;
    public List<Quest> quests;
}

[Serializable]
public class QuestBackground
{
    public string type;
    public string url;
}

[Serializable]
public class Quest
{
    public int id;
    public string title;
    public string description;
    public string trailer_url;
    public string duration;
    public string visibility;
    public string status; // "available", "locked", "completed", etc.
    public List<Training> trainings;
    public bool has_access;
    public string sprite_url;
    public Vector2Data sprite_position;
    public Vector2Data sprite_size;
    public string tooltip_text;
    public List<QuestUserProgress> user; // Progression de l'utilisateur par difficulté
}

/// <summary>
/// Progression de l'utilisateur pour une difficulté donnée
/// </summary>
[Serializable]
public class QuestUserProgress
{
    public string difficulty; // "Débutant", "Intermédiaire", "Expert"
    public int completion; // 0 à 100
    public int score;
    public string badge; // peut être null
}

[Serializable]
public class Training
{
    public string title;
    public string url;
}
