using UnityEngine;
using System.Collections;

/// <summary>
/// TEST : Vérifier si les URLs fonctionnent sur Mac
/// À ajouter temporairement sur un GameObject dans la scène Player
/// </summary>
public class TestMacURLs : MonoBehaviour
{
    [Header("URLs à tester")]
    public string testImageUrl = "https://unjoursansassurance.studioplc.tech/demo_assets/images/curseur_sucre.png";
    public string testVideoUrl = "https://unjoursansassurance.studioplc.tech/demo_assets/videos/Q2J2_intro.mp4";
    
    void Start()
    {
        Debug.Log("═══════════════════════════════════════");
        Debug.Log("🧪 TEST DES URLs SUR MAC");
        Debug.Log($"Platform: {Application.platform}");
        Debug.Log($"Internet: {Application.internetReachability}");
        Debug.Log("═══════════════════════════════════════");
        
        StartCoroutine(TestImageLoad());
        StartCoroutine(TestVideoLoad());
    }
    
    IEnumerator TestImageLoad()
    {
        Debug.Log($"[TEST] 📸 Test chargement image...");
        Debug.Log($"[TEST] URL: {testImageUrl}");
        
        yield return MacImageLoader.LoadTexture(
            testImageUrl,
            (texture) => {
                Debug.Log($"[TEST] ✅ IMAGE OK: {texture.width}x{texture.height}");
                Debug.Log($"[TEST] Format: {texture.format}");
            },
            (error) => {
                Debug.LogError($"[TEST] ❌ IMAGE ÉCHEC: {error}");
                Debug.LogError("[TEST] Causes possibles:");
                Debug.LogError("  1. Certificat SSL rejeté");
                Debug.LogError("  2. CORS bloqué");
                Debug.LogError("  3. Serveur inaccessible");
                Debug.LogError("  4. Player Settings: 'Allow downloads over HTTP' non coché");
            }
        );
    }
    
    IEnumerator TestVideoLoad()
    {
        Debug.Log($"[TEST] 🎬 Test accès vidéo...");
        Debug.Log($"[TEST] URL: {testVideoUrl}");
        
        using (UnityEngine.Networking.UnityWebRequest www = UnityEngine.Networking.UnityWebRequest.Head(testVideoUrl))
        {
            www.timeout = 10;
            yield return www.SendWebRequest();
            
            if (www.result == UnityEngine.Networking.UnityWebRequest.Result.Success)
            {
                Debug.Log($"[TEST] ✅ VIDÉO ACCESSIBLE");
                Debug.Log($"[TEST] Code HTTP: {www.responseCode}");
                Debug.Log($"[TEST] Content-Type: {www.GetResponseHeader("Content-Type")}");
            }
            else
            {
                Debug.LogError($"[TEST] ❌ VIDÉO INACCESSIBLE: {www.error}");
                Debug.LogError($"[TEST] Code HTTP: {www.responseCode}");
            }
        }
    }
}

