using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;
using TMPro;

public class ParametresTab : SettingsTab
{
    public Toggle soundToggle;
    public TextMeshProUGUI soundLabel;
    public Button quitButton;
    public string menuSceneName = "menu";
    
    protected override void Awake()
    {
        base.Awake();
        tabName = "PARAMETRES";
        tabOrder = 3;
        
        Debug.Log("[ParametresTab] Awake: Configuration des parametres...");
        
        if (soundToggle != null)
        {
            bool soundEnabled = PlayerPrefs.GetInt("SoundEnabled", 1) == 1;
            soundToggle.isOn = soundEnabled;
            soundToggle.onValueChanged.AddListener(OnSoundToggleChanged);
            UpdateSoundLabel(soundEnabled);
        }
        
        if (quitButton != null)
        {
            quitButton.onClick.AddListener(OnQuitClicked);
        }
    }
    
    protected override void OnEnable()
    {
        base.OnEnable();
        Debug.Log("[ParametresTab] OnEnable: Parametres visibles");
    }
    
    void OnSoundToggleChanged(bool isOn)
    {
        Debug.Log($"[ParametresTab] Son change a: {isOn}");
        PlayerPrefs.SetInt("SoundEnabled", isOn ? 1 : 0);
        PlayerPrefs.Save();
        AudioListener.volume = isOn ? 1f : 0f;
        UpdateSoundLabel(isOn);
    }
    
    void UpdateSoundLabel(bool isOn)
    {
        if (soundLabel != null)
        {
            soundLabel.text = isOn ? "Son active" : "Son coupe";
        }
    }
    
    void OnQuitClicked()
    {
        Debug.Log("[ParametresTab] Quitter vers le menu...");
        if (SettingsManager.Instance != null)
        {
            SettingsManager.Instance.CloseSettings();
        }
        
        SceneManager.LoadScene(menuSceneName);
    }
}
