# 🔇 Configuration des Logs - Guide Rapide

## 📊 Niveaux de Log Disponibles

```csharp
None    = 0  // Aucun log
Error   = 1  // Seulement les erreurs critiques
Warning = 2  // Erreurs + warnings
Info    = 3  // Erreurs + warnings + infos importantes
Debug   = 4  // Tout (mode debug complet)
```

## ⚙️ Configuration Globale

### Pour tout le projet
Ouvrir `Scripts/DebugLogger.cs` et modifier la ligne 15 :

```csharp
public static LogLevel GlobalLogLevel = LogLevel.Warning;
```

**Recommandations :**
- **Production** : `LogLevel.Error` ou `LogLevel.Warning`
- **Test** : `LogLevel.Info`
- **Debug** : `LogLevel.Debug`

## 🎯 Configuration par Catégorie

Dans `DebugLogger.cs`, lignes 18-24, vous pouvez ajuster chaque système :

```csharp
public static LogLevel GameManagerLogLevel = LogLevel.Warning;
public static LogLevel MapManagerLogLevel = LogLevel.Warning;
public static LogLevel LevelManagerLogLevel = LogLevel.Warning;
public static LogLevel DialogueLogLevel = LogLevel.Warning;
public static LogLevel CalculatorLogLevel = LogLevel.Warning;
public static LogLevel LoadingLogLevel = LogLevel.Warning;
public static LogLevel UILogLevel = LogLevel.Warning;
```

### Exemple : Débugger uniquement la carte
```csharp
public static LogLevel GlobalLogLevel = LogLevel.Warning;
public static LogLevel MapManagerLogLevel = LogLevel.Debug;  // ← Seulement la carte
```

## 🚀 Modes Rapides

### Mode Silencieux (erreurs seulement)
Dans n'importe quel script :
```csharp
void Start() {
    DebugLogger.SetSilentMode();
}
```

### Mode Debug Complet
```csharp
void Start() {
    DebugLogger.EnableDebugMode();
}
```

## 💡 Utilisation dans les Scripts

### Remplacer les anciens Debug.Log

**Avant :**
```csharp
Debug.Log("[MapManager] Carte chargée");
Debug.LogWarning("[MapManager] Zone manquante");
Debug.LogError("[MapManager] Erreur critique");
```

**Après :**
```csharp
DebugLogger.Log("Carte chargée", "MapManager");           // Log standard (Debug)
DebugLogger.LogInfo("Carte chargée", "MapManager");       // Info importante
DebugLogger.LogWarning("Zone manquante", "MapManager");   // Warning
DebugLogger.LogError("Erreur critique", "MapManager");    // Erreur
```

## 📋 Catégories Disponibles

- `"GameManager"` ou `"Game"`
- `"MapManager"` ou `"Map"`
- `"LevelManager"` ou `"Level"`
- `"Dialogue"` ou `"DialoguePlayer"` ou `"Subtitle"`
- `"Calculator"` ou `"CalculatorGameManager"`
- `"Loading"` ou `"LoadingManager"`
- `"UI"` ou `"Menu"` ou `"MainMenu"`
- `"General"` (catégorie par défaut)

## ✅ Configuration Recommandée pour Production

```csharp
// Dans DebugLogger.cs
public static LogLevel GlobalLogLevel = LogLevel.Error;

// Tous les systèmes en mode Error seulement
public static LogLevel GameManagerLogLevel = LogLevel.Error;
public static LogLevel MapManagerLogLevel = LogLevel.Error;
public static LogLevel LevelManagerLogLevel = LogLevel.Error;
public static LogLevel DialogueLogLevel = LogLevel.Error;
public static LogLevel CalculatorLogLevel = LogLevel.Error;
public static LogLevel LoadingLogLevel = LogLevel.Error;
public static LogLevel UILogLevel = LogLevel.Error;
```

## 🔍 Dépannage

### "Je ne vois aucun log"
→ Le niveau est probablement sur `None` ou `Error`. Passez à `Warning` ou `Info`.

### "J'ai trop de logs"
→ Passez le `GlobalLogLevel` à `Warning` ou `Error`.

### "Je veux débugger un système spécifique"
→ Gardez `GlobalLogLevel` à `Warning` et mettez le système concerné à `Debug`.

---

**Dernière mise à jour** : Pour rendre le jeu moins bavard, le niveau par défaut est `Warning`.

