# 📖 Guide Rapide : Nouveau Système de Dialogues

## 🎯 Résumé en 30 secondes

**Avant** : 3 fichiers par jeu  
**Maintenant** : 1 seul fichier par jeu  

**C'est déjà fait !** ✅ Vos 89 jeux ont été convertis automatiquement.

---

## 🚀 Comment créer un nouveau jeu ?

### Ancien système ❌ (Ne plus utiliser)
```json
// Dans votre fichier de config Q10J1.json
{
  "gameConfig": {
    "dialogueBeforeUrl": "Q10J1_intro.json",
    "dialogueSuccessUrl": "Q10J1_success.json",
    "dialogueFailUrl": "Q10J1_fail.json"
  }
}
```

### Nouveau système ✅ (À utiliser maintenant)
```json
// Dans votre fichier de config Q10J1.json
{
  "gameConfig": {
    "dialoguesUrl": "Q10J1_dialogues.json"
  }
}
```

---

## 📝 Structure du fichier de dialogues

Créez un fichier `Q10J1_dialogues.json` dans `StreamingAssets/json/` :

```json
{
  "dialogues": {
    "intro": {
      "title": "Titre de votre jeu",
      "speaker": "Nom du personnage",
      "video": "Q10J1_intro.mp4",
      "lines": [
        {
          "text": "Première ligne de dialogue"
        },
        {
          "text": "Deuxième ligne de dialogue"
        },
        {
          "text": "Ligne avec une image",
          "image": "personnage.png"
        }
      ]
    },
    "success": {
      "title": "Bravo !",
      "speaker": "Nom du personnage",
      "video": "Q10J1_success.mp4",
      "lines": [
        {
          "text": "Félicitations !"
        }
      ]
    },
    "fail": {
      "title": "Dommage...",
      "speaker": "Nom du personnage",
      "video": "Q10J1_fail.mp4",
      "lines": [
        {
          "text": "Recommencez !"
        }
      ]
    }
  }
}
```

---

## 🔧 Modifier un dialogue existant

### Option 1 : Éditer directement le fichier groupé
1. Ouvrir `Assets/StreamingAssets/json/Q0J1_dialogues.json`
2. Modifier la section `intro`, `success` ou `fail`
3. Sauvegarder
4. Tester dans Unity

### Option 2 : Utiliser l'ancien système (rétrocompatibilité)
Le système détecte automatiquement les anciennes configurations et continue de fonctionner.

---

## ✨ Avantages

### Organisation
- 📁 Tous les dialogues au même endroit
- 🔍 Plus facile à trouver
- ✏️ Plus simple à éditer

### Performance
- ⚡ 1 seule requête au lieu de 3
- 🚀 Chargement plus rapide
- 📉 Moins de latence réseau

### Maintenance
- 🔧 Modification simplifiée
- 🎯 Cohérence garantie
- ✅ Moins d'erreurs

---

## 🧪 Tester vos modifications

### Dans Unity :
1. Lancer la scène **Map**
2. Cliquer sur une zone de jeu
3. Vérifier que les dialogues s'affichent :
   - ✅ Dialogue d'intro avant le jeu
   - ✅ Dialogue de succès après victoire
   - ✅ Dialogue d'échec après défaite

### Dans la Console Unity :
Rechercher ces messages :
```
[GameLauncher] Utilisation du NOUVEAU système de dialogues : Q0J1_dialogues.json
[GameLauncher] Dialogue INTRO stocké
[SubtitleManager] Parsing dialogue depuis JSON string
```

---

## ❓ FAQ

### Q: Mes anciens jeux vont-ils fonctionner ?
**R:** ✅ Oui ! Le système est rétrocompatible. Si un jeu utilise encore les 3 fichiers séparés, ça continue de fonctionner.

### Q: Dois-je convertir tous mes jeux ?
**R:** 🎉 C'est déjà fait ! Le script Python a converti vos 89 jeux automatiquement.

### Q: Puis-je supprimer les anciens fichiers *_intro/success/fail.json ?
**R:** ⚠️ Oui, mais attendez d'avoir vérifié que tout fonctionne bien dans Unity. Faites une sauvegarde avant !

### Q: Comment créer un nouveau jeu maintenant ?
**R:** Créez un seul fichier `Q*_dialogues.json` avec la structure ci-dessus, et référencez-le avec `dialoguesUrl` dans votre config.

### Q: Le système est-il plus rapide ?
**R:** ✅ Oui ! Une seule requête réseau au lieu de 3 = chargement plus rapide.

### Q: Puis-je avoir des dialogues sans intro/success/fail ?
**R:** ✅ Oui ! Laissez les sections vides ou avec `lines: []`. Le système gérera gracieusement.

---

## 🎯 Exemple complet

### Fichier de config : `Q1J5.json`
```json
{
  "gameConfig": {
    "questionsUrl": "Q1J5.json",
    "dialoguesUrl": "Q1J5_dialogues.json",
    "backgroundVideo": "Q1J5_background.mp4",
    "gun": "gun.png",
    "crosshair": "crosshair.png"
  }
}
```

### Fichier de dialogues : `Q1J5_dialogues.json`
```json
{
  "dialogues": {
    "intro": {
      "title": "Mission 5",
      "speaker": "Agent Smouth",
      "video": "Q1J5_intro.mp4",
      "lines": [
        { "text": "Bonjour agent !" },
        { "text": "Prêt pour une nouvelle mission ?" }
      ]
    },
    "success": {
      "title": "Mission accomplie",
      "speaker": "Agent Smouth",
      "video": "Q1J5_success.mp4",
      "lines": [
        { "text": "Excellent travail !" }
      ]
    },
    "fail": {
      "title": "Mission échouée",
      "speaker": "Agent Smouth",
      "video": "Q1J5_fail.mp4",
      "lines": [
        { "text": "Réessayez, vous pouvez y arriver !" }
      ]
    }
  }
}
```

---

## 🛠️ Scripts Utiles

### Fusionner les dialogues existants
```bash
cd d:\UJSA_IA\septembre
python merge_dialogues.py
```

---

## 📞 Support

Si vous rencontrez un problème :
1. Vérifier la console Unity pour les messages d'erreur
2. Vérifier que le fichier `*_dialogues.json` existe
3. Vérifier la structure JSON (pas de virgules en trop, etc.)
4. Vérifier que `dialoguesUrl` est bien défini dans la config

---

**C'est tout !** 🎉 Votre système de dialogues est maintenant plus simple, plus rapide et plus facile à maintenir !

