# 🔧 Configurer CORS sur AWS CloudFront

## Problème Actuel

```
Access to fetch at 'https://d27dezxjuxsdf7.cloudfront.net/...' 
from origin 'https://ujsa.studioplc.fr' has been blocked by CORS policy: 
No 'Access-Control-Allow-Origin' header is present on the requested resource.
```

CloudFront ne renvoie pas les headers CORS nécessaires.

---

## ✅ Solution : Ajouter une Response Headers Policy

### Étape 1 : Se Connecter à AWS Console

1. Aller sur https://console.aws.amazon.com
2. Se connecter avec vos identifiants
3. Chercher "CloudFront" dans la barre de recherche

### Étape 2 : Identifier Votre Distribution

1. Cliquer sur **Distributions**
2. Trouver la distribution pour `d27dezxjuxsdf7.cloudfront.net`
3. Cliquer sur l'ID de la distribution

### Étape 3 : Créer une Response Headers Policy

#### Option A : Utiliser une Policy Existante (Rapide)

1. Onglet **Behaviors** → **Edit** (le behavior principal)
2. Descendre jusqu'à **Response headers policy**
3. Sélectionner : **CORS-With-Preflight** (policy AWS managée)
4. Cliquer **Save changes**
5. ✅ **Terminé !**

#### Option B : Créer une Custom Policy (Plus de Contrôle)

1. Menu latéral → **Policies** → **Response headers**
2. Cliquer **Create policy**
3. **Name** : `CORS-Unity-WebGL`
4. **Description** : `Autoriser CORS pour Unity WebGL depuis ujsa.studioplc.fr`

**5. Configurer CORS** :

```
Cross-origin resource sharing (CORS)
  ✅ Configure CORS

Access control allow origin:
  ✅ Override
  Origins: *
  (ou spécifiquement : https://ujsa.studioplc.fr)

Access control allow headers:
  ✅ Override
  Headers: Content-Type, Accept

Access control allow methods:
  ✅ Override
  Methods: GET, OPTIONS

Access control max age:
  3600 (secondes)

Access control allow credentials:
  ❌ (décoché)
```

6. Cliquer **Create**

**7. Attacher la Policy à la Distribution** :

1. Retour à **Distributions**
2. Sélectionner votre distribution
3. Onglet **Behaviors** → **Edit**
4. **Response headers policy** → Sélectionner `CORS-Unity-WebGL`
5. Cliquer **Save changes**

### Étape 4 : Attendre la Propagation

CloudFront doit propager les changements à tous ses serveurs :
- ⏱️ Temps estimé : **5-15 minutes**
- 📊 Statut visible dans la colonne "Status" (passe de "Deploying" à "Deployed")

### Étape 5 : Tester

Une fois "Deployed" :

1. Vider le cache de votre navigateur (Ctrl+Shift+Delete)
2. Recharger votre jeu WebGL
3. Ouvrir F12 → Console
4. Vérifier que les erreurs CORS ont disparu

**Vérification manuelle** :
```bash
# Dans un terminal ou PowerShell
curl -I https://d27dezxjuxsdf7.cloudfront.net/media/2026/01/curseur-arrow-taxi-jaune_6964e52ae822e.png
```

Chercher dans la réponse :
```
Access-Control-Allow-Origin: *
```

Si présent → **✅ CORS configuré !**

---

## 🧪 Vérifier dans le Navigateur

### Méthode 1 : Onglet Network

1. F12 → Network
2. Recharger la page
3. Cliquer sur la requête de l'image du crosshair
4. Onglet **Headers** → **Response Headers**
5. Chercher : `access-control-allow-origin: *`

### Méthode 2 : Console JavaScript

Dans la console du navigateur :

```javascript
fetch('https://d27dezxjuxsdf7.cloudfront.net/media/2026/01/curseur-arrow-taxi-jaune_6964e52ae822e.png')
  .then(response => {
    console.log('✅ CORS OK !');
    console.log('Headers:', response.headers);
  })
  .catch(error => {
    console.log('❌ CORS bloqué:', error);
  });
```

---

## ⚠️ Problèmes Courants

### Le Status Reste "In Progress"

- **Normal** : Propagation peut prendre 15 minutes
- **Si >30 min** : Vérifier les paramètres de la policy

### Erreur "InvalidOrigin"

- Vérifier que l'origin est bien `*` ou `https://ujsa.studioplc.fr`
- Ne pas mettre de trailing slash : ~~https://ujsa.studioplc.fr/~~

### Cache du Navigateur

Après configuration, **vider le cache** :
- Chrome : Ctrl+Shift+Delete → Tout effacer
- Ou ouvrir en navigation privée

### Cache de CloudFront

Invalider le cache de CloudFront :
1. Distribution → Onglet **Invalidations**
2. Create invalidation
3. Object paths : `/*` (tout invalider)
4. Attendre quelques minutes

---

## 📋 Récapitulatif des URLs Affectées

Les images suivantes auront maintenant CORS activé :

```
https://d27dezxjuxsdf7.cloudfront.net/media/2026/01/curseur-arrow-taxi-jaune_6964e52ae822e.png
https://d27dezxjuxsdf7.cloudfront.net/media/2026/01/impact-flash-light_6964e940c1faf.png
https://d27dezxjuxsdf7.cloudfront.net/media/* (tous les fichiers)
```

---

## 💡 Alternative : Configurer CORS sur S3

Si CloudFront pointe vers un bucket S3, vous pouvez aussi configurer CORS là :

### Dans S3

1. AWS Console → S3
2. Sélectionner votre bucket
3. Onglet **Permissions**
4. **Cross-origin resource sharing (CORS)**
5. Edit et coller :

```json
[
    {
        "AllowedHeaders": [
            "*"
        ],
        "AllowedMethods": [
            "GET",
            "HEAD"
        ],
        "AllowedOrigins": [
            "*"
        ],
        "ExposeHeaders": [],
        "MaxAgeSeconds": 3600
    }
]
```

6. Save changes

**Puis invalider le cache CloudFront** pour que les changements soient pris en compte.

---

## ✅ Résultat Final Attendu

Après configuration correcte :

### Console Navigateur (Avant)
```
❌ Access to fetch at '...' has been blocked by CORS policy
```

### Console Navigateur (Après)
```
✅ [MacImageLoader] Texture chargée: 512x512
✅ [CrosshairManager] Sprite appliqué et rendu visible
```

---

## 🎯 Recommandation

**Si vous gérez vous-même l'hébergement des assets** :

→ **Mettez tout sur ujsa.studioplc.fr** pour éviter complètement les problèmes CORS

**Si vous devez utiliser CloudFront** (CDN, performance) :

→ **Configurez CORS une fois pour toutes** comme décrit ci-dessus

---

**Temps estimé** : 10-30 minutes  
**Difficulté** : Moyen (requiert accès AWS)  
**Avantage** : Toutes les futures images CloudFront fonctionneront  

---

Date : 12 janvier 2026
