# 🤔 Pourquoi l'Impact s'affiche mais pas le Crosshair ?

## 📊 Observation

```
✅ Impact : S'affiche correctement
❌ Crosshair : Ne s'affiche pas
❌ Les deux ont des erreurs CORS dans les logs
```

**C'est très étrange !** Voici les explications possibles :

---

## 🔍 Explication Technique

### **Différence de Chargement**

#### Impact (GameManager.cs)
```csharp
// Ligne 2326 - LoadSprite()
using (UnityWebRequest www = UnityWebRequestTexture.GetTexture(url))
{
    yield return www.SendWebRequest();
    // ✅ AUCUN HEADER personnalisé
    // → Requête CORS "simple"
}
```

#### Crosshair (CrosshairManager.cs + MacImageLoader.cs)
```csharp
// MacImageLoader.cs - AVANT correction
www.SetRequestHeader("User-Agent", "...");
www.SetRequestHeader("Cache-Control", "...");
// ❌ Headers personnalisés
// → Requête CORS "preflight" (OPTIONS)
```

---

## 🎯 Les 3 Hypothèses Principales

### **Hypothèse 1 : Cache du Navigateur (PROBABLE ✅)**

L'impact a été chargé avec succès **avant** que vous changiez les URLs ou avant que CORS devienne un problème.

**Le navigateur l'a mis en cache** et continue de l'utiliser même si maintenant CORS échoue.

**Test** :
1. Vider COMPLÈTEMENT le cache (Ctrl+Shift+Delete → Tout)
2. Recharger le jeu
3. Si l'impact disparaît aussi → **C'était le cache !**

### **Hypothèse 2 : Requête CORS Simple vs Preflight**

#### Requête CORS "Simple" (Impact)
```
Navigateur → GET image.png → Serveur
```
→ Parfois acceptée même sans CORS complet

#### Requête CORS "Preflight" (Crosshair)
```
Navigateur → OPTIONS → Serveur (vérifie permissions)
           ↓ (échoue)
           ❌ Bloqué avant même de faire GET
```
→ Plus stricte, échoue si serveur ne répond pas correctement

**Headers personnalisés** déclenchent une "preflight request" qui échoue sur CloudFront.

### **Hypothèse 3 : Ordre de Chargement**

Dans `LoadAllAssets()` :
1. **Impact** est chargé EN PREMIER (ligne 1998)
2. **Crosshair** est chargé APRÈS (ligne 2058+)

Peut-être que la première requête "ouvre la porte" pour le cache, mais les suivantes échouent.

---

## 🔬 Test pour Confirmer

### Test 1 : Vider le Cache

**PowerShell** :
```powershell
# Supprimer le cache du navigateur
# Chrome : C:\Users\USERNAME\AppData\Local\Google\Chrome\User Data\Default\Cache
# Edge : C:\Users\USERNAME\AppData\Local\Microsoft\Edge\User Data\Default\Cache
```

**Ou dans le Navigateur** :
1. Ctrl+Shift+Delete
2. Cocher "Images et fichiers en cache"
3. Période : "Toutes les données"
4. Effacer
5. Recharger le jeu

**Résultat attendu** :
- Si l'impact disparaît aussi → Hypothèse 1 confirmée (cache)
- Si l'impact reste → Hypothèse 2 (CORS simple vs preflight)

### Test 2 : Ouvrir en Navigation Privée

1. Ctrl+Shift+N (Chrome) ou Ctrl+Shift+P (Edge/Firefox)
2. Aller sur le jeu
3. Observer

**Résultat** :
- Pas de cache en navigation privée
- Si l'impact ne s'affiche pas → C'était le cache
- Si l'impact s'affiche → Autre mécanisme

### Test 3 : Regarder Network (F12)

1. F12 → Network
2. Recharger la page
3. Chercher les requêtes pour :
   - `curseur-arrow-taxi-jaune_6964e52ae822e.png`
   - `impact-flash-light_6964e940c1faf.png`

**Comparer** :
- Status Code (200 vs erreur)
- Type de requête (GET vs OPTIONS)
- Headers de réponse

**Si impact = 200 (from cache)** :
→ **L'impact vient du cache !**

**Si impact = 200 (from server)** :
→ **CORS fonctionne différemment pour les deux**

---

## 💡 Pourquoi CORS Simple Peut Parfois Marcher

Les navigateurs font une distinction :

### Requête CORS "Simple"
- Méthode : GET, HEAD, POST
- Headers : Accept, Accept-Language, Content-Language, Content-Type
- **Pas de preflight**
- Parfois tolérée pour les images

### Requête CORS "Preflight"
- Headers personnalisés (User-Agent, Cache-Control)
- Méthode : PUT, DELETE, PATCH
- **Preflight OPTIONS** obligatoire
- Échoue si serveur ne répond pas correctement

**C'est pourquoi** l'impact (simple) peut passer mais le crosshair (avec headers) échoue !

---

## ✅ Solution Définitive

Peu importe l'hypothèse :

### 1. Rebuild WebGL (obligatoire)
→ Applique les corrections de `MacImageLoader.cs`
→ Crosshair n'aura plus de headers personnalisés

### 2. Déplacer les Images (recommandé)
→ `ujsa.studioplc.fr` au lieu de CloudFront
→ Pas de CORS du tout

**OU**

### 2. Configurer CORS CloudFront
→ Headers CORS corrects sur CloudFront
→ Preflight requests acceptées

---

## 🎯 Actions Immédiates

**PRIORITÉ 1** : Rebuild WebGL
- File → Build Settings → WebGL → Build
- Attendre 5-15 minutes

**PRIORITÉ 2** : Vider le cache et tester
- Ctrl+Shift+Delete
- Recharger
- Voir si l'impact persiste

**PRIORITÉ 3** : Déplacer les images
- `telecharger_images.ps1`
- Uploader sur ujsa.studioplc.fr
- Modifier JSON

---

## 📊 Récapitulatif

| Aspect | Impact | Crosshair |
|--------|--------|-----------|
| Méthode | `LoadSprite()` | `MacImageLoader` |
| Headers | ❌ Aucun | ✅ User-Agent, Cache-Control |
| Type CORS | Simple | Preflight |
| Cache | ✅ Probablement | ❌ Nouveau |
| Affichage | ✅ Marche | ❌ Échoue |

---

## 🔧 Après Rebuild

Après avoir rebuild avec le `MacImageLoader.cs` corrigé :

```csharp
#if !UNITY_WEBGL || UNITY_EDITOR
    // Headers seulement pour Standalone
    www.SetRequestHeader("User-Agent", "...");
#else
    // WebGL : pas de headers
#endif
```

→ **Crosshair = requête simple comme Impact**
→ **Devrait marcher même sans déplacer les images !**

(Mais déplacer reste la meilleure solution)

---

Date : 12 janvier 2026

**TL;DR** : L'impact marche car il n'a pas de headers personnalisés (CORS simple) ou vient du cache. Le crosshair échoue car les headers déclenchent une preflight CORS qui échoue. **Rebuild + déplacer les images = solution définitive.**
