# ⚡ Guide Rapide : Réparer le Crosshair WebGL

## 🎯 Le Problème en 1 Phrase

L'image du crosshair ne se charge pas en WebGL car elle vient de **CloudFront** (domaine différent) et le serveur n'envoie pas les **headers CORS** nécessaires.

---

## ✅ Solution Immédiate (5 minutes)

### Déplacer l'Image vers le Même Domaine

**1. Télécharger l'image**
```
URL actuelle : https://d27dezxjuxsdf7.cloudfront.net/media/2026/01/curseur-arrow-taxi-jaune_6964e52ae822e.png
```

**2. Uploader sur votre serveur**
```
Nouveau : https://ujsa.studioplc.fr/datas/images/curseur-arrow-taxi-jaune.png
```

**3. Modifier le JSON du jeu**
```json
{
  "assets": {
    "crosshair": "https://ujsa.studioplc.fr/datas/images/curseur-arrow-taxi-jaune.png"
  }
}
```

**4. Rebuild WebGL**
```
File → Build Settings → WebGL → Build
```

**✅ RÉSOLU !**

---

## 🔧 Solution Alternative : Configurer CORS

Si vous devez garder CloudFront :

### Dans AWS CloudFront

1. **Distributions** → Sélectionner votre distribution
2. **Behaviors** → Edit
3. **Response Headers Policy** → Create new
4. Ajouter :
   ```
   Access-Control-Allow-Origin: *
   Access-Control-Allow-Methods: GET, OPTIONS
   ```
5. **Save** et attendre 5-10 minutes

---

## 🧪 Tester la Correction

### Dans Unity

1. Créer un GameObject vide
2. Ajouter le script `CrosshairDebugTester`
3. Dans l'Inspector :
   - `Crosshair URL` : coller votre URL
   - `Test On Start` : ✅
4. Compiler en WebGL
5. Lancer et ouvrir F12 → Console

### Résultat Attendu

```
✅ SUCCÈS ! Texture chargée: 512x512
✅ Sprite créé avec succès !
```

---

## 🚨 Si Ça Ne Marche Toujours Pas

### Vérifier dans le Navigateur (F12)

**Onglet Console** :
```
[CrosshairManager] ❌ Échec téléchargement
```
→ Lire les messages d'erreur détaillés

**Onglet Network** :
1. Recharger la page
2. Trouver la requête de l'image
3. Regarder les **Response Headers**
4. Doit contenir : `access-control-allow-origin: *`

---

## 📋 Checklist de Vérification

- [ ] L'image existe et est accessible dans un navigateur
- [ ] L'URL est en HTTPS (pas HTTP)
- [ ] L'image est sur le même domaine QUE le jeu
- [ ] OU CloudFront a les headers CORS configurés
- [ ] Le code `MacImageLoader.cs` a été mis à jour
- [ ] Rebuild WebGL effectué après changements

---

## 🎯 Pourquoi Ça Marche sur les Autres Jeux ?

Les autres jeux utilisent des images hébergées sur **ujsa.studioplc.fr** (même domaine) :
```json
{
  "crosshair": "https://ujsa.studioplc.fr/datas/images/crosshair.png"
}
```

Ce jeu utilise **CloudFront** (domaine différent) :
```json
{
  "crosshair": "https://d27dezxjuxsdf7.cloudfront.net/..."
}
```

**Domaine différent = CORS requis en WebGL !**

---

## 💡 Rappel Important

En Unity Player/Editor, **tout fonctionne** car Unity ignore les restrictions CORS.  
En WebGL, le **navigateur applique** les règles CORS strictes.

C'est normal que ça marche en Unity et pas en WebGL ! 🎮 vs 🌐

---

## 📞 En Cas de Blocage

1. Lire `SOLUTION_CROSSHAIR_WEBGL_CORS.md` (documentation complète)
2. Utiliser `CrosshairDebugTester` pour diagnostiquer
3. Vérifier les logs dans la console du navigateur (F12)
4. Tester avec l'ancienne URL qui fonctionnait

---

**⏱️ Temps de résolution estimé** : 5-30 minutes  
**🎯 Taux de succès** : 99% avec déplacement d'image  

---

**Fichiers modifiés** :
- ✅ `MacImageLoader.cs` 
- ✅ `CrosshairManager.cs`
- ✅ `CrosshairDebugTester.cs` (nouveau)
