// Plugin JavaScript pour capturer les événements de scroll en WebGL
// et les transmettre directement au ScrollRect Unity

mergeInto(LibraryManager.library, {
    
    // Initialise le listener de scroll sur le canvas WebGL
    InitWebGLScrollListener: function(gameObjectNamePtr, callbackNamePtr) {
        var gameObjectName = UTF8ToString(gameObjectNamePtr);
        var callbackName = UTF8ToString(callbackNamePtr);
        
        console.log("[WebGLScrollBridge] Initialisation scroll handler pour: " + gameObjectName);
        
        // Trouver le canvas Unity
        var canvas = document.getElementById("unity-canvas") || 
                     document.getElementById("#canvas") || 
                     document.querySelector("canvas");
        
        if (!canvas) {
            console.error("[WebGLScrollBridge] ❌ Canvas non trouvé!");
            return;
        }
        
        // Handler commun pour les événements wheel
        var wheelHandler = function(e) {
            // Empêcher le scroll de la page
            e.preventDefault();
            e.stopPropagation();
            
            var deltaY = e.deltaY;
            
            // Envoyer le delta au GameObject Unity
            try {
                SendMessage(gameObjectName, callbackName, deltaY);
            } catch (err) {
                console.error("[WebGLScrollBridge] ❌ Erreur SendMessage:", err);
            }
            
            return false;
        };
        
        // Ajouter le listener sur PLUSIEURS éléments pour maximiser les chances
        
        // 1. Sur le canvas
        canvas.addEventListener('wheel', wheelHandler, { passive: false, capture: true });
        
        // 2. Sur le container du canvas
        var container = canvas.parentElement;
        if (container) {
            container.addEventListener('wheel', wheelHandler, { passive: false, capture: true });
        }
        
        // 3. Sur document (catch-all)
        document.addEventListener('wheel', wheelHandler, { passive: false, capture: true });
        
        // 4. Sur window (dernier recours)
        window.addEventListener('wheel', wheelHandler, { passive: false, capture: true });
        
        // S'assurer que le canvas peut recevoir le focus
        if (!canvas.hasAttribute('tabindex')) {
            canvas.setAttribute('tabindex', '0');
        }
        
        // Donner le focus au canvas
        canvas.focus();
        
        console.log("[WebGLScrollBridge] ✅ Scroll handler installé (molette + trackpad)");
    }
});
