# 🎮 JEU DE TIR QCM - UNITY

**Version 2.0** | 21 octobre 2025

Jeu éducatif de tir avec questions à choix multiples développé sous Unity.

---

## 🚀 DÉMARRAGE RAPIDE

1. **Ouvrir Unity** (2021.3+)
2. **Ouvrir la scène** `Scenes/menu.unity`
3. **Play** → Tester !

⚠️ **Problème d'intro qui ne se joue pas ?** → Voir **[DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md)** section Dépannage

---

## 📖 DOCUMENTATION

| Document | Description |
|----------|-------------|
| **[DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md)** | 📘 **DOCUMENTATION UNIQUE** - Tout ce dont vous avez besoin |
| [docs/guides/GUIDE_MAC.md](docs/guides/GUIDE_MAC.md) | 🍎 Guide Mac (build, résolutions, dépannage) |
| [docs/guides/GUIDE_BUILD_SETTINGS.md](docs/guides/GUIDE_BUILD_SETTINGS.md) | Configuration des builds |
| [docs/technique/](docs/technique/) | 🔧 Documentation technique (architecture, logs, chargement) |

---

## ✅ CORRECTIONS RÉCENTES

### 7 novembre 2025

- ✅ **Map** : Fix CurrentMapId manquant (écran noir au retour)
- ✅ **Map** : Fix retour à la Map après un jeu
- ✅ **Map** : Fix popup décalé (bulle personnage)
- ✅ **Intro** : Fix vidéo d'intro Map qui ne se joue pas

### 21 octobre 2025

- ✅ **Mac** : Fix chargement configuration (détection runtime)
- ✅ **Zones** : Fix décalage en plein écran (letterbars)
- ✅ **Navigation** : Ajout touche ESC (menu/quitter)
- 📝 **Documentation** : Consolidée en un document unique

**Tous les détails** → [DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md)

---

## 🎯 CONFIGURATION MINIMALE

**Pour ajouter la navigation ESC** (5 min) :

**Scène Player** :
```
GameObject → Create Empty → "EscapeKeyHandler"
Add Component → EscapeKeyHandler
Config : Action = BackToMenu, Menu Scene Name = menu
```

**Scène Menu** :
```
GameObject → Create Empty → "EscapeKeyHandler"
Add Component → EscapeKeyHandler
Config : Action = QuitGame
```

---

## 🐛 DÉPANNAGE RAPIDE

| Problème | Solution |
|----------|----------|
| Écran noir après dialogue final | Voir [DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md) section Dépannage |
| Retourne au menu au lieu de la map | Voir [DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md) section Dépannage |
| Popup/bulle décalé sur la map | Voir [DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md) section Dépannage |
| Intro vidéo ne se lance pas | Voir [DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md) section Dépannage |
| Crosshair/Gun invisibles sur Mac | Voir [docs/guides/GUIDE_MAC.md](docs/guides/GUIDE_MAC.md) |
| Zones décalées plein écran | Voir [docs/guides/GUIDE_MAC.md](docs/guides/GUIDE_MAC.md) |
| Écran noir sur map | Vérifier `GeneralConfigManager` dans scène |
| ESC ne fonctionne pas | Ajouter `EscapeKeyHandler` dans scènes |

**Plus de détails** → [DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md) section Dépannage

---

## 📁 STRUCTURE DU PROJET

```
Assets/
├── Scenes/               # Scènes Unity
│   ├── menu.unity       # Menu principal
│   ├── Map.unity        # Carte interactive
│   └── Player.unity     # Dialogues + Jeu
├── Scripts/             # Scripts C#
│   ├── Managers/        # Gestionnaires principaux
│   ├── Game/            # Logique de jeu
│   └── UI/              # Interface utilisateur
├── StreamingAssets/     # Configuration JSON
│   ├── general-config.json
│   └── json/            # Maps et niveaux
└── DOCUMENTATION_COMPLETE.md   # 📘 Documentation complète
```

---

## 🔧 TECHNOLOGIES

- **Unity** 2021.3+
- **Input System** Nouveau système Unity
- **URP** (Universal Render Pipeline)
- **TextMeshPro** pour les textes
- **JSON** pour la configuration

---

## 📊 COMPATIBILITÉ

| Plateforme | Statut | Notes |
|------------|--------|-------|
| **Windows** | ✅ Testé | Fonctionne parfaitement |
| **macOS** | ✅ Testé | Fix appliqué (oct 2025) |
| **WebGL** | ⚠️ À tester | Vérifier CORS |
| **Mobile** | ❌ Non testé | Input tactile à adapter |

---

## 💡 LIENS UTILES

- **Documentation complète** : [DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md)
- **Problèmes Mac** : [docs/guides/GUIDE_MAC.md](docs/guides/GUIDE_MAC.md)
- **Build Settings** : [docs/guides/GUIDE_BUILD_SETTINGS.md](docs/guides/GUIDE_BUILD_SETTINGS.md)

---

## 📝 NOTES IMPORTANTES

### ⚠️ Avant de build

1. Vérifier que toutes les scènes sont dans Build Settings
2. Vérifier `StreamingAssets/general-config.json` existe
3. Tester en mode fenêtré ET plein écran
4. Vérifier les logs (pas d'erreurs)

### 🔍 Logs importants

Au démarrage, vous devez voir :
```
[GeneralConfigManager] ✅ Configuration chargée avec succès!
[GameManager] ✅ Résolution de référence configurée: 1920x1080
```

Si absent → Consulter [DOCUMENTATION_COMPLETE.md](DOCUMENTATION_COMPLETE.md)

---

**Développé avec ❤️ en Unity**

**Version** : 2.0 (21 octobre 2025)  
**Dernière mise à jour** : Corrections Mac + Zones + Navigation

