# 🔄 Instructions : Rebuild WebGL Nécessaire

## ⚠️ Pourquoi Rebuild ?

J'ai modifié le fichier **`MacImageLoader.cs`** pour désactiver les headers HTTP en WebGL, mais ces changements ne sont **pas encore compilés** dans votre build actuel !

C'est pourquoi :
- ✅ L'impact s'affiche (chargé avec `LoadSprite()` sans headers)
- ❌ Le crosshair ne s'affiche pas (chargé avec l'ancien `MacImageLoader` qui avait des headers)

---

## 🛠️ Comment Rebuild

### Dans Unity

1. **File → Build Settings**

2. **Platform** : WebGL (devrait déjà être sélectionné)

3. **Build Settings** :
   - ✅ Development Build : Décoché (sauf pour debug)
   - ✅ Compression Format : Gzip ou Disabled
   
4. **Player Settings** (bouton en bas à gauche) :
   - Publishing Settings
   - ✅ Vérifier que "Compression Format" est OK
   - ✅ Décocher "Enable Exceptions" (performances)

5. **Build** ou **Build and Run**
   - Sélectionner le dossier de destination
   - Attendre la compilation (peut prendre 5-15 minutes)

6. **Tester dans le navigateur**
   - Ouvrir F12 → Console
   - Vérifier les logs `[MacImageLoader] 🌐 Mode WebGL`

---

## 🔍 Vérification Après Rebuild

### Logs Attendus (Console F12)

**AVANT le rebuild** :
```
❌ Access to fetch... blocked by CORS policy
[MacImageLoader] Code HTTP: 500
[MacImageLoader] Result: DataProcessingError
```

**APRÈS le rebuild** :
```
🌐 Mode WebGL : headers par défaut uniquement
❌ CORS bloqué (mais pour une raison différente)
```

Les erreurs CORS resteront **JUSQU'À** ce que vous déplaciez les images sur `ujsa.studioplc.fr` OU configuriez CORS sur CloudFront.

---

## 🎯 Plan Complet

### Option A : Rebuild + Déplacer les Images (RECOMMANDÉ)

1. ✅ Rebuild WebGL (5-15 min)
2. ✅ Télécharger les images avec `telecharger_images.ps1`
3. ✅ Uploader sur `ujsa.studioplc.fr/datas/images/`
4. ✅ Modifier le JSON du jeu
5. ✅ Tester → **TOUT DEVRAIT MARCHER**

**Avantage** : Solution définitive, pas de config AWS nécessaire

### Option B : Rebuild + Configurer CORS CloudFront

1. ✅ Rebuild WebGL (5-15 min)
2. ✅ Configurer CORS sur CloudFront (voir `CONFIGURER_CORS_CLOUDFRONT.md`)
3. ✅ Attendre propagation (10-15 min)
4. ✅ Tester → **TOUT DEVRAIT MARCHER**

**Avantage** : Garde CloudFront, toutes les images futures marcheront

---

## 🚨 Important : Rebuild EST Obligatoire

**Sans rebuild**, les modifications dans `MacImageLoader.cs` ne sont pas prises en compte !

Les anciens headers (`User-Agent`, `Cache-Control`) sont toujours dans le build actuel, causant les erreurs CORS.

---

## ⏱️ Temps Estimé

| Étape | Durée |
|-------|-------|
| Rebuild WebGL | 5-15 min |
| Déplacer images | 5 min |
| Modifier JSON | 2 min |
| Test | 1 min |
| **TOTAL** | **13-23 min** |

---

## 🧪 Test Rapide Sans Rebuild

Si vous voulez tester **sans rebuild** :

1. Modifiez juste le JSON pour pointer vers `ujsa.studioplc.fr`
2. Si ça marche → le problème est bien CORS
3. Si ça ne marche pas → autre problème à investiguer

**Mais pour une solution complète, rebuild est nécessaire.**

---

## 📋 Checklist

Avant de tester :

- [ ] Rebuild WebGL effectué
- [ ] Images déplacées sur ujsa.studioplc.fr (OU CORS configuré)
- [ ] JSON modifié avec nouvelles URLs
- [ ] Cache navigateur vidé (Ctrl+Shift+Delete)
- [ ] F12 → Console ouverte pour voir les logs

---

Date : 12 janvier 2026
