using System;

/// <summary>
/// Structures de données pour l'authentification API
/// </summary>
[Serializable]
public class PreconnectResponse
{
    public string status;
    public string message;
    public PreconnectData data;
}

[Serializable]
public class PreconnectData
{
    public string code;
    public int user_id;
    public string email;
    public string first_name;
    public string last_name;
    public string about_me;
    public bool napro_membership;
    public bool cl_membership;
    public bool annie_membership;
    public string avatar;
}

[Serializable]
public class LoginRequest
{
    public string email;
    public string password;
}

[Serializable]
public class ResetPasswordRequest
{
    public string email;
}

[Serializable]
public class LoginResponse
{
    public string status;
    public string message;
    public LoginResponseData data;
}

[Serializable]
public class LoginResponseData
{
    public string token;
    public bool is_napro_membership;
    public bool is_cl_membership;
    public bool is_annie_membership;
    public bool is_ujsa_membership;
    public int user_id;
    public bool email_validated;
    public CompanyInfo company;
    public bool profil_completed;
    public string about_me;
    public string email; // Peut être null dans la réponse, sera rempli avec currentEmail si nécessaire
}

[Serializable]
public class CompanyInfo
{
    public int id;
    public string name;
}
