using System.Collections.Generic;
using UnityEngine;

// CLASSES SPÉCIFIQUES À LA CALCULATRICE
[System.Serializable]
public class CalculatorGameData
{
    public GameConfig gameConfig;  // Même structure que votre JSON
    public List<CalculatorQuestion> questions;  // Questions numériques
}

[System.Serializable]
public class CalculatorQuestion
{
    public int id;
    public string question;
    public float correctAnswerMin;
    public float correctAnswerMax;
    public string explanation;
    public int points;
}

// Extensions pour votre GameConfig existant
[System.Serializable]
public class CalculatorConfig
{
    public Vector2 position;
    public Vector2 size;
    public Vector2 displayPosition;
    public Vector2 displaySize;
    public string displayBackgroundColor;
    public string displayTextColor;
    public int displayTextSize;
}

[System.Serializable]
public class CalculatorButton
{
    public string buttonId;
    public string buttonType;  // "number", "delete", "validate"
    public string value;
    public Vector2 position;
    public Vector2 size;
}