using System;
using System.Collections.Generic;

/// <summary>
/// Structure pour un fichier de dialogues groupés par jeu
/// Remplace les 3 fichiers séparés (intro, success, fail) par un seul fichier
/// Note: Utilise la classe DialogueLine existante de DialoguePlayer.cs
/// </summary>
[Serializable]
public class DialoguesData
{
    public DialoguesCollection dialogues;
}

[Serializable]
public class DialoguesCollection
{
    public DialogueContent intro;
    public DialogueContent success;
    public DialogueContent fail;
}

[Serializable]
public class DialogueContent
{
    public string title;
    public string speaker;
    public string video;
    public List<DialogueLine> lines; // Utilise DialogueLine de DialoguePlayer.cs
}

