using UnityEngine;
using UnityEngine.SceneManagement;

/// <summary>
/// Script temporaire pour forcer la réinitialisation de la map au démarrage
/// À UTILISER UNIQUEMENT POUR TESTER L'INTRO
/// Ensuite, désactiver ce script ou mettre forceReset = false
/// </summary>
public class ForceResetMapOnStart : MonoBehaviour
{
    [Header("⚠️ SCRIPT DE TEST - À DÉSACTIVER EN PRODUCTION")]
    [Tooltip("Force la réinitialisation de la map au démarrage")]
    public bool forceReset = true;
    
    [Tooltip("ID de la map à réinitialiser")]
    public string mapId = "map-Q1";
    
    [Tooltip("Afficher les diagnostics détaillés")]
    public bool showDiagnostics = true;

    void Awake()
    {
        if (!forceReset)
        {
            if (showDiagnostics)
            {
                ShowDiagnostics();
            }
            return;
        }

        Debug.Log("========================================");
        Debug.Log("⚠️ FORCE RESET ACTIVÉ ⚠️");
        Debug.Log("========================================");
        
        ResetMap();
        
        if (showDiagnostics)
        {
            ShowDiagnostics();
        }
    }

    void ResetMap()
    {
        Debug.Log($"[ForceResetMap] Réinitialisation de {mapId}...");
        
        // Supprimer TOUTES les clés liées à cette map
        PlayerPrefs.DeleteKey($"IntroWatched_{mapId}");
        PlayerPrefs.DeleteKey($"CurrentStepId_{mapId}");
        PlayerPrefs.DeleteKey($"NextStepId_{mapId}");
        
        // S'assurer que CurrentMapId est correct
        PlayerPrefs.SetString("CurrentMapId", mapId);
        
        PlayerPrefs.Save();
        
        Debug.Log($"[ForceResetMap] ✅ Map {mapId} réinitialisée !");
        Debug.Log("[ForceResetMap] L'intro devrait se jouer au prochain chargement");
    }

    void ShowDiagnostics()
    {
        Debug.Log("========================================");
        Debug.Log("=== DIAGNOSTIC MAP ===");
        Debug.Log("========================================");
        
        string currentMapId = PlayerPrefs.GetString("CurrentMapId", "VIDE");
        string currentStepId = PlayerPrefs.GetString($"CurrentStepId_{mapId}", "VIDE");
        string nextStepId = PlayerPrefs.GetString($"NextStepId_{mapId}", "VIDE");
        int introWatched = PlayerPrefs.GetInt($"IntroWatched_{mapId}", -1);
        string returnToScene = PlayerPrefs.GetString("ReturnToScene", "VIDE");
        
        Debug.Log($"CurrentMapId = '{currentMapId}'");
        Debug.Log($"CurrentStepId_{mapId} = '{currentStepId}'");
        Debug.Log($"NextStepId_{mapId} = '{nextStepId}'");
        Debug.Log($"IntroWatched_{mapId} = {introWatched}");
        Debug.Log($"ReturnToScene = '{returnToScene}'");
        
        // Analyse
        if (string.IsNullOrEmpty(currentStepId) || currentStepId == "VIDE")
        {
            Debug.Log("✅ Pas de step sauvegardé → L'intro devrait se jouer");
        }
        else
        {
            if (currentStepId == "intro")
            {
                Debug.Log("ℹ️ CurrentStepId = 'intro' → L'intro devrait se jouer");
            }
            else
            {
                Debug.LogWarning($"⚠️ CurrentStepId = '{currentStepId}' → La map va charger ce step directement");
                Debug.LogWarning("Pour voir l'intro, activez forceReset = true");
            }
        }
        
        if (!string.IsNullOrEmpty(nextStepId) && nextStepId != "VIDE")
        {
            Debug.LogWarning($"⚠️ NextStepId = '{nextStepId}' → La map va passer à ce step au chargement");
        }
        
        Debug.Log("========================================");
    }
}

