using UnityEngine;
using UnityEngine.UI;

/// <summary>
/// Ultra-simple voile blanc killer pour Mac
/// À ajouter sur n'importe quel GameObject (Menu, Player, etc.)
/// </summary>
public class MacWhiteVeilKiller : MonoBehaviour
{
    private int frameCounter = 0;
    
    void Update()
    {
        // Seulement sur Mac
        if (Application.platform != RuntimePlatform.OSXEditor && Application.platform != RuntimePlatform.OSXPlayer)
            return;
        
        frameCounter++;
        
        // Nettoyer une fois tous les 10 frames (pas chaque frame = pas lourd)
        if (frameCounter < 10) return;
        frameCounter = 0;
        
        try
        {
            // Trouver TOUTES les images
            var allImages = FindObjectsByType<Image>(FindObjectsSortMode.None);
            int killedCount = 0;
            
            foreach (var img in allImages)
            {
                if (img == null) continue;
                
                // Critères simples : blanc, sans sprite
                bool isWhite = img.color.r > 0.85f && img.color.g > 0.85f && img.color.b > 0.85f;
                bool hasNoSprite = img.sprite == null;
                bool isOpaque = img.color.a > 0.1f;
                
                if (isWhite && hasNoSprite && isOpaque)
                {
                    // Chercher le canvas parent
                    Canvas parentCanvas = img.GetComponentInParent<Canvas>();
                    
                    // Si c'est un canvas de dialogue (sortingOrder élevé)
                    if (parentCanvas != null && parentCanvas.sortingOrder >= 40000)
                    {
                        // TUUER !
                        Color c = img.color;
                        c.a = 0f;
                        img.color = c;
                        killedCount++;
                        
                        Debug.Log($"[MAC VOILE] ✅ Voile blanc tué: {img.name} (canvas: {parentCanvas.name}, order: {parentCanvas.sortingOrder})");
                    }
                }
            }
            
            if (killedCount > 0)
            {
                Debug.Log($"[MAC VOILE] 🍎 {killedCount} voile(s) blanc(e) éliminé(e)");
            }
        }
        catch (System.Exception ex)
        {
            Debug.LogError($"[MAC VOILE] Erreur: {ex.Message}");
        }
    }
}
