using System;
using System.Collections.Generic;
using UnityEngine;

[Serializable]
public class MapConfigWrapper
{
    public MapConfigData mapConfig;
}

// Structure pour la réponse API des quests
[Serializable]
public class ApiQuestResponse
{
    public string status;
    public string message;
    public MapConfigData data; // La réponse API contient directement la MapConfigData
}

// Structure alternative si l'API retourne data avec un wrapper
[Serializable]
public class ApiQuestResponseWithWrapper
{
    public string status;
    public string message;
    public MapConfigWrapper data; // Si l'API retourne {"data": {"mapConfig": {...}}}
}

[Serializable]
public class VignetteConfig
{
    public float extent;        // Étendue du dégradé
    public float startRadius;   // Point où la transparence commence
    public float curve;         // Courbe du dégradé
    public bool disableMask;    // Désactiver complètement le masque
}

[Serializable]
public class MapDecorativeVideo
{
    public string id;
    public string videoUrl;
    public Vector2Data position;
    public Vector2Data size;
    public bool loop = true;
    public bool autoPlay = true;
    public VignetteConfig vignetteConfig;  // Configuration de vignette spécifique à cette vidéo (optionnel)
}

[Serializable]
public class MapDecorativeImage
{
    public string id;
    public string imageUrl;
    public Vector2Data position;
    public Vector2Data size;
    public int sortingOrder = 5;
}

[Serializable]
public class MapConfigData
{
    public MapBackgroundConfig background;
    public ZoneDecorator zoneDecorator;
    // NOTE: header supprimé - maintenant géré par HeaderManager avec defaultHeaderConfig depuis general-config.json
    public MapPopupConfig popupConfig;
    public VignetteConfig vignetteConfig;  // Configuration de vignette globale pour toutes les vidéos (optionnel)
    public List<MapDecorativeVideo> decorativeVideos;
    public List<MapStep> steps;  // NOUVEAU: Liste des steps
}

// NOUVEAU: Définition d'un step
[Serializable]
public class MapStep
{
    public string id;
    public string type;  // "zones" ou "fullscreen_video"
    public string nextStepId;  // ID du step suivant (null si c'est le dernier)

    // Pour type = "zones"
    public List<MapZone> zones;
    public List<MapDecorativeImage> decorativeImages;  // Images décoratives spécifiques à ce step

    // Pour type = "fullscreen_video"
    public string videoUrl;
    public bool skipable = true;
    public bool autoAdvance = true;  // Passer au step suivant automatiquement à la fin
}

[Serializable]
public class MapBackgroundConfig
{
    public string type;
    public string url;
}

// NOTE: MapHeaderConfig et MapHeaderElement supprimés - maintenant géré par HeaderManager avec DefaultHeaderConfig depuis general-config.json

[Serializable]
public class MapPopupConfig
{
    public int width = 500;
    public int height = 500;
    public string backgroundColor = "#000000EE";
    public string borderColor = "#FFFFFF";
    public int borderWidth = 3;
    public string textPosition = "top";
    public int textHeight = 100;
    public float textPaddingTop = 5f;
    public float textPaddingBottom = 5f;
    public float textPaddingLeft = 10f;
    public float textPaddingRight = 10f;
    public int textFontSize = 22;
    public string textColor = "#FFFFFF";
    public string textBackgroundColor = "#2A2A2ACC";
    public int textPaddingHorizontal = 0;
    public float showDelay = 0.3f;
    public float fadeSpeed = 0.2f;
    public string buttonText = "JOUER";
    public int buttonBottomMargin = 20;
    public string buttonStyle = "validationDefault"; // Style de bouton depuis general-config
}

[Serializable]
public class MapZone
{
    public string id;
    public Vector2Data position;
    public Vector2Data size;
    public string targetLevelId;
    public int gameId; // ID numérique du jeu pour l'API /api/ujsa/games/{gameId}
    public string debugColor;
    public bool hasPopup;
    public string popupVideo;
    public string popupText;
    public bool popupClickable;
    public string buttonText;
    public bool directClick; // Si true, va directement au jeu sans afficher la popup (même si hasPopup est true)
    public string decoratorImageUrl;
    public Vector2Data decoratorSize;
    public string gameType; // "shooting", "calculator", "trous" - Optional: auto-detect if not specified
}

[Serializable]
public class Vector2Data
{
    public float x;
    public float y;

    public Vector2 ToVector2()
    {
        return new Vector2(x, y);
    }
}

[Serializable]
public class ZoneDecorator
{
    public string imageUrl;
    public Vector2Data size;
    public int sortingOrder = 10;
}