using UnityEngine;
using UnityEngine.UI;

public class MapZoneClickable : MonoBehaviour
{
    private MapZone zoneData;
    private MapManager mapManager;
    private RectTransform rectTransform;
    private Image debugImage;

    public void Initialize(MapZone data, MapManager manager)
    {
        zoneData = data;
        mapManager = manager;
        rectTransform = GetComponent<RectTransform>();
        debugImage = GetComponent<Image>();

        // IMPORTANT : Ne pas toucher la couleur si l'image a déjà un sprite (decorator)
        // Sinon on applique la couleur de debug qui rend les sprites semi-transparents
        if (debugImage != null && debugImage.sprite == null && !string.IsNullOrEmpty(data.debugColor))
        {
            if (ColorUtility.TryParseHtmlString(data.debugColor, out Color debugColor))
            {
                debugImage.color = debugColor;
            }
        }
    }

    public bool IsPointInside(Vector2 screenPoint)
    {
        return RectTransformUtility.RectangleContainsScreenPoint(rectTransform, screenPoint, null);
    }

    public void OnClick()
    {
        if (mapManager != null && zoneData != null && !zoneData.hasPopup && !string.IsNullOrEmpty(zoneData.targetLevelId))
        {
            mapManager.LaunchLevel(zoneData.targetLevelId);
        }
    }

    public MapZone GetZoneData()
    {
        return zoneData;
    }
}