# 🍎 Guide Complet Mac - Configuration et Dépannage

**Version** : 2.0 (Novembre 2025)  
**Compatibilité** : macOS 10.15+, Unity 2021.3+

---

## 📋 Table des Matières

1. [Configuration du Build Mac](#-configuration-du-build-mac)
2. [Problèmes Connus et Solutions](#-problèmes-connus-et-solutions)
3. [Gestion des Résolutions et Ratios](#-gestion-des-résolutions-et-ratios)
4. [Tests et Validation](#-tests-et-validation)

---

## ⚙️ Configuration du Build Mac

### Paramètres Player Settings

**Edit → Project Settings → Player → Mac (🍎)**

```
✅ Fullscreen Mode: Fullscreen Window (recommandé)
   Ou Exclusive Fullscreen (selon préférence)
   
✅ Default Screen Width: 1920
✅ Default Screen Height: 1080
✅ Resizable Window: Coché
✅ Use Player Log: Coché (pour debug)
✅ Run In Background: Coché
```

### Scènes à Inclure

**File → Build Settings**

```
☑ menu.unity        (index 0)
☑ Map.unity         (index 1)
☑ Player.unity      (index 2)
☑ shooting.unity    (optionnel)
☑ calculator.unity  (optionnel)
```

---

## 🐛 Problèmes Connus et Solutions

### Problème #1 : Crosshair et Gun Invisibles

**Symptôme** : Les sprites du viseur et du pistolet ne s'affichent pas sur Mac.

**Cause** : `UnityWebRequest` échoue avec `file:///` sur macOS (erreur 404).

**Solution** : Le système détecte automatiquement Mac et utilise `File.ReadAllText()` à la place.

**Vérification dans les logs** :
```
[GeneralConfigManager] 🍎 Détection Mac/iOS - Utilisation de File.ReadAllText
[GeneralConfigManager] ✅ Configuration chargée avec succès (Mac/iOS)!
[MacImageLoader] ✅ Texture chargée: 512x512
[CrosshairManager] ✅ Sprite appliqué et rendu visible
```

**Si le problème persiste** :
1. Vérifier que `general-config.json` existe dans `StreamingAssets/`
2. Appuyer sur **F11** dans le build pour relancer le diagnostic
3. Consulter `~/Library/Logs/[Company]/[Product]/Player.log`

---

### Problème #2 : Voile Blanc sur les Dialogues

**Symptôme** : Un voile blanc opaque apparaît par-dessus les vidéos de dialogue.

**Cause** : Problème de rendu avec Metal (API graphique Mac) - Les overlays blancs ne deviennent pas transparents automatiquement.

**Solution** : Script `MacCompatibilityFix` ajouté automatiquement.

**Installation manuelle (si nécessaire)** :

1. **Ouvrir la scène Player** dans Unity
2. **Créer un GameObject vide** : `MacCompatibilityManager`
3. **Ajouter le script** : `MacCompatibilityFix`
4. **Configurer** :
   - ✅ Enable Diagnostic: true
   - ✅ Fix White Veil: true
   - ✅ Fix Missing Assets: true
   - ✅ Fix Canvas Order: true
5. **Sauvegarder** : Ctrl+S

**Touche de debug** : Appuyer sur **F11** pendant un dialogue pour relancer le fix.

**Logs attendus** :
```
[MacFix] 🔧 Recherche du voile blanc...
[MacFix] ✅ Correction de l'alpha de OverlayPanel
```

---

### Problème #3 : Zones de Réponse Décalées en Plein Écran

**Symptôme** : Sur MacBook (ratio 16:10), les zones cliquables ne correspondent pas au viseur.

**Cause** : Différence entre le ratio de l'écran (16:10) et du jeu (16:9).

**Solution** : Utiliser le système de letterbox pour forcer le ratio 16:9.

---

## 🖥️ Gestion des Résolutions et Ratios

### Solution A : Forcer 1920×1080 (Simple)

**Avantages** :
- ✅ Élimine les problèmes de scaling
- ✅ Coordonnées directes
- ✅ Simple à configurer

**Inconvénients** :
- ⚠️ Peut être flou sur écrans Retina
- ⚠️ Moins flexible

**Configuration** :

Dans la scène `shooting` ou `Player` :

1. Créer un GameObject vide : `ResolutionManager`
2. Ajouter le script : `ForceResolution`
3. Configurer :
   - ✅ Force Resolution: true
   - Target Width: 1920
   - Target Height: 1080
   - Fullscreen: true
   - ✅ Show Debug Logs: true (pour test)

**Logs attendus** :
```
[ForceResolution] Résolution forcée à 1920x1080
[ForceResolution] Ratio final: 1.778 (16:9)
```

---

### Solution B : Letterbox/Pillarbox (Professionnel) ⭐ RECOMMANDÉ

**Avantages** :
- ✅ Ratio constant 16:9 sur tous les écrans
- ✅ Zones fonctionnent toujours
- ✅ Rendu professionnel (comme Netflix, AAA)
- ✅ S'adapte automatiquement

**Configuration** :

Sur la **caméra principale** des scènes `shooting` et `calculator` :

1. Sélectionner `Main Camera`
2. Add Component → `CameraAspectRatioEnforcer`
3. Configurer (défaut OK) :
   - Target Aspect Width: 16
   - Target Aspect Height: 9
   - Letterbox Color: Noir (0, 0, 0, 255)
   - ✅ Show Debug Logs: true

**Résultat** :
- **MacBook 16:10** → Bandes horizontales (haut/bas)
- **Écran ultra-wide 21:9** → Bandes verticales (gauche/droite)
- **Écran 16:9** → Aucune bande, plein écran parfait

**Logs attendus** :
```
[AspectRatio] Écran: 2560x1600, Ratio: 1.600
[AspectRatio] Cible: 1.778
[AspectRatio] Letterboxes (barres horizontales)
```

---

## ✅ Tests et Validation

### Checklist Avant Build

**Configuration** :
- [ ] Player Settings Mac configurés (1920×1080, Fullscreen Window)
- [ ] Toutes les scènes dans Build Settings
- [ ] `general-config.json` présent dans StreamingAssets
- [ ] Scripts Mac ajoutés aux scènes concernées

**Scripts à vérifier** :
- [ ] `GeneralConfigManager` dans chaque scène
- [ ] `MacCompatibilityFix` dans scène Player (si voile blanc)
- [ ] `CameraAspectRatioEnforcer` sur caméras (recommandé)
- [ ] `ForceResolution` dans scène shooting (alternatif)

### Tests dans l'Éditeur

1. **Mode Play** avec ratio Mac :
   - Onglet Game → Dropdown → Choisir **16:10**
   - Observer les letterboxes (si script Aspect Ratio actif)
   - Tester les zones de réponse

2. **Vérifier les logs** :
   ```
   [GeneralConfigManager] ✅ Configuration chargée
   [GameManager] ✅ Résolution de référence: 1920x1080
   ```

### Tests sur Mac Build

1. **Build & Run**
2. **Observer au démarrage** :
   - Résolution affichée (si debug actif)
   - Presence de letterboxes (si ratio 16:10)
3. **Tester les fonctionnalités** :
   - Crosshair visible et suit la souris
   - Gun visible en bas à droite
   - Zones cliquables répondent correctement
   - Dialogues sans voile blanc
4. **Tester les touches de debug** :
   - **F11** : Diagnostic Mac / Fix voile blanc
   - **F12** : Diagnostic map (si applicable)
   - **Cmd+F** : Toggle fullscreen/windowed

### Consulter les Logs Mac

Les logs se trouvent dans :
```
~/Library/Logs/[CompanyName]/[ProductName]/Player.log
```

**Pour y accéder** :
1. Finder → Menu **Go** (Aller)
2. Maintenir **Option** (⌥) → Cliquer **Library**
3. Naviguer vers `Logs/[VotreCompany]/[VotreJeu]/Player.log`

---

## 🔍 Diagnostic Rapide

| Symptôme | Cause Probable | Solution Rapide |
|----------|---------------|-----------------|
| Crosshair invisible | Config non chargée | Vérifier logs : chercher `🍎 Détection Mac` |
| Voile blanc dialogues | Metal rendering issue | Ajouter `MacCompatibilityFix`, F11 dans jeu |
| Zones décalées | Mauvais ratio | Utiliser `CameraAspectRatioEnforcer` |
| Écran noir sur map | Config non chargée | Vérifier `GeneralConfigManager` dans scène |
| Flou en plein écran | Résolution native | Utiliser letterbox au lieu de forcer 1920x1080 |

---

## 📊 Résumé des Corrections Appliquées

### Version 2.0 (Octobre-Novembre 2025)

✅ **Détection Mac Runtime** : 
- `GeneralConfigManager` détecte automatiquement Mac
- Utilise `File.ReadAllText()` au lieu de `UnityWebRequest`

✅ **Fix Voile Blanc** :
- Script `MacCompatibilityFix` force alpha à 0 sur overlays
- Touche F11 pour relancer en jeu

✅ **Fix Zones Décalées** :
- Script `CameraAspectRatioEnforcer` force ratio 16:9
- Letterboxes automatiques selon l'écran

✅ **Logging Amélioré** :
- Tags `[Mac]` dans tous les logs spécifiques
- Debug F11/F12 pour diagnostic

---

## 💡 Bonnes Pratiques

### Pour Développeurs

1. **Toujours tester** sur un MacBook réel avant release
2. **Activer les logs** pendant la phase de test
3. **Utiliser letterbox** pour compatibilité maximale
4. **Vérifier Player.log** en cas de problème

### Pour Build Production

1. **Désactiver** les debug logs :
   - `Show Debug Logs` = false
   - `Enable Diagnostic` = false
2. **Garder actifs** :
   - `MacCompatibilityFix` (fixes automatiques)
   - `CameraAspectRatioEnforcer` (ratio constant)
3. **Tester** sur plusieurs résolutions Mac si possible

---

## 🆘 Support

Si les problèmes persistent après avoir suivi ce guide :

**Informations à fournir** :
1. Modèle de MacBook et résolution native
2. Version de macOS
3. Logs complets du `Player.log`
4. Logs spécifiques :
   - `[GeneralConfigManager]`
   - `[MacFix]`
   - `[AspectRatio]`
   - `[TargetZone/MAC]`
5. Description précise du problème

---

**Document créé** : Novembre 2025  
**Version** : 2.0  
**Auteur** : Synthèse des corrections Mac  
**Statut** : ✅ Testé et validé sur macOS

