# Modifications de la Scène MENU - Migration vers les API

## Résumé des changements

La scène MENU a été modifiée pour charger la mosaïque des jeux directement depuis les API au lieu du fichier `jeux.csv`. La mosaïque affiche maintenant :
- Les **intros** de chaque quête (vidéos d'introduction)
- Les **jeux** de chaque quête (zones interactives)
- Les **outros** de chaque quête (vidéos de fin)

## Fichiers modifiés

### 1. `Assets/Scripts/Data/GameEntry.cs`
**Nouveaux champs ajoutés :**
- `questId` : ID de la quête à laquelle appartient le jeu
- `questTitle` : Titre de la quête
- `isIntro` : Indique si c'est une intro de quête
- `isOutro` : Indique si c'est un outro de quête
- `positionInQuest` : Position du jeu dans la quête (1, 2, 3...) - 0 pour intro/outro
- `totalGamesInQuest` : Nombre total de jeux dans la quête (sans compter intro/outro)
- `isSeparator` : Indique si c'est un séparateur vide entre les quêtes

**Nouveaux types de jeux supportés :**
- `intro_video` : Vidéo d'introduction de quête
- `outro_video` : Vidéo de fin de quête
- `separator` : Case vide entre les quêtes
- `trous` : Jeux de texte à trous (alias de `text_hole`)

### 2. `Assets/Scripts/MainMenuManager.cs`
**Nouvelle méthode principale :**
- `LoadGamesFromAPI()` : Remplace `LoadGamesFromCSV()`
  - Charge la liste des quêtes depuis `{{baseUrl}}/api/ujsa/projects/{{projectSlug}}`
  - Pour chaque quête accessible (`has_access = true`), charge les détails depuis `{{baseUrl}}/api/ujsa/quests/{{questId}}`
  - Extrait tous les jeux (intro, zones, outro) de chaque quête
  - **Ajoute un séparateur vide entre chaque quête** (sauf avant la première)

**Méthode d'extraction des jeux :**
- `LoadGamesFromQuest(quest, token)` : Charge et extrait les jeux d'une quête spécifique
  - **Compte d'abord le nombre total de jeux** dans la quête (zones uniquement)
  - Détecte les intros (premier step de type `fullscreen_video`)
  - Extrait les jeux des zones (steps de type `zones`) avec leur **position** (1/N, 2/N...)
  - Détecte les outros (dernier step de type `fullscreen_video`)

**Affichage des cartes :**
- **Jeux normaux** : Affichent leur position dans la quête (ex: "1/10", "2/10"...)
- **Intro/Outro** : Affichent leur type ("INTRO", "OUTRO") sans position
- **Séparateurs** : Cases vides et inactives (transparentes) entre les quêtes
- **Organisation** : Chaque intro commence au début d'une nouvelle ligne
  - Des séparateurs sont ajoutés automatiquement pour remplir la ligne précédente
  - Facilite l'identification visuelle de chaque quête

**Nouvelle couleur ajoutée :**
- `introOutroColor` : Couleur bleue pour les cartes intro/outro (0.2, 0.5, 0.8, 1)

**Méthode conservée pour rétrocompatibilité :**
- `LoadGamesFromCSV()` : Ancienne méthode conservée mais non utilisée

### 3. `Assets/Scripts/GameCard.cs`
**Modifications :**
- Ajout du champ `introOutroColor` dans les couleurs disponibles
- Mise à jour de `GetTypeColor()` pour gérer les types `intro_video`, `outro_video` et `trous`

## Flux de chargement des jeux

```
1. InitializeMenu()
   ↓
2. LoadGamesFromAPI()
   ↓
3. Appel API: {{baseUrl}}/api/ujsa/projects/{{projectSlug}}
   → Récupère la liste des quêtes
   ↓
4. Pour chaque quête accessible:
   ↓
5. LoadGamesFromQuest(quest, token)
   ↓
6. Appel API: {{baseUrl}}/api/ujsa/quests/{{questId}}
   → Récupère les steps de la quête
   ↓
7. Extraction des jeux:
   - Premier step de type "fullscreen_video" → INTRO (position: 0)
   - Chaque zone des steps de type "zones" → JEU (position: 1, 2, 3...)
   - Dernier step de type "fullscreen_video" → OUTRO (position: 0)
   ↓
8. Ajout d'un SÉPARATEUR après chaque quête (sauf la dernière)
   ↓
9. Ajout à gameEntries[]
   ↓
10. GenerateGameCards()
   → Création de la mosaïque visuelle avec positions
```

## Structure des données

### Entrée de jeu (GameEntry)
```csharp
{
    id: int,                  // ID du jeu pour l'API (ou calculé pour intro/outro)
    title: string,            // Titre affiché sur la carte
    type: string,             // "shooting", "text_hole", "calculator", "intro_video", "outro_video", "separator"
    questId: int,             // ID de la quête parente
    questTitle: string,       // Titre de la quête parente
    isIntro: bool,            // true si c'est une intro
    isOutro: bool,            // true si c'est un outro
    isSeparator: bool,        // true si c'est un séparateur entre quêtes
    positionInQuest: int,     // Position dans la quête (1, 2, 3...) - 0 pour intro/outro
    totalGamesInQuest: int    // Nombre total de jeux dans la quête
}
```

### Affichage des cartes

**Jeux normaux :**
- Affichent le titre du jeu
- Affichent leur position : `1/10`, `2/10`, `3/10`...
- Couleur selon le type (violet, doré, vert)

**Intro/Outro :**
- Affichent le titre avec "INTRO" ou "OUTRO"
- Affichent le type ("INTRO" ou "OUTRO") au lieu de la position
- Couleur bleue spécifique

**Séparateurs :**
- Case vide (transparente à 30%)
- Non cliquable
- Permettent de séparer visuellement les quêtes
- **Remplissent automatiquement les lignes** pour que chaque intro commence en début de ligne

### Organisation de la mosaïque

**Principe :**
- Chaque **intro de quête** commence toujours au **début d'une nouvelle ligne**
- Des **séparateurs vides** sont ajoutés automatiquement pour compléter la ligne précédente
- Facilite l'identification visuelle de chaque quête

**Exemple avec une grille de 6 colonnes :**

```
Ligne 1: [Q1-INTRO]  [Q1-1/10]  [Q1-2/10]  [Q1-3/10]  [Q1-4/10]  [Q1-5/10]
Ligne 2: [Q1-6/10]   [Q1-7/10]  [Q1-8/10]  [Q1-9/10]  [Q1-10/10] [Q1-OUTRO]

Ligne 3: [Q2-INTRO]  [Q2-1/8]   [Q2-2/8]   [Q2-3/8]   [Q2-4/8]   [Q2-5/8]
Ligne 4: [Q2-6/8]    [Q2-7/8]   [Q2-8/8]   [Q2-OUTRO] [VIDE]     [VIDE]

Ligne 5: [Q3-INTRO]  [Q3-1/12]  [Q3-2/12]  [Q3-3/12]  [Q3-4/12]  [Q3-5/12]
...
```

**Légende :**
- `[Qn-INTRO]` : Intro de la quête n (toujours en début de ligne)
- `[Qn-X/Y]` : Jeu X sur Y de la quête n (affiche la position)
- `[Qn-OUTRO]` : Outro de la quête n
- `[VIDE]` : Case séparateur (transparente, non cliquable)

### IDs des intro/outro
Pour éviter les conflits d'ID, les intro/outro utilisent des IDs calculés :
- **Intro** : `questId * 10000 + 1`
- **Outro** : `questId * 10000 + 9999`

## Avantages de cette approche

1. **Données toujours à jour** : Plus besoin de maintenir un fichier CSV manuel
2. **Respect des permissions** : Seules les quêtes accessibles (`has_access = true`) sont affichées
3. **Vue complète** : Les joueurs peuvent voir et accéder aux intro/outro de chaque quête
4. **Cohérence** : Utilise les mêmes endpoints que le reste de l'application

## Points d'attention

1. **Authentification requise** : L'utilisateur doit être connecté pour voir la mosaïque
2. **Gestion du cache** : Si les données API changent, un rechargement de la page peut être nécessaire
3. **Fallback CSV** : La méthode `LoadGamesFromCSV()` est conservée mais n'est plus utilisée par défaut

## Compatibilité

- ✅ Rétrocompatible : Les anciens types de jeux fonctionnent toujours
- ✅ Nouveaux types : Support complet des intro/outro vidéo
- ✅ Couleurs : Nouvelle couleur bleue pour distinguer intro/outro des jeux
- ✅ Lancement : Le système de lancement des jeux reste inchangé

## Dépendances API

Les endpoints suivants doivent être disponibles et fonctionnels :
- `{{baseUrl}}/api/ujsa/projects/{{projectSlug}}` : Liste des quêtes du projet
- `{{baseUrl}}/api/ujsa/quests/{{questId}}` : Détails d'une quête (steps, zones, etc.)

Ces endpoints sont configurés dans `general-config.json` via le champ `slug`.
