#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
Script pour corriger les chemins des impacts dans tous les fichiers de jeu
"""

import json
import os
from pathlib import Path

def fix_impact_paths(json_folder):
    """
    Corrige les chemins des impacts dans tous les fichiers Q*.json
    """
    json_path = Path(json_folder)
    
    # Chercher tous les fichiers Q*.json
    game_files = list(json_path.glob("Q*.json"))
    
    print(f"[OK] Trouve {len(game_files)} fichiers de jeu a traiter\n")
    
    modified_count = 0
    
    for json_file in game_files:
        try:
            # Lire le fichier
            with open(json_file, 'r', encoding='utf-8') as f:
                data = json.load(f)
            
            modified = False
            
            # Vérifier si le fichier a des assets avec impact
            if 'gameConfig' in data and 'assets' in data['gameConfig']:
                assets = data['gameConfig']['assets']
                
                # Corriger le chemin de l'impact
                if 'impact' in assets:
                    impact_file = assets['impact']
                    # Si le chemin ne contient pas déjà "impacts/", l'ajouter
                    if impact_file and not impact_file.startswith('impacts/') and not impact_file.startswith('http'):
                        assets['impact'] = f"impacts/{impact_file}"
                        modified = True
                        print(f"[OK] {json_file.name}: impact corrige -> impacts/{impact_file}")
            
            # Sauvegarder si modifié
            if modified:
                with open(json_file, 'w', encoding='utf-8') as f:
                    json.dump(data, f, indent=4, ensure_ascii=False)
                modified_count += 1
        
        except Exception as e:
            print(f"[ERREUR] Erreur avec {json_file.name}: {e}")
    
    print(f"\n[OK] {modified_count} fichiers modifies sur {len(game_files)}")

if __name__ == "__main__":
    # Dossier contenant les JSONs de jeu
    json_folder = r"d:\UJSA_IA\septembre\Assets\StreamingAssets\json"
    
    print("="*50)
    print("   CORRECTION DES CHEMINS D'IMPACTS")
    print("="*50)
    print()
    
    fix_impact_paths(json_folder)
    
    print()
    print("="*50)
    print("   TERMINÉ")
    print("="*50)

