#if UNITY_EDITOR
using UnityEngine;
using UnityEditor;
using UnityEditor.SceneManagement;
using UnityEngine.SceneManagement;

/// <summary>
/// Outil Editor pour créer la scène d'intro du jeu
/// Menu: Tools > Créer Scène Intro
/// </summary>
public class IntroSceneCreator : Editor
{
    [MenuItem("Tools/UJSA/Créer Scène Intro")]
    public static void CreateIntroScene()
    {
        // Créer une nouvelle scène
        Scene newScene = EditorSceneManager.NewScene(NewSceneSetup.DefaultGameObjects, NewSceneMode.Single);
        
        // Renommer la scène
        EditorSceneManager.SaveScene(newScene, "Assets/Scenes/Intro.unity");
        
        // Configurer la caméra principale
        Camera mainCamera = Camera.main;
        if (mainCamera != null)
        {
            mainCamera.clearFlags = CameraClearFlags.SolidColor;
            mainCamera.backgroundColor = Color.black;
            mainCamera.orthographic = false;
            
            // Ajouter AudioListener si pas présent
            if (mainCamera.GetComponent<AudioListener>() == null)
            {
                mainCamera.gameObject.AddComponent<AudioListener>();
            }
        }
        
        // Créer le GameObject principal avec IntroScreenManager
        GameObject introManager = new GameObject("IntroScreenManager");
        IntroScreenManager manager = introManager.AddComponent<IntroScreenManager>();
        
        // Configuration par défaut
        manager.videoFileName = "lancement.mp4";
        manager.nextSceneName = "main";
        manager.titleFontSize = 80f;
        manager.lineSpacing = 0f;
        manager.titleAppearDelay = 1.0f;
        manager.titleFadeDuration = 2.0f;
        manager.buttonAppearDelay = 3.0f;
        manager.buttonFadeDuration = 1.0f;
        manager.buttonBottomMargin = 100f;
        
        // Sélectionner l'objet créé
        Selection.activeGameObject = introManager;
        
        // Sauvegarder la scène
        EditorSceneManager.SaveScene(newScene);
        
        // Ajouter la scène aux Build Settings si pas déjà présente
        AddSceneToBuildSettings("Assets/Scenes/Intro.unity");
        
        Debug.Log("✅ Scène Intro créée avec succès !");
        Debug.Log("📋 Configuration:");
        Debug.Log("   - Vidéo: StreamingAssets/videos/lancement.mp4");
        Debug.Log("   - Scène suivante: main");
        Debug.Log("   - Police: Anton-Regular SDF (80px, blanc)");
        Debug.Log("   - Titre: UN JOUR SANS\\nASSURANCE");
        Debug.Log("   - Bouton COMMENCER après 3 secondes");
        Debug.Log("\n💡 Pour tester: Lance la scène dans l'éditeur !");
        
        EditorUtility.DisplayDialog(
            "Scène Intro créée", 
            "La scène Intro a été créée avec succès !\n\n" +
            "• Vidéo: lancement.mp4\n" +
            "• Titre: UN JOUR SANS ASSURANCE\n" +
            "• Police: Anton-Regular SDF\n" +
            "• Bouton COMMENCER (style validationDefault)\n" +
            "• Clic pour passer à la scène 'main'\n\n" +
            "Lance la scène pour tester !",
            "OK"
        );
    }
    
    static void AddSceneToBuildSettings(string scenePath)
    {
        // Vérifier si la scène est déjà dans les Build Settings
        EditorBuildSettingsScene[] scenes = EditorBuildSettings.scenes;
        
        foreach (var scene in scenes)
        {
            if (scene.path == scenePath)
            {
                Debug.Log($"[IntroSceneCreator] La scène {scenePath} est déjà dans les Build Settings");
                return;
            }
        }
        
        // Ajouter la scène en première position (index 0)
        EditorBuildSettingsScene[] newScenes = new EditorBuildSettingsScene[scenes.Length + 1];
        newScenes[0] = new EditorBuildSettingsScene(scenePath, true);
        
        for (int i = 0; i < scenes.Length; i++)
        {
            newScenes[i + 1] = scenes[i];
        }
        
        EditorBuildSettings.scenes = newScenes;
        Debug.Log($"[IntroSceneCreator] ✅ Scène {scenePath} ajoutée aux Build Settings en première position");
    }
    
    [MenuItem("Tools/UJSA/Ouvrir Scène Intro")]
    public static void OpenIntroScene()
    {
        string scenePath = "Assets/Scenes/Intro.unity";
        
        if (System.IO.File.Exists(scenePath))
        {
            EditorSceneManager.OpenScene(scenePath);
        }
        else
        {
            EditorUtility.DisplayDialog(
                "Scène introuvable", 
                "La scène Intro n'existe pas encore.\n\nUtilisez 'Tools > UJSA > Créer Scène Intro' pour la créer.",
                "OK"
            );
        }
    }
}
#endif

