# Script de rÃ©initialisation des PlayerPrefs pour la Map
# Utiliser ce script pour tester le fix du CurrentMapId

Write-Host ""
Write-Host "â•”â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•—" -ForegroundColor Cyan
Write-Host "â•‘  RÃ‰INITIALISATION DES PLAYERPREFS MAP            â•‘" -ForegroundColor Cyan
Write-Host "â•šâ•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•" -ForegroundColor Cyan
Write-Host ""
Write-Host "Ce script va vous aider Ã  tester le fix du CurrentMapId" -ForegroundColor Yellow
Write-Host ""
Write-Host "âš ï¸  ATTENTION : Fermez Unity avant de continuer!" -ForegroundColor Red
Write-Host ""

$choice = Read-Host "Voulez-vous continuer? (O/N)"

if ($choice -ne "O" -and $choice -ne "o") {
    Write-Host ""
    Write-Host "âŒ AnnulÃ©" -ForegroundColor Red
    exit
}

Write-Host ""
Write-Host "ðŸ“ Choisissez une option:" -ForegroundColor Cyan
Write-Host ""
Write-Host "1. RÃ©initialiser TOUTES les maps (recommandÃ© pour les tests)" -ForegroundColor White
Write-Host "2. RÃ©initialiser map-Q1 uniquement" -ForegroundColor White
Write-Host "3. RÃ©initialiser map-Q0 uniquement" -ForegroundColor White
Write-Host "4. Voir les PlayerPrefs actuels (sans supprimer)" -ForegroundColor White
Write-Host ""

$option = Read-Host "Votre choix (1-4)"

Write-Host ""
Write-Host "â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•" -ForegroundColor Gray
Write-Host ""

# Les PlayerPrefs Unity sous Windows sont dans le registre
$registryPath = "HKCU:\Software\Studio PLC\UnJourSansAssurance"

function Show-PlayerPrefs {
    Write-Host "ðŸ” PlayerPrefs actuels:" -ForegroundColor Cyan
    Write-Host ""
    
    if (Test-Path $registryPath) {
        Get-ItemProperty $registryPath | Format-List
    } else {
        Write-Host "âŒ Aucun PlayerPrefs trouvÃ©" -ForegroundColor Red
    }
}

function Reset-MapPlayerPrefs {
    param([string]$mapId)
    
    if (-not (Test-Path $registryPath)) {
        Write-Host "âŒ Aucun PlayerPrefs trouvÃ© pour ce jeu" -ForegroundColor Red
        return
    }
    
    $keys = @(
        "IntroWatched_$mapId",
        "CurrentStepId_$mapId",
        "NextStepId_$mapId"
    )
    
    Write-Host "ðŸ—‘ï¸  Suppression des clÃ©s pour $mapId..." -ForegroundColor Yellow
    
    foreach ($key in $keys) {
        try {
            Remove-ItemProperty -Path $registryPath -Name $key -ErrorAction SilentlyContinue
            Write-Host "   âœ… $key supprimÃ©" -ForegroundColor Green
        } catch {
            Write-Host "   âš ï¸  $key n'existait pas" -ForegroundColor Gray
        }
    }
}

function Reset-AllMapsPlayerPrefs {
    if (-not (Test-Path $registryPath)) {
        Write-Host "âŒ Aucun PlayerPrefs trouvÃ© pour ce jeu" -ForegroundColor Red
        return
    }
    
    Write-Host "ðŸ—‘ï¸  Suppression de TOUTES les clÃ©s Map..." -ForegroundColor Yellow
    
    $allKeys = Get-ItemProperty $registryPath
    
    $mapKeys = $allKeys.PSObject.Properties | Where-Object { 
        $_.Name -match "^(IntroWatched_|CurrentStepId_|NextStepId_|CurrentMapId)" 
    }
    
    foreach ($prop in $mapKeys) {
        try {
            Remove-ItemProperty -Path $registryPath -Name $prop.Name -ErrorAction SilentlyContinue
            Write-Host "   âœ… $($prop.Name) supprimÃ©" -ForegroundColor Green
        } catch {
            Write-Host "   âš ï¸  Erreur: $($prop.Name)" -ForegroundColor Gray
        }
    }
}

switch ($option) {
    "1" {
        Write-Host "ðŸ”„ RÃ©initialisation de TOUTES les maps..." -ForegroundColor Cyan
        Reset-AllMapsPlayerPrefs
        Write-Host ""
        Write-Host "âœ… Toutes les maps ont Ã©tÃ© rÃ©initialisÃ©es!" -ForegroundColor Green
    }
    "2" {
        Write-Host "ðŸ”„ RÃ©initialisation de map-Q1..." -ForegroundColor Cyan
        Reset-MapPlayerPrefs "map-Q1"
        Write-Host ""
        Write-Host "âœ… map-Q1 rÃ©initialisÃ©e!" -ForegroundColor Green
    }
    "3" {
        Write-Host "ðŸ”„ RÃ©initialisation de map-Q0..." -ForegroundColor Cyan
        Reset-MapPlayerPrefs "map-Q0"
        Write-Host ""
        Write-Host "âœ… map-Q0 rÃ©initialisÃ©e!" -ForegroundColor Green
    }
    "4" {
        Show-PlayerPrefs
    }
    default {
        Write-Host "âŒ Option invalide" -ForegroundColor Red
        exit
    }
}

Write-Host ""
Write-Host "â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•â•" -ForegroundColor Gray
Write-Host ""
Write-Host "ðŸ“ Prochaines Ã©tapes:" -ForegroundColor Cyan
Write-Host ""
Write-Host "1. âœ… Ouvrez Unity" -ForegroundColor White
Write-Host "2. âœ… Lancez le jeu (Play)" -ForegroundColor White
Write-Host "3. âœ… Allez sur la Map" -ForegroundColor White
Write-Host "4. âœ… Cliquez sur une zone de niveau" -ForegroundColor White
Write-Host "5. âœ… Terminez le jeu et le dialogue final" -ForegroundColor White
Write-Host "6. âœ… VÃ©rifiez que vous revenez bien sur la Map!" -ForegroundColor White
Write-Host ""
Write-Host "ðŸ“– Logs Ã  surveiller dans Unity Console:" -ForegroundColor Cyan
Write-Host "   [MapManager] âœ… CurrentMapId sauvegardÃ©: map-Q1" -ForegroundColor Gray
Write-Host "   [LevelManager] ReturnToMap - CurrentMapId rÃ©cupÃ©rÃ©: 'map-Q1'" -ForegroundColor Gray
Write-Host ""
Write-Host "ðŸ”§ Documentation complÃ¨te:" -ForegroundColor Cyan
Write-Host "   docs/FIX_CURRENTMAPID_MANQUANT.md" -ForegroundColor Gray
Write-Host ""
