using UnityEngine;

/// <summary>
/// Script de diagnostic pour comprendre pourquoi l'intro ne se joue pas
/// À attacher à un GameObject dans la scène Map
/// </summary>
public class DiagnosticMapIntro : MonoBehaviour
{
    void Start()
    {
        Debug.Log("========================================");
        Debug.Log("=== DIAGNOSTIC INTRO MAP ===");
        Debug.Log("========================================");
        
        // Vérifier CurrentMapId
        string currentMapId = PlayerPrefs.GetString("CurrentMapId", "VIDE");
        Debug.Log($"CurrentMapId = '{currentMapId}'");
        
        // Vérifier les clés pour map-Q1
        string mapId = "map-Q1";
        int introWatched = PlayerPrefs.GetInt($"IntroWatched_{mapId}", -1);
        string currentStepId = PlayerPrefs.GetString($"CurrentStepId_{mapId}", "VIDE");
        string nextStepId = PlayerPrefs.GetString($"NextStepId_{mapId}", "VIDE");
        
        Debug.Log($"IntroWatched_{mapId} = {introWatched} (0=non vue, 1=vue, -1=pas défini)");
        Debug.Log($"CurrentStepId_{mapId} = '{currentStepId}'");
        Debug.Log($"NextStepId_{mapId} = '{nextStepId}'");
        
        // Analyser
        if (introWatched == 1)
        {
            Debug.LogWarning("⚠️ IntroWatched = 1 → L'intro a déjà été vue et sera sautée !");
            Debug.LogWarning("SOLUTION : Exécutez ces commandes dans la Console :");
            Debug.LogWarning($"PlayerPrefs.DeleteKey(\"IntroWatched_{mapId}\");");
            Debug.LogWarning($"PlayerPrefs.DeleteKey(\"CurrentStepId_{mapId}\");");
            Debug.LogWarning($"PlayerPrefs.DeleteKey(\"NextStepId_{mapId}\");");
            Debug.LogWarning("PlayerPrefs.Save();");
            Debug.LogWarning("Puis rechargez la scène Map");
        }
        else
        {
            Debug.Log("✅ IntroWatched n'est pas défini → L'intro DEVRAIT se jouer");
        }
        
        if (!string.IsNullOrEmpty(currentStepId) && currentStepId != "VIDE")
        {
            Debug.LogWarning($"⚠️ CurrentStepId = '{currentStepId}' → Un step est déjà sauvegardé");
            if (currentStepId != "intro")
            {
                Debug.LogWarning("→ La map ne commencera PAS par l'intro");
            }
        }
        
        // Vérifier ReturnToScene
        string returnToScene = PlayerPrefs.GetString("ReturnToScene", "VIDE");
        Debug.Log($"ReturnToScene = '{returnToScene}'");
        
        Debug.Log("========================================");
    }
}

