using UnityEngine;
using UnityEditor;
using UnityEngine.SceneManagement;
using UnityEditor.SceneManagement;
using System.Linq;

public class TrousSceneLauncher : EditorWindow
{
    [MenuItem("Tools/Trous Scene/Launch Test Scene")]
    public static void LaunchTrousScene()
    {
        // Définir les PlayerPrefs nécessaires
        string configUrl = "STREAMING_ASSETS/json/Q0J8_trous.json";
        PlayerPrefs.SetString("CurrentLevelType", "trous");
        PlayerPrefs.SetString("GameConfigUrl", configUrl);
        PlayerPrefs.SetString("GamePhase", "Shooting");
        PlayerPrefs.Save();
        
        Debug.Log("═══════════════════════════════════════");
        Debug.Log("  LANCEMENT SCÈNE TROUS POUR TEST");
        Debug.Log("═══════════════════════════════════════");
        Debug.Log($"CurrentLevelType: trous");
        Debug.Log($"GameConfigUrl: {configUrl}");
        Debug.Log("═══════════════════════════════════════");
        
        // Charger la scène trous (en mode éditeur, utiliser EditorSceneManager)
        if (Application.isPlaying)
        {
            SceneManager.LoadScene("trous");
        }
        else
        {
            // Chercher la scène trous dans le projet
            string[] sceneGuids = AssetDatabase.FindAssets("trous t:Scene");
            if (sceneGuids.Length > 0)
            {
                string scenePath = AssetDatabase.GUIDToAssetPath(sceneGuids[0]);
                EditorSceneManager.OpenScene(scenePath);
                Debug.Log($"✅ Scène trous ouverte: {scenePath}");
            }
            else
            {
                Debug.LogError("❌ Scène 'trous' introuvable dans le projet. Créez-la d'abord avec Tools → Trous Scene → Generate Scene");
            }
        }
    }
    
    [MenuItem("Tools/Trous Scene/Launch with Q0J8.json")]
    public static void LaunchWithQ0J8()
    {
        // Utiliser Q0J8.json (même s'il est configuré pour shooting, 
        // le TrousGameManager utilisera seulement les champs pertinents)
        string configUrl = "STREAMING_ASSETS/json/Q0J8.json";
        PlayerPrefs.SetString("CurrentLevelType", "trous");
        PlayerPrefs.SetString("GameConfigUrl", configUrl);
        PlayerPrefs.SetString("GamePhase", "Shooting");
        PlayerPrefs.Save();
        
        Debug.Log("═══════════════════════════════════════");
        Debug.Log("  LANCEMENT SCÈNE TROUS AVEC Q0J8.json");
        Debug.Log("═══════════════════════════════════════");
        Debug.Log($"CurrentLevelType: trous");
        Debug.Log($"GameConfigUrl: {configUrl}");
        Debug.Log("═══════════════════════════════════════");
        
        // Charger la scène trous (en mode éditeur, utiliser EditorSceneManager)
        if (Application.isPlaying)
        {
            SceneManager.LoadScene("trous");
        }
        else
        {
            // Chercher la scène trous dans le projet
            string[] sceneGuids = AssetDatabase.FindAssets("trous t:Scene");
            if (sceneGuids.Length > 0)
            {
                string scenePath = AssetDatabase.GUIDToAssetPath(sceneGuids[0]);
                EditorSceneManager.OpenScene(scenePath);
                Debug.Log($"✅ Scène trous ouverte: {scenePath}");
            }
            else
            {
                Debug.LogError("❌ Scène 'trous' introuvable dans le projet. Créez-la d'abord avec Tools → Trous Scene → Generate Scene");
            }
        }
    }
    
    [MenuItem("Tools/Trous Scene/Launch with Q1J8.json")]
    public static void LaunchWithQ1J8()
    {
        // Utiliser Q1J8.json (déjà configuré pour trous)
        string configUrl = "STREAMING_ASSETS/json/Q1J8.json";
        PlayerPrefs.SetString("CurrentLevelType", "trous");
        PlayerPrefs.SetString("GameConfigUrl", configUrl);
        PlayerPrefs.SetString("GamePhase", "Shooting");
        PlayerPrefs.Save();
        
        Debug.Log("═══════════════════════════════════════");
        Debug.Log("  LANCEMENT SCÈNE TROUS AVEC Q1J8.json");
        Debug.Log("═══════════════════════════════════════");
        Debug.Log($"CurrentLevelType: trous");
        Debug.Log($"GameConfigUrl: {configUrl}");
        Debug.Log("═══════════════════════════════════════");
        
        // Charger la scène trous (en mode éditeur, utiliser EditorSceneManager)
        if (Application.isPlaying)
        {
            SceneManager.LoadScene("trous");
        }
        else
        {
            // Chercher la scène trous dans le projet
            string[] sceneGuids = AssetDatabase.FindAssets("trous t:Scene");
            if (sceneGuids.Length > 0)
            {
                string scenePath = AssetDatabase.GUIDToAssetPath(sceneGuids[0]);
                EditorSceneManager.OpenScene(scenePath);
                Debug.Log($"✅ Scène trous ouverte: {scenePath}");
            }
            else
            {
                Debug.LogError("❌ Scène 'trous' introuvable dans le projet. Créez-la d'abord avec Tools → Trous Scene → Generate Scene");
            }
        }
    }
}

