using UnityEngine;
using System;

public class SimpleDropdownWrapper : MonoBehaviour, ITrousDropdownWrapper
{
    public TrousHole hole { get; set; }
    public int index { get; set; }
    
    private Func<string> getSelectedValueFunc;
    private Func<bool> isCorrectFunc;
    
    public void SetGetSelectedValue(Func<string> func)
    {
        getSelectedValueFunc = func;
    }
    
    public void SetIsCorrect(Func<bool> func)
    {
        isCorrectFunc = func;
    }
    
    public string GetSelectedValue()
    {
        return getSelectedValueFunc != null ? getSelectedValueFunc() : "";
    }
    
    public bool IsCorrect()
    {
        return isCorrectFunc != null && isCorrectFunc();
    }
}

