using UnityEngine;
using UnityEngine.UI;

public class LEDTester : MonoBehaviour
{
    public GameObject ledPrefab;
    public Transform ledContainer;
    
    void Start()
    {
        Debug.Log("LEDTester démarré !");
        Debug.Log("Led Prefab assigné : " + (ledPrefab != null ? "OUI" : "NON"));
        Debug.Log("Led Container assigné : " + (ledContainer != null ? "OUI" : "NON"));
        
        // Debug de la position du container
        if (ledContainer != null)
        {
            Debug.Log("Position LEDContainer : " + ledContainer.position);
            Debug.Log("LEDContainer actif ? " + ledContainer.gameObject.activeInHierarchy);
        }
        
        // Créer 3 LEDs de test avec plus de debug
        for (int i = 0; i < 3; i++)
        {
            Debug.Log("Création LED " + (i + 1));
            
            GameObject led = Instantiate(ledPrefab, ledContainer);
            Debug.Log("LED créée : " + led.name);
            Debug.Log("Position LED : " + led.transform.position);
            
            Image ledImage = led.GetComponent<Image>();
            if (ledImage != null)
            {
                // Colorer pour voir la différence
                if (i == 0) ledImage.color = Color.green;
                else if (i == 1) ledImage.color = Color.red; 
                else ledImage.color = Color.gray;
                
                Debug.Log("LED " + (i + 1) + " colorée en : " + ledImage.color);
            }
            else
            {
                Debug.LogError("Pas de composant Image sur la LED !");
            }
        }
        
        Debug.Log("Nombre d'enfants dans LEDContainer : " + ledContainer.childCount);
    }
}