using UnityEngine;
using TMPro;

/// <summary>
/// Composant pour afficher et mettre à jour dynamiquement le statut d'adhésion UJSA
/// </summary>
public class MembershipStatusDisplay : MonoBehaviour
{
    public TextMeshProUGUI statusText;
    
    void OnEnable()
    {
        UpdateStatus();
    }
    
    /// <summary>
    /// Met à jour l'affichage du statut d'adhésion UJSA
    /// </summary>
    public void UpdateStatus()
    {
        if (statusText == null) return;
        
        if (UserDataManager.Instance != null && UserDataManager.Instance.IsLoggedIn())
        {
            bool isUjsaMember = UserDataManager.Instance.isUjsaMembership;
            statusText.text = isUjsaMember ? "Actif" : "Inactif";
            statusText.color = isUjsaMember ? new Color(0.2f, 0.7f, 0.2f, 1f) : new Color(0.7f, 0.2f, 0.2f, 1f);
        }
        else
        {
            statusText.text = "Non connecté";
            statusText.color = new Color(0.5f, 0.5f, 0.5f, 1f);
        }
    }
}

